/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.javalibs.concurrent;

import java.util.concurrent.RecursiveTask;
import org.ocamljava.runtime.kernel.NativeApply;
import org.ocamljava.runtime.values.Value;

final class ForkJoinSplitTask
extends RecursiveTask<Value> {
    static final long serialVersionUID = 0L;
    private final Value fork;
    private final Value join;
    private final Value closure;
    private final Value value;

    ForkJoinSplitTask(Value f, Value j, Value c, Value x) {
        this.fork = f;
        this.join = j;
        this.closure = c;
        this.value = x;
    }

    @Override
    protected Value compute() {
        try {
            Value forkResult = NativeApply.apply(this.fork, this.value);
            if (forkResult.isLong()) {
                Value res = NativeApply.apply(this.closure, this.value);
                return res;
            }
            Value some = forkResult.get0();
            ForkJoinSplitTask sub1 = new ForkJoinSplitTask(this.fork, this.join, this.closure, some.get0());
            sub1.fork();
            ForkJoinSplitTask sub2 = new ForkJoinSplitTask(this.fork, this.join, this.closure, some.get1());
            Value res2 = sub2.compute();
            Value res1 = (Value)sub1.join();
            return NativeApply.apply(this.join, res1, res2);
        }
        catch (Throwable t) {
            this.completeExceptionally(t);
            return null;
        }
    }
}

