/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.support.wrappers;

import org.ocamljava.runtime.support.wrappers.ToValue;
import org.ocamljava.runtime.values.Value;

public final class Option<T extends ToValue>
implements ToValue {
    private final T value;

    public Option() {
        this.value = null;
    }

    public Option(T v) {
        assert (v != null) : "null v";
        this.value = v;
    }

    public boolean isSome() {
        return this.value != null;
    }

    public T get() throws NoValue {
        if (this.value != null) {
            return this.value;
        }
        throw new NoValue();
    }

    @Override
    public Value toValue() {
        if (this.value != null) {
            return Value.createBlock(0, this.value.toValue());
        }
        return Value.ZERO;
    }

    public int hashCode() {
        if (this.value != null) {
            return this.value.hashCode();
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Option) {
            Option that = (Option)obj;
            return this.value == null && that.value == null || this.value != null && this.value.equals(that.value);
        }
        return false;
    }

    public String toString() {
        if (this.value != null) {
            return "Some (" + this.value.toString() + ")";
        }
        return "None";
    }

    public static final class NoValue
    extends RuntimeException {
        static final long serialVersionUID = -4256152597985975470L;

        public NoValue() {
            super("No value");
        }
    }
}

