/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.kernel;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Map;
import org.ocamljava.runtime.annotations.primitives.Primitives;
import org.ocamljava.runtime.context.CodeState;
import org.ocamljava.runtime.context.Context;
import org.ocamljava.runtime.context.ContextWithRuntimeLock;
import org.ocamljava.runtime.context.ContextWithoutRuntimeLock;
import org.ocamljava.runtime.kernel.ByteCodeFileLoader;
import org.ocamljava.runtime.kernel.ByteCodeRunner;
import org.ocamljava.runtime.kernel.Channel;
import org.ocamljava.runtime.kernel.Debugger;
import org.ocamljava.runtime.kernel.Dispatcher;
import org.ocamljava.runtime.kernel.Executable;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.FalseExit;
import org.ocamljava.runtime.kernel.Fatal;
import org.ocamljava.runtime.kernel.MethodHandleDispatcher;
import org.ocamljava.runtime.kernel.Misc;
import org.ocamljava.runtime.kernel.OCamlJavaException;
import org.ocamljava.runtime.kernel.OCamlJavaThread;
import org.ocamljava.runtime.kernel.ReflectionDispatcher;
import org.ocamljava.runtime.kernel.Signals;
import org.ocamljava.runtime.parameters.ByteCodeParameters;
import org.ocamljava.runtime.util.RandomAccessInputStream;
import org.ocamljava.runtime.values.CustomOperations;
import org.ocamljava.runtime.values.Value;

public final class Interpreter
implements Executable {
    private static final String UNABLE_TO_LOAD_CLASS = "unable to load class '%s'";
    private final Context context;

    public Interpreter(ByteCodeParameters bcp, File dir, RandomAccessInputStream source, CustomOperations ... customs) throws IOException, OCamlJavaException, Fatal.Exception {
        ByteCodeFileLoader loader;
        assert (bcp != null) : "null bcp";
        assert (dir != null) : "null dir";
        assert (source != null) : "null source";
        assert (customs != null) : "null customs";
        this.context = bcp.hasRuntimeLock() ? new ContextWithRuntimeLock(bcp, false, dir) : new ContextWithoutRuntimeLock(bcp, false, dir);
        Debugger.init(this.context);
        CodeState codeState = this.context.getCodeState();
        for (CustomOperations ops : customs) {
            codeState.registerCustom(ops);
        }
        try {
            loader = new ByteCodeFileLoader(this.context, source);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new OCamlJavaException("No MD5 provider", nsae);
        }
        List<String> primitives = loader.getPrimitives();
        int szPrim = primitives.size();
        String[] primitiveNames = new String[szPrim];
        primitives.toArray(primitiveNames);
        Method[] primitiveTable = new Method[szPrim];
        Class<?>[] primitivesImpl = Primitives.getSPIClasses();
        codeState.setProviders(primitivesImpl);
        for (int i = 0; i < szPrim; ++i) {
            primitiveTable[i] = Primitives.lookupPrimitive(primitiveNames[i], primitivesImpl);
        }
        try {
            Dispatcher dispatcher = bcp.isReflectionUsedForDispatchers() ? new ReflectionDispatcher(primitiveNames, primitiveTable) : new MethodHandleDispatcher(primitiveNames, primitiveTable);
            codeState.setDispatcher(dispatcher);
        }
        catch (IllegalAccessException iae) {
            throw new OCamlJavaException("cannot access method", iae);
        }
    }

    public Context getContext() {
        return this.context;
    }

    public Value execute() throws OCamlJavaException {
        return this.runMain(null, null, new Value[0]);
    }

    @Override
    public void executeSilently() throws OCamlJavaException {
        this.execute();
    }

    public Value execute(String function, Value ... params) throws OCamlJavaException {
        assert (function != null) : "null function";
        assert (params != null) : "null params";
        assert (params.length + 4 <= 256) : "params is too long";
        Value closure = this.context.getCodeState().getCallback(function);
        if (closure == null) {
            throw new OCamlJavaException("unknown callback " + function);
        }
        return this.runMain(closure, null, params);
    }

    public Value executeWithBindings(String function, Map<String, Value> bindings, Value ... params) throws OCamlJavaException {
        assert (function != null) : "null function";
        assert (bindings != null) : "null bindings";
        assert (params != null) : "null params";
        assert (params.length + 4 <= 256) : "params is too long";
        Value closure = this.context.getCodeState().getCallback(function);
        if (closure == null) {
            throw new OCamlJavaException("unknown callback " + function);
        }
        return this.runMain(closure, bindings, params);
    }

    private Value runMain(Value closure, Map<String, Value> bindings, Value ... params) throws OCamlJavaException {
        PrintStream err;
        ByteArrayOutputStream altErr;
        ByteCodeRunner runner = new ByteCodeRunner(this, null, true);
        runner.setBindings(bindings);
        this.context.getThreadsState().setMainCodeRunner(runner);
        runner.setup(closure, params);
        OCamlJavaThread thread = new OCamlJavaThread(this.context.getThreadsState().getThreadGroup(), runner);
        this.context.getThreadsState().setMainThread(thread);
        thread.start();
        while (thread.isAlive()) {
            try {
                thread.join();
            }
            catch (InterruptedException ie) {
                Signals.unregisterContext(this.context);
                this.context.getSignalsState().clearSignals();
                try {
                    int exitCode = FalseExit.createFromContext(this.context).getExitCode();
                    return Value.createLong(exitCode);
                }
                catch (Fail.Exception fe) {}
            }
        }
        Signals.unregisterContext(this.context);
        this.context.getSignalsState().clearSignals();
        Throwable exn = runner.getException();
        if (exn == null) {
            try {
                Debugger.handleEvent(runner, Debugger.EventKind.PROGRAM_EXIT);
            }
            catch (Fail.Exception | FalseExit | Fatal.Exception fe) {
                throw new OCamlJavaException("error during debugger event handling", fe);
            }
            return runner.getResult();
        }
        try {
            Debugger.handleEvent(runner, Debugger.EventKind.UNCAUGHT_EXC);
        }
        catch (Fail.Exception | FalseExit | Fatal.Exception fe) {
            throw new OCamlJavaException("error during debugger event handling", fe);
        }
        if (closure != null) {
            throw new OCamlJavaException("callback exception", exn);
        }
        Channel ch = this.context.getFilesState().getChannel(2);
        if (ch != null && ch.isOutputChannel()) {
            altErr = null;
            err = new PrintStream(ch.newOutputStream(), true);
        } else {
            altErr = new ByteArrayOutputStream();
            err = new PrintStream(altErr, true);
        }
        CodeState codeState = this.context.getCodeState();
        boolean backtrace = codeState.isBacktraceActive();
        codeState.setBacktraceActive(false);
        Value atExit = codeState.getCallback("Pervasives.do_at_exit");
        if (atExit != null) {
            try {
                runner.callback(atExit, Value.UNIT);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        codeState.setBacktraceActive(backtrace);
        if (exn instanceof Fail.Exception) {
            Value globalData = codeState.getGlobalData();
            String msg = Misc.convertException(((Fail.Exception)exn).asValue(globalData), globalData);
            err.println("Fatal error: exception " + msg);
            if (codeState.isBacktraceActive() && !this.context.getDebuggerState().isDebuggerInUse()) {
                runner.printExceptionBacktrace(err);
            }
            err.close();
            throw new OCamlJavaException(altErr != null ? altErr.toString() : "program exception", exn);
        }
        if (exn instanceof Fatal.Exception) {
            err.println(((Fatal.Exception)exn).getMessage());
            err.close();
            throw new OCamlJavaException(altErr != null ? altErr.toString() : "fatal error", exn);
        }
        err.println(exn.toString());
        err.close();
        throw new OCamlJavaException(altErr != null ? altErr.toString() : "internal error", exn);
    }
}

