/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class StreamCopyThread
extends Thread {
    private static final int BUFFER_SIZE = 65536;
    private final OutputStream out;
    private final boolean closeOut;
    private final InputStream in;
    private final boolean closeIn;
    private final boolean activeRead;
    private IOException exception;

    public StreamCopyThread(OutputStream o, boolean co, InputStream i, boolean ci, boolean ar) {
        assert (o != null) : "null o";
        assert (i != null) : "null i";
        this.out = o;
        this.closeOut = co;
        this.in = i;
        this.closeIn = ci;
        this.activeRead = ar;
        this.exception = null;
    }

    public IOException getException() {
        return this.exception;
    }

    @Override
    public void run() {
        byte[] buffer = new byte[65536];
        try {
            int nb = this.doRead(buffer);
            while (nb != -1) {
                this.out.write(buffer, 0, nb);
                this.out.flush();
                nb = this.doRead(buffer);
            }
            this.exception = null;
        }
        catch (IOException ioe) {
            this.exception = ioe;
        }
        if (this.closeOut) {
            try {
                this.out.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (this.closeIn) {
            try {
                this.in.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private int doRead(byte[] b) throws IOException {
        assert (b != null) : "null b";
        if (this.activeRead) {
            while (this.in.available() == 0) {
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException ie) {
                    return -1;
                }
            }
            return this.in.read(b);
        }
        return this.in.read(b);
    }
}

