/*
 * Decompiled with CFR 0.152.
 */
package ocaml.stdlib;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import org.ocamljava.runtime.annotations.markers.CompiledModule;
import org.ocamljava.runtime.kernel.AbstractNativeRunner;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.Fatal;
import org.ocamljava.runtime.kernel.OCamlJavaModule;
import org.ocamljava.runtime.kernel.ThreadLocalFactory;
import org.ocamljava.runtime.values.Value;

@CompiledModule
public final class Complex
implements OCamlJavaModule {
    public static final ThreadLocal GLOBALS;
    private static final ThreadLocal CONSTANTS;
    public static final MethodHandle add_1014;
    public static final MethodHandle sub_1017;
    public static final MethodHandle neg_1020;
    public static final MethodHandle conj_1022;
    public static final MethodHandle mul_1024;
    public static final MethodHandle div_1027;
    public static final MethodHandle inv_1034;
    public static final MethodHandle norm2_1036;
    public static final MethodHandle norm_1038;
    public static final MethodHandle arg_1044;
    public static final MethodHandle polar_1046;
    public static final MethodHandle sqrt_1049;
    public static final MethodHandle exp_1056;
    public static final MethodHandle log_1059;
    public static final MethodHandle pow_1061;

    static {
        CONSTANTS = ThreadLocalFactory.constantsStorage(Complex.class);
        GLOBALS = ThreadLocalFactory.globalStorage("Complex");
        add_1014 = cfr_ldc_0();
        sub_1017 = cfr_ldc_1();
        neg_1020 = cfr_ldc_2();
        conj_1022 = cfr_ldc_3();
        mul_1024 = cfr_ldc_4();
        div_1027 = cfr_ldc_5();
        inv_1034 = cfr_ldc_6();
        norm2_1036 = cfr_ldc_7();
        norm_1038 = cfr_ldc_8();
        arg_1044 = cfr_ldc_9();
        polar_1046 = cfr_ldc_10();
        sqrt_1049 = cfr_ldc_11();
        exp_1056 = cfr_ldc_12();
        log_1059 = cfr_ldc_13();
        pow_1061 = cfr_ldc_14();
    }

    public static Value add_1014(Value x, Value y) throws Fail.Exception, Fatal.Exception {
        return Value.createDoubleArray(x.getGenericDouble0() + y.getGenericDouble0(), x.getGenericDouble1() + y.getGenericDouble1());
    }

    public static Value sub_1017(Value x, Value y) throws Fail.Exception, Fatal.Exception {
        return Value.createDoubleArray(x.getGenericDouble0() - y.getGenericDouble0(), x.getGenericDouble1() - y.getGenericDouble1());
    }

    public static Value neg_1020(Value x) throws Fail.Exception, Fatal.Exception {
        return Value.createDoubleArray(-x.getGenericDouble0(), -x.getGenericDouble1());
    }

    public static Value conj_1022(Value x) throws Fail.Exception, Fatal.Exception {
        return Value.createDoubleArray(x.getGenericDouble0(), -x.getGenericDouble1());
    }

    public static Value mul_1024(Value x, Value y) throws Fail.Exception, Fatal.Exception {
        return Value.createDoubleArray(x.getGenericDouble0() * y.getGenericDouble0() - x.getGenericDouble1() * y.getGenericDouble1(), x.getGenericDouble0() * y.getGenericDouble1() + x.getGenericDouble1() * y.getGenericDouble0());
    }

    public static Value div_1027(Value x, Value y) throws Fail.Exception, Fatal.Exception {
        Value value;
        if ((int)(Math.abs(y.getGenericDouble0()) < Math.abs(y.getGenericDouble1()) ? 0L : 1L) != 0) {
            double d = y.getGenericDouble1() / y.getGenericDouble0();
            double d2 = y.getGenericDouble0() + d * y.getGenericDouble1();
            value = Value.createDoubleArray((x.getGenericDouble0() + d * x.getGenericDouble1()) / d2, (x.getGenericDouble1() - d * x.getGenericDouble0()) / d2);
        } else {
            double d = y.getGenericDouble0() / y.getGenericDouble1();
            double d3 = y.getGenericDouble1() + d * y.getGenericDouble0();
            value = Value.createDoubleArray((d * x.getGenericDouble0() + x.getGenericDouble1()) / d3, (d * x.getGenericDouble1() - x.getGenericDouble0()) / d3);
        }
        return value;
    }

    public static Value inv_1034(Value x) throws Fail.Exception, Fatal.Exception {
        Value value = (Value)GLOBALS.get();
        return Complex.div_1027(value.get1(), x);
    }

    public static Value norm2_1036(Value x) throws Fail.Exception, Fatal.Exception {
        double d = x.getGenericDouble0();
        double d2 = x.getGenericDouble1();
        return Value.createDouble(d * d + d2 * d2);
    }

    public static Value norm_1038(Value x) throws Fail.Exception, Fatal.Exception {
        Value value;
        double d = Math.abs(x.getGenericDouble0());
        double d2 = Math.abs(x.getGenericDouble1());
        if ((int)(d != 0.0 ? 0L : 1L) != 0) {
            value = Value.createDouble(d2);
        } else if ((int)(d2 != 0.0 ? 0L : 1L) != 0) {
            value = Value.createDouble(d);
        } else if ((int)(d < d2 ? 0L : 1L) != 0) {
            double d3;
            double d4 = d3 = d2 / d;
            value = Value.createDouble(d * Math.sqrt(1.0 + d4 * d4));
        } else {
            double d5;
            double d6 = d5 = d / d2;
            value = Value.createDouble(d2 * Math.sqrt(1.0 + d6 * d6));
        }
        return value;
    }

    public static Value arg_1044(Value x) throws Fail.Exception, Fatal.Exception {
        return Value.createDouble(Math.atan2(x.getGenericDouble1(), x.getGenericDouble0()));
    }

    public static Value polar_1046(Value n, Value a) throws Fail.Exception, Fatal.Exception {
        return Value.createDoubleArray(Math.cos(a.asDouble()) * n.asDouble(), Math.sin(a.asDouble()) * n.asDouble());
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Value sqrt_1049(Value x) throws Fail.Exception, Fatal.Exception {
        double d;
        double d2;
        double d3;
        Value value;
        Value value2 = (Value)CONSTANTS.get();
        if ((int)(x.getGenericDouble0() != 0.0 ? 0L : 1L) != 0 && (int)(x.getGenericDouble1() != 0.0 ? 0L : 1L) != 0) {
            value = value2.get(0);
            return value;
        }
        double d4 = Math.abs(x.getGenericDouble0());
        if ((int)(d4 < (d3 = Math.abs(x.getGenericDouble1())) ? 0L : 1L) != 0) {
            double d5 = d2 = d3 / d4;
            d = Math.sqrt(d4) * Math.sqrt(0.5 * (1.0 + Math.sqrt(1.0 + d5 * d5)));
        } else {
            double d6 = d2 = d4 / d3;
            d = d2 = Math.sqrt(d3) * Math.sqrt(0.5 * (d2 + Math.sqrt(1.0 + d6 * d6)));
        }
        if ((int)(x.getGenericDouble0() < 0.0 ? 0L : 1L) != 0) {
            value = Value.createDoubleArray(d2, 0.5 * x.getGenericDouble1() / d2);
            return value;
        }
        value = Value.createDoubleArray(0.5 * d3 / d2, (int)(x.getGenericDouble1() < 0.0 ? 0L : 1L) != 0 ? d2 : -d2);
        return value;
    }

    public static Value exp_1056(Value x) throws Fail.Exception, Fatal.Exception {
        double d = Math.exp(x.getGenericDouble0());
        return Value.createDoubleArray(d * Math.cos(x.getGenericDouble1()), d * Math.sin(x.getGenericDouble1()));
    }

    public static Value log_1059(Value x) throws Fail.Exception, Fatal.Exception {
        return Value.createDoubleArray(Math.log(Complex.norm_1038(x).asDouble()), Math.atan2(x.getGenericDouble1(), x.getGenericDouble0()));
    }

    public static Value pow_1061(Value x, Value y) throws Fail.Exception, Fatal.Exception {
        return Complex.exp_1056(Complex.mul_1024(y, Complex.log_1059(x)));
    }

    public static Value entry() throws Fail.Exception, Fatal.Exception {
        Value value = (Value)CONSTANTS.get();
        Value value2 = AbstractNativeRunner.createGlobal("Complex", 18);
        Value value3 = value.get(1);
        value2.set0(value3);
        value3 = value.get(2);
        value2.set1(value3);
        value3 = value.get(3);
        value2.set2(value3);
        value3 = Value.createClosure(add_1014, 2);
        value2.set5(value3);
        value3 = Value.createClosure(sub_1017, 2);
        value2.set6(value3);
        value3 = Value.createClosure(neg_1020);
        value2.set3(value3);
        value3 = Value.createClosure(conj_1022);
        value2.set4(value3);
        value3 = Value.createClosure(mul_1024, 2);
        value2.set7(value3);
        value3 = Value.createClosure(div_1027, 2);
        value2.set(9, value3);
        value3 = Value.createClosure(inv_1034);
        value2.set(8, value3);
        value3 = Value.createClosure(norm2_1036);
        value2.set(11, value3);
        value3 = Value.createClosure(norm_1038);
        value2.set(12, value3);
        value3 = Value.createClosure(arg_1044);
        value2.set(13, value3);
        value3 = Value.createClosure(polar_1046, 2);
        value2.set(14, value3);
        value3 = Value.createClosure(sqrt_1049);
        value2.set(10, value3);
        value3 = Value.createClosure(exp_1056);
        value2.set(15, value3);
        value3 = Value.createClosure(log_1059);
        value2.set(16, value3);
        value3 = Value.createClosure(pow_1061, 2);
        value2.set(17, value3);
        return Value.ZERO;
    }

    /*
     * Works around MethodHandle LDC.
     */
    static MethodHandle cfr_ldc_0() {
        try {
            return MethodHandles.lookup().findStatic(Complex.class, "add_1014", MethodType.fromMethodDescriptorString("(Lorg/ocamljava/runtime/values/Value;Lorg/ocamljava/runtime/values/Value;)Lorg/ocamljava/runtime/values/Value;", null));
        }
        catch (NoSuchMethodException | IllegalAccessException except) {
            throw new IllegalArgumentException(except);
        }
    }

    /*
     * Works around MethodHandle LDC.
     */
    static MethodHandle cfr_ldc_1() {
        try {
            return MethodHandles.lookup().findStatic(Complex.class, "sub_1017", MethodType.fromMethodDescriptorString("(Lorg/ocamljava/runtime/values/Value;Lorg/ocamljava/runtime/values/Value;)Lorg/ocamljava/runtime/values/Value;", null));
        }
        catch (NoSuchMethodException | IllegalAccessException except) {
            throw new IllegalArgumentException(except);
        }
    }

    /*
     * Works around MethodHandle LDC.
     */
    static MethodHandle cfr_ldc_2() {
        try {
            return MethodHandles.lookup().findStatic(Complex.class, "neg_1020", MethodType.fromMethodDescriptorString("(Lorg/ocamljava/runtime/values/Value;)Lorg/ocamljava/runtime/values/Value;", null));
        }
        catch (NoSuchMethodException | IllegalAccessException except) {
            throw new IllegalArgumentException(except);
        }
    }

    /*
     * Works around MethodHandle LDC.
     */
    static MethodHandle cfr_ldc_3() {
        try {
            return MethodHandles.lookup().findStatic(Complex.class, "conj_1022", MethodType.fromMethodDescriptorString("(Lorg/ocamljava/runtime/values/Value;)Lorg/ocamljava/runtime/values/Value;", null));
        }
        catch (NoSuchMethodException | IllegalAccessException except) {
            throw new IllegalArgumentException(except);
        }
    }

    /*
     * Works around MethodHandle LDC.
     */
    static MethodHandle cfr_ldc_4() {
        try {
            return MethodHandles.lookup().findStatic(Complex.class, "mul_1024", MethodType.fromMethodDescriptorString("(Lorg/ocamljava/runtime/values/Value;Lorg/ocamljava/runtime/values/Value;)Lorg/ocamljava/runtime/values/Value;", null));
        }
        catch (NoSuchMethodException | IllegalAccessException except) {
            throw new IllegalArgumentException(except);
        }
    }

    /*
     * Works around MethodHandle LDC.
     */
    static MethodHandle cfr_ldc_5() {
        try {
            return MethodHandles.lookup().findStatic(Complex.class, "div_1027", MethodType.fromMethodDescriptorString("(Lorg/ocamljava/runtime/values/Value;Lorg/ocamljava/runtime/values/Value;)Lorg/ocamljava/runtime/values/Value;", null));
        }
        catch (NoSuchMethodException | IllegalAccessException except) {
            throw new IllegalArgumentException(except);
        }
    }

    /*
     * Works around MethodHandle LDC.
     */
    static MethodHandle cfr_ldc_6() {
        try {
            return MethodHandles.lookup().findStatic(Complex.class, "inv_1034", MethodType.fromMethodDescriptorString("(Lorg/ocamljava/runtime/values/Value;)Lorg/ocamljava/runtime/values/Value;", null));
        }
        catch (NoSuchMethodException | IllegalAccessException except) {
            throw new IllegalArgumentException(except);
        }
    }

    /*
     * Works around MethodHandle LDC.
     */
    static MethodHandle cfr_ldc_7() {
        try {
            return MethodHandles.lookup().findStatic(Complex.class, "norm2_1036", MethodType.fromMethodDescriptorString("(Lorg/ocamljava/runtime/values/Value;)Lorg/ocamljava/runtime/values/Value;", null));
        }
        catch (NoSuchMethodException | IllegalAccessException except) {
            throw new IllegalArgumentException(except);
        }
    }

    /*
     * Works around MethodHandle LDC.
     */
    static MethodHandle cfr_ldc_8() {
        try {
            return MethodHandles.lookup().findStatic(Complex.class, "norm_1038", MethodType.fromMethodDescriptorString("(Lorg/ocamljava/runtime/values/Value;)Lorg/ocamljava/runtime/values/Value;", null));
        }
        catch (NoSuchMethodException | IllegalAccessException except) {
            throw new IllegalArgumentException(except);
        }
    }

    /*
     * Works around MethodHandle LDC.
     */
    static MethodHandle cfr_ldc_9() {
        try {
            return MethodHandles.lookup().findStatic(Complex.class, "arg_1044", MethodType.fromMethodDescriptorString("(Lorg/ocamljava/runtime/values/Value;)Lorg/ocamljava/runtime/values/Value;", null));
        }
        catch (NoSuchMethodException | IllegalAccessException except) {
            throw new IllegalArgumentException(except);
        }
    }

    /*
     * Works around MethodHandle LDC.
     */
    static MethodHandle cfr_ldc_10() {
        try {
            return MethodHandles.lookup().findStatic(Complex.class, "polar_1046", MethodType.fromMethodDescriptorString("(Lorg/ocamljava/runtime/values/Value;Lorg/ocamljava/runtime/values/Value;)Lorg/ocamljava/runtime/values/Value;", null));
        }
        catch (NoSuchMethodException | IllegalAccessException except) {
            throw new IllegalArgumentException(except);
        }
    }

    /*
     * Works around MethodHandle LDC.
     */
    static MethodHandle cfr_ldc_11() {
        try {
            return MethodHandles.lookup().findStatic(Complex.class, "sqrt_1049", MethodType.fromMethodDescriptorString("(Lorg/ocamljava/runtime/values/Value;)Lorg/ocamljava/runtime/values/Value;", null));
        }
        catch (NoSuchMethodException | IllegalAccessException except) {
            throw new IllegalArgumentException(except);
        }
    }

    /*
     * Works around MethodHandle LDC.
     */
    static MethodHandle cfr_ldc_12() {
        try {
            return MethodHandles.lookup().findStatic(Complex.class, "exp_1056", MethodType.fromMethodDescriptorString("(Lorg/ocamljava/runtime/values/Value;)Lorg/ocamljava/runtime/values/Value;", null));
        }
        catch (NoSuchMethodException | IllegalAccessException except) {
            throw new IllegalArgumentException(except);
        }
    }

    /*
     * Works around MethodHandle LDC.
     */
    static MethodHandle cfr_ldc_13() {
        try {
            return MethodHandles.lookup().findStatic(Complex.class, "log_1059", MethodType.fromMethodDescriptorString("(Lorg/ocamljava/runtime/values/Value;)Lorg/ocamljava/runtime/values/Value;", null));
        }
        catch (NoSuchMethodException | IllegalAccessException except) {
            throw new IllegalArgumentException(except);
        }
    }

    /*
     * Works around MethodHandle LDC.
     */
    static MethodHandle cfr_ldc_14() {
        try {
            return MethodHandles.lookup().findStatic(Complex.class, "pow_1061", MethodType.fromMethodDescriptorString("(Lorg/ocamljava/runtime/values/Value;Lorg/ocamljava/runtime/values/Value;)Lorg/ocamljava/runtime/values/Value;", null));
        }
        catch (NoSuchMethodException | IllegalAccessException except) {
            throw new IllegalArgumentException(except);
        }
    }
}

