/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.graph;

import java.awt.image.BufferedImage;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.primitives.otherlibs.graph.GraphSlot;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="graph", module="Graphics", source="otherlibs/graph/dump_img.c")
public final class DumpImage {
    private DumpImage() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Graphics.image"}, returnType="Graphics.color array array")
    public static Value caml_gr_dump_image(Value vimg) throws Fail.Exception {
        GraphSlot.checkGraph();
        BufferedImage img = (BufferedImage)vimg.asCustom();
        int width = img.getWidth();
        int height = img.getHeight();
        Value res = Value.createBlock(0, height);
        int[] pixels = img.getRGB(0, 0, width, height, null, 0, width);
        for (int i = 0; i < height; ++i) {
            Value line = Value.createBlock(0, width);
            for (int j = 0; j < width; ++j) {
                int v = pixels[j * width + i];
                if ((v & 0xFF000000) != 0) {
                    line.set(j, Value.createLong(v & 0xFFFFFF));
                    continue;
                }
                line.set(j, Value.MINUS_ONE);
            }
            res.set(i, line);
        }
        return res;
    }
}

