/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.support.wrappers;

import java.util.Arrays;
import org.ocamljava.runtime.support.wrappers.ToValue;
import org.ocamljava.runtime.values.Value;

public final class ByteArrayString
implements ToValue {
    private final byte[] value;

    public ByteArrayString(int sz) {
        assert (sz >= 0) : "sz should be >= 0";
        this.value = new byte[sz];
    }

    public byte get(int index) {
        return this.value[index];
    }

    public void set(int index, byte v) {
        this.value[index] = v;
    }

    public int length() {
        return this.value.length;
    }

    @Override
    public Value toValue() {
        return Value.createString(this.value);
    }

    public int hashCode() {
        return Arrays.hashCode(this.value);
    }

    public boolean equals(Object obj) {
        if (obj instanceof ByteArrayString) {
            ByteArrayString that = (ByteArrayString)obj;
            return Arrays.equals(this.value, that.value);
        }
        return false;
    }

    public String toString() {
        return Arrays.toString(this.value);
    }
}

