/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.kernel;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.ocamljava.runtime.kernel.Dispatcher;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.FalseExit;
import org.ocamljava.runtime.kernel.Fatal;
import org.ocamljava.runtime.values.Value;

final class ReflectionDispatcher
implements Dispatcher {
    private int size;
    private String[] names;
    private Method[] implementations;

    ReflectionDispatcher(String[] stringArray, Method[] methodArray) {
        if ($assertionsDisabled || stringArray != null) {
            if ($assertionsDisabled || methodArray != null) {
                if ($assertionsDisabled || stringArray.length == methodArray.length) {
                    this.size = stringArray.length;
                    this.names = Arrays.copyOf(stringArray, stringArray.length);
                    this.implementations = Arrays.copyOf(methodArray, methodArray.length);
                    return;
                }
                throw new AssertionError((Object)"nams and impls should have the same length");
            }
            throw new AssertionError((Object)"null impls");
        }
        throw new AssertionError((Object)"null nams");
    }

    @Override
    public String[] getNames() {
        return this.names;
    }

    @Override
    public Method[] getMethods() {
        return this.implementations;
    }

    @Override
    public String getName(int n) {
        if (n < 0 || n >= this.size) {
            return null;
        }
        return this.names[n];
    }

    @Override
    public Method getMethod(int n) {
        if (n < 0 || n >= this.size) {
            return null;
        }
        return this.implementations[n];
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Value invoke(int n, Value[] valueArray) throws Fatal.Exception, Fail.Exception, FalseExit {
        if ($assertionsDisabled || valueArray != null) {
            if (n < 0 || n >= this.size) {
                Fatal.raise("undefined primitive: " + n);
                return null;
            }
            try {
                return (Value)this.implementations[n].invoke(null, (Object[])valueArray);
            }
            catch (IllegalAccessException illegalAccessException) {
                Fatal.raise("illegal access to primitive: " + this.getName(n));
                return null;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable.getCause();
                if (throwable2 instanceof Fail.Exception) {
                    throw (Fail.Exception)throwable2;
                }
                if (throwable2 instanceof Fatal.Exception) {
                    throw (Fatal.Exception)throwable2;
                }
                if (throwable2 instanceof FalseExit) {
                    throw (FalseExit)throwable2;
                }
                throwable.printStackTrace();
                StringWriter stringWriter = new StringWriter();
                stringWriter.append("primitive error: ");
                stringWriter.append(this.getName(n));
                stringWriter.append('\n');
                if (throwable2 != null) {
                    throwable2.printStackTrace(new PrintWriter(stringWriter));
                }
                Fatal.raise(stringWriter.toString());
                return null;
            }
        }
        throw new AssertionError((Object)"null params");
    }

    @Override
    public Value invoke(int n, Value value) throws Fatal.Exception, Fail.Exception, FalseExit {
        assert (value != null) : "null p0";
        {
            return this.invoke(n, new Value[]{value});
        }
    }

    @Override
    public Value invoke(int n, Value value, Value value2) throws Fatal.Exception, Fail.Exception, FalseExit {
        if ($assertionsDisabled || value != null) {
            assert (value2 != null) : "null p1";
            {
                return this.invoke(n, new Value[]{value, value2});
            }
        }
        throw new AssertionError((Object)"null p0");
    }

    @Override
    public Value invoke(int n, Value value, Value value2, Value value3) throws Fatal.Exception, Fail.Exception, FalseExit {
        if ($assertionsDisabled || value != null) {
            if ($assertionsDisabled || value2 != null) {
                assert (value3 != null) : "null p2";
                {
                    return this.invoke(n, new Value[]{value, value2, value3});
                }
            }
            throw new AssertionError((Object)"null p1");
        }
        throw new AssertionError((Object)"null p0");
    }

    @Override
    public Value invoke(int n, Value value, Value value2, Value value3, Value value4) throws Fatal.Exception, Fail.Exception, FalseExit {
        if ($assertionsDisabled || value != null) {
            if ($assertionsDisabled || value2 != null) {
                if ($assertionsDisabled || value3 != null) {
                    assert (value4 != null) : "null p3";
                    {
                        return this.invoke(n, new Value[]{value, value2, value3, value4});
                    }
                }
                throw new AssertionError((Object)"null p2");
            }
            throw new AssertionError((Object)"null p1");
        }
        throw new AssertionError((Object)"null p0");
    }

    @Override
    public Value invoke(int n, Value value, Value value2, Value value3, Value value4, Value value5) throws Fatal.Exception, Fail.Exception, FalseExit {
        if ($assertionsDisabled || value != null) {
            if ($assertionsDisabled || value2 != null) {
                if ($assertionsDisabled || value3 != null) {
                    if ($assertionsDisabled || value4 != null) {
                        assert (value5 != null) : "null p4";
                        {
                            return this.invoke(n, new Value[]{value, value2, value3, value4, value5});
                        }
                    }
                    throw new AssertionError((Object)"null p3");
                }
                throw new AssertionError((Object)"null p2");
            }
            throw new AssertionError((Object)"null p1");
        }
        throw new AssertionError((Object)"null p0");
    }

    @Override
    public int addPrimitive(String string, Method method) {
        if ($assertionsDisabled || string != null) {
            if ($assertionsDisabled || method != null) {
                int n = this.size++;
                Method[] methodArray = new Method[this.size];
                System.arraycopy(this.implementations, 0, methodArray, 0, n);
                methodArray[n] = method;
                this.implementations = methodArray;
                String[] stringArray = new String[this.size];
                System.arraycopy(this.names, 0, stringArray, 0, n);
                stringArray[n] = string;
                this.names = stringArray;
                return n;
            }
            throw new AssertionError((Object)"null impl");
        }
        throw new AssertionError((Object)"null name");
    }
}

