/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.kernel;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.ocamljava.runtime.context.Context;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.Fatal;
import org.ocamljava.runtime.kernel.InvalidByteCodeFileException;
import org.ocamljava.runtime.kernel.MarshalIntern;
import org.ocamljava.runtime.util.EncodingUtils;
import org.ocamljava.runtime.util.IO;
import org.ocamljava.runtime.util.IntegerUtils;
import org.ocamljava.runtime.util.RandomAccessInputStream;
import org.ocamljava.runtime.values.Value;

final class ByteCodeFileLoader {
    private static final String EXEC_MAGIC = "Caml1999X008";
    private static final int TRAILER_SIZE = 16;
    private static final String MD5_ALGO = "MD5";
    private static final String SECTION_SHARED_LIB_PATH = "DLPT";
    private static final String SECTION_SHARED_LIBS = "DLLS";
    private static final String SECTION_REQ_PRIMS = "PRIM";
    private static final String SECTION_CODE = "CODE";
    private static final String SECTION_DATA = "DATA";
    private static final String SECTION_DEBUG = "DBUG";
    private static final int SECTION_NAME_LENGTH = 4;
    private static final int SECTION_SIZE = 8;
    private static final String INVALID_MAGIC = "invalid magic";
    private static final String MISSING_SECTION = "missing '%s' section";
    private static final String INVALID_SECTION = "section of more than 2147483647 bytes";
    private static final String INVALID_CODE_SECTION_SIZE = "code section size should be a multiple of 4";
    private final List<String> primitives;
    private final List<String> sharedLibPath;
    private final List<String> sharedLibs;
    private final int[] code;
    private final Value globalData;
    private final Value debugInfo;

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    ByteCodeFileLoader(Context var1_1, RandomAccessInputStream var2_2) throws IOException, InvalidByteCodeFileException, NoSuchAlgorithmException, Fatal.Exception {
        block17: {
            block18: {
                super();
                if (!ByteCodeFileLoader.$assertionsDisabled && var1_1 == null) break block17;
                if (!ByteCodeFileLoader.$assertionsDisabled && var2_2 == null) break block18;
                var3_3 = var2_2.length();
                var5_4 = var2_2.dataInputFrom(var3_3 - 16L);
                var6_5 = IntegerUtils.ensure32s(IO.read32u(var5_4));
                var7_6 = new byte["Caml1999X008".length()];
                var5_4.readFully(var7_6);
                if (!"Caml1999X008".equals(EncodingUtils.convertBytesToString(var7_6))) {
                    throw new InvalidByteCodeFileException("invalid magic");
                }
                var8_7 = 0L;
                var5_4 = var2_2.dataInputFrom(var3_3 - (long)(16 + 8 * var6_5));
                var10_8 = new LinkedHashMap<String, Section>();
                var11_9 = 0;
                while (true) {
                    block20: {
                        block21: {
                            block23: {
                                block22: {
                                    block19: {
                                        if (var11_9 >= var6_5) break block19;
                                        var12_11 /* !! */  = new byte[4];
                                        var5_4.readFully(var12_11 /* !! */ );
                                        var13_13 = EncodingUtils.convertBytesToString(var12_11 /* !! */ );
                                        var14_14 = IO.read32u(var5_4);
                                        if (var14_14 <= 0x7FFFFFFFL) break block20;
                                        break block21;
                                    }
                                    var11_10 = var10_8.values().iterator();
                                    while (var11_10.hasNext()) {
                                        var12_11 /* !! */  = (byte[])((Section)var11_10.next());
                                        Section.access$102((Section)var12_11 /* !! */ , var3_3 - (var8_7 - Section.access$100((Section)var12_11 /* !! */ ) + 16L + (long)(8 * var6_5)));
                                    }
                                    var11_10 = (Section)var10_8.get("CODE");
                                    if (var11_10 == null) {
                                        throw new InvalidByteCodeFileException(String.format("missing '%s' section", new Object[]{"CODE"}));
                                    }
                                    var12_12 = Section.access$200((Section)var11_10);
                                    if (var12_12 % 4 != 0) {
                                        throw new InvalidByteCodeFileException("code section size should be a multiple of 4");
                                    }
                                    var13_13 = new byte[var12_12];
                                    var5_4 = var2_2.dataInputFrom(Section.access$100((Section)var11_10));
                                    var5_4.readFully((byte[])var13_13);
                                    var14_15 = var1_1.getCodeState();
                                    var15_16 = MessageDigest.getInstance("MD5");
                                    var16_17 = var15_16.digest((byte[])var13_13);
                                    var14_15.setCodeDigest(var16_17);
                                    for (var17_18 = 0; var17_18 < var12_12; var17_18 += 4) {
                                        var18_19 = var13_13[var17_18];
                                        var13_13[var17_18] = var13_13[var17_18 + 3];
                                        var13_13[var17_18 + 3] = var18_19;
                                        var18_19 = var13_13[var17_18 + 1];
                                        var13_13[var17_18 + 1] = var13_13[var17_18 + 2];
                                        var13_13[var17_18 + 2] = var18_19;
                                    }
                                    var18_20 = new ByteArrayInputStream((byte[])var13_13);
                                    var19_21 = new DataInputStream(var18_20);
                                    var20_22 = var12_12 / 4;
                                    this.code = new int[var20_22];
                                    for (var21_23 = 0; var21_23 < var20_22; ++var21_23) {
                                        this.code[var21_23] = var19_21.readInt();
                                    }
                                    var14_15.appendCode(this.code);
                                    var14_15.setupCallbackTail();
                                    this.sharedLibPath = Collections.unmodifiableList(ByteCodeFileLoader.readSection(var2_2, "DLPT", var10_8, false));
                                    this.sharedLibs = Collections.unmodifiableList(ByteCodeFileLoader.readSection(var2_2, "DLLS", var10_8, false));
                                    var21_24 = ByteCodeFileLoader.readSection(var2_2, "PRIM", var10_8, true);
                                    if (var21_24 == null || var21_24.size() == 0) {
                                        throw new InvalidByteCodeFileException(String.format("missing '%s' section", new Object[]{"PRIM"}));
                                    }
                                    this.primitives = Collections.unmodifiableList(var21_24);
                                    var22_25 = (Section)var10_8.get("DATA");
                                    if (var22_25 == null) {
                                        throw new InvalidByteCodeFileException(String.format("missing '%s' section", new Object[]{"DATA"}));
                                    }
                                    var5_4 = var2_2.dataInputFrom(Section.access$100(var22_25));
                                    try {
                                        this.globalData = MarshalIntern.inputVal(var1_1, var5_4, true);
                                        var14_15.setGlobalData(this.globalData);
                                    }
                                    catch (Fail.Exception var23_27) {
                                        throw new InvalidByteCodeFileException(var23_27.getMessage());
                                    }
                                    var23_26 = (Section)var10_8.get("DBUG");
                                    if (var23_26 == null) break block22;
                                    break block23;
                                }
                                this.debugInfo = Value.FALSE;
lbl81:
                                // 2 sources

                                while (true) {
                                    var14_15.setDebugInfo(this.debugInfo);
                                    return;
                                }
                            }
                            var5_4 = var2_2.dataInputFrom(Section.access$100(var23_26));
                            var24_28 = IntegerUtils.ensure32s(IO.read32u(var5_4));
                            var25_29 = Value.createBlock(0, var24_28);
                            var26_30 = 0;
                            while (true) {
                                if (var26_30 >= var24_28) {
                                    this.debugInfo = var25_29;
                                    ** continue;
                                }
                                var27_31 = IntegerUtils.ensure32s(IO.read32u(var5_4));
                                try {
                                }
                                catch (Fail.Exception var29_34) {
                                    throw new InvalidByteCodeFileException(var29_34.toString());
                                }
                                for (var29_33 = var28_32 = MarshalIntern.inputVal(var1_1, var5_4, true); var29_33 != Value.EMPTY_LIST; var29_33 = var29_33.get1()) {
                                    var30_35 = var29_33.get0();
                                    var30_35.set(0L, Value.createLong(var30_35.get(0L).asLong() + (long)var27_31));
                                }
                                var25_29.set(var26_30, var28_32);
                                ++var26_30;
                            }
                        }
                        throw new InvalidByteCodeFileException("section of more than 2147483647 bytes");
                    }
                    var10_8.put((String)var13_13, new Section((String)var13_13, var8_7, (int)var14_14));
                    var8_7 += var14_14;
                    ++var11_9;
                }
            }
            throw new AssertionError((Object)"null inputStream");
        }
        throw new AssertionError((Object)"null ctxt");
    }

    List<String> getSharedLibPath() {
        return this.sharedLibPath;
    }

    List<String> getSharedLibs() {
        return this.sharedLibs;
    }

    List<String> getPrimitives() {
        return this.primitives;
    }

    int[] getCode() {
        return this.code;
    }

    Value getGlobalData() {
        return this.globalData;
    }

    Value getDebugInfo() {
        return this.debugInfo;
    }

    private static List<String> readSection(RandomAccessInputStream randomAccessInputStream, String string, Map<String, Section> map, boolean bl) throws IOException {
        if ($assertionsDisabled || randomAccessInputStream != null) {
            if ($assertionsDisabled || string != null) {
                if ($assertionsDisabled || map != null) {
                    LinkedList<String> linkedList = new LinkedList<String>();
                    Section section = map.get(string);
                    if (section == null) {
                        return bl ? null : linkedList;
                    }
                    int n = section.size;
                    byte[] byArray = new byte[n];
                    randomAccessInputStream.dataInputFrom(section.offset).readFully(byArray);
                    int n2 = 0;
                    block0: while (true) {
                        if (n2 >= n || byArray[n2] == 0) {
                            return linkedList;
                        }
                        int n3 = n2;
                        while (true) {
                            if (n2 >= n || byArray[n2] == 0) {
                                linkedList.add(EncodingUtils.convertBytesToString(byArray, n3, n2 - n3));
                                ++n2;
                                continue block0;
                            }
                            ++n2;
                        }
                        break;
                    }
                }
                throw new AssertionError((Object)"null sections");
            }
            throw new AssertionError((Object)"null name");
        }
        throw new AssertionError((Object)"null in");
    }

    private static final class Section {
        private final String name;
        private long offset;
        private final int size;

        private Section(String string, long l, int n) {
            if ($assertionsDisabled || string != null) {
                if ($assertionsDisabled || l >= 0L) {
                    if ($assertionsDisabled || n >= 0) {
                        this.name = string;
                        this.offset = l;
                        this.size = n;
                        return;
                    }
                    throw new AssertionError((Object)"s should be >= 0");
                }
                throw new AssertionError((Object)"ofs should be >= 0");
            }
            throw new AssertionError((Object)"null n");
        }

        static /* synthetic */ long access$102(Section section, long l) {
            section.offset = l;
            return section.offset;
        }
    }
}

