/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.kernel;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.ocamljava.runtime.context.Context;
import org.ocamljava.runtime.kernel.Dispatcher;
import org.ocamljava.runtime.kernel.Instructions;
import org.ocamljava.runtime.util.IntegerUtils;

public final class Disassembler {
    private Disassembler() {
    }

    /*
     * Enabled aggressive block sorting
     */
    private static int disassemble(Context context, int n, PrintWriter printWriter) {
        assert (context != null) : "null ctxt";
        assert (n >= 0) : "pc should be >= 0";
        assert (printWriter != null) : "null out";
        int[] nArray = context.getCodeState().getCode();
        Dispatcher dispatcher = context.getCodeState().getDispatcher();
        int n2 = nArray[n];
        String string = n2 >= 0 && n2 <= 143 ? Instructions.MNEMONICS[n2] : "???" + n2;
        printWriter.printf("%06d  %s", n, string);
        switch (n2) {
            case 8: 
            case 18: 
            case 19: 
            case 20: 
            case 25: 
            case 30: 
            case 31: 
            case 32: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 48: 
            case 52: 
            case 53: 
            case 54: 
            case 57: 
            case 59: 
            case 61: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 71: 
            case 72: 
            case 77: 
            case 78: 
            case 84: 
            case 85: 
            case 86: 
            case 89: 
            case 103: 
            case 108: 
            case 127: 
            case 128: {
                printWriter.printf(" %d", nArray[n + 1]);
                return 2;
            }
            case 36: 
            case 43: 
            case 44: 
            case 55: 
            case 56: 
            case 62: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 139: 
            case 140: 
            case 141: {
                printWriter.printf(" %d, %d", nArray[n + 1], nArray[n + 2]);
                if (n2 != 44) return 3;
                break;
            }
            case 87: {
                long l = IntegerUtils.signedToUnsigned(nArray[n + 1]);
                int n3 = (int)(l >> 16);
                int n4 = (int)(l & 0xFFFFL);
                printWriter.printf(" sz%x=%d::ntag%d nint%d", l, l, n3, n4);
                return 2 + n3 + n4;
            }
            case 98: {
                printWriter.printf(" %d, %s", nArray[n + 1], Disassembler.getPrimitiveName(dispatcher, nArray[n + 2]));
                return 3;
            }
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: {
                printWriter.printf(" %s", Disassembler.getPrimitiveName(dispatcher, nArray[n + 1]));
                return 2;
            }
            default: {
                return 1;
            }
        }
        int n5 = nArray[n + 1];
        return 3 + n5;
    }

    static void disassembleInstr(Context context, int n) {
        Disassembler.disassemble(context, n, new PrintWriter(System.out));
    }

    public static void disassembleAll(Context context, PrintStream printStream) {
        if ($assertionsDisabled || context != null) {
            if ($assertionsDisabled || printStream != null) {
                int n = context.getCodeState().getCode().length;
                PrintWriter printWriter = new PrintWriter(printStream);
                for (int i = 0; i < n; i += Disassembler.disassemble(context, i, printWriter)) {
                    printWriter.println();
                }
                printWriter.flush();
                return;
            }
            throw new AssertionError((Object)"null out");
        }
        throw new AssertionError((Object)"null ctxt");
    }

    static String disassembleInstrString(Context context, int n) {
        if ($assertionsDisabled || context != null) {
            StringWriter stringWriter = new StringWriter();
            Disassembler.disassemble(context, n, new PrintWriter(stringWriter));
            return stringWriter.toString();
        }
        throw new AssertionError((Object)"null ctxt");
    }

    private static String getPrimitiveName(Dispatcher dispatcher, int n) {
        if ($assertionsDisabled || dispatcher != null) {
            if (n < 0 || n >= dispatcher.size()) {
                return "unknown primitive " + n;
            }
            return dispatcher.getName(n);
        }
        throw new AssertionError((Object)"null disp");
    }
}

