/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.unix;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.concurrent.atomic.AtomicInteger;
import org.ocamljava.runtime.context.Context;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.context.DirectoryContents;
import org.ocamljava.runtime.context.FilesState;
import org.ocamljava.runtime.kernel.Channel;
import org.ocamljava.runtime.kernel.CodeRunner;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.FalseExit;
import org.ocamljava.runtime.kernel.Fatal;
import org.ocamljava.runtime.kernel.Misc;
import org.ocamljava.runtime.kernel.OCamlJavaException;
import org.ocamljava.runtime.kernel.Signals;
import org.ocamljava.runtime.util.Signal;
import org.ocamljava.runtime.util.SignalKind;
import org.ocamljava.runtime.values.Value;

final class Unix {
    static final String INVALID_DESCRIPTOR_MSG = "invalid descriptor";
    static final String UNSUPPORTED_SOCKOPT_MSG = "unsupported socket option";
    static final String DIRLISTING_CLOSED_MSG = "directory listing is closed";
    static final double MILLISECS_PER_SEC = 1000.0;

    private Unix() {
    }

    static void fail(String string, Exception exception) throws Fail.Exception {
        if ($assertionsDisabled || string != null) {
            if ($assertionsDisabled || exception != null) {
                String string2 = exception.getMessage();
                Unix.fail(string, string2 != null ? string2 : "");
                return;
            }
            throw new AssertionError((Object)"null e");
        }
        throw new AssertionError((Object)"null prim");
    }

    static void fail(String string, String string2) throws Fail.Exception {
        if ($assertionsDisabled || string != null) {
            if ($assertionsDisabled || string2 != null) {
                Value value = CurrentContext.CODE_STATE.getCallback("Unix.Unix_error");
                if (value == null) {
                    Fail.invalidArgument("Exception Unix.Unix_error not initialized, please link unix.cma");
                } else {
                    Value value2 = Value.createBlock(0, value, Value.ZERO, Value.createString(string), Value.createString(string2));
                    Fail.raise(value2);
                }
                return;
            }
            throw new AssertionError((Object)"null msg");
        }
        throw new AssertionError((Object)"null prim");
    }

    static Value createInetAddr(InetAddress inetAddress) throws Fail.Exception {
        if (inetAddress != null) {
            return Value.createString(inetAddress.getAddress());
        }
        Unix.fail("", "unable to get address");
        return Value.UNIT;
    }

    static Value createSockAddr(InetSocketAddress inetSocketAddress) throws Fail.Exception {
        if (inetSocketAddress != null) {
            return Value.createBlock(1, Unix.createInetAddr(inetSocketAddress.getAddress()), Value.createLong(inetSocketAddress.getPort()));
        }
        Unix.fail("", "unable to get socket address");
        return Value.UNIT;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static String emul(String string, String string2, String ... stringArray) throws Fail.Exception, FalseExit {
        int n;
        StringBuilder stringBuilder;
        Object object;
        assert (string != null) : "null prim";
        assert (string2 != null) : "null cmd";
        assert (stringArray != null) : "null args";
        Context context = CurrentContext.CONTEXT;
        if (!context.getParameters().isUnixEmulated()) {
            Fail.invalidArgument("Unix." + string + " not implemented");
            return null;
        }
        int n2 = stringArray.length;
        String[] stringArray2 = new String[n2 + 1];
        stringArray2[0] = Unix.lookupPath(string2);
        System.arraycopy(stringArray, 0, stringArray2, 1, n2);
        ProcessBuilder processBuilder = new ProcessBuilder(stringArray2);
        processBuilder.directory(context.getFilesState().getPwd());
        processBuilder.redirectErrorStream(true);
        try {
            Process process = processBuilder.start();
            object = process.getInputStream();
            int n3 = process.waitFor();
            if (n3 != 0) {
                return null;
            }
            stringBuilder = new StringBuilder();
            n = ((InputStream)object).read();
        }
        catch (InterruptedIOException interruptedIOException) {
            object = FalseExit.createFromContext(context);
            ((Throwable)object).fillInStackTrace();
            throw object;
        }
        catch (IOException iOException) {
            return null;
        }
        catch (InterruptedException interruptedException) {
            object = FalseExit.createFromContext(context);
            ((Throwable)object).fillInStackTrace();
            throw object;
        }
        {
            while (n != -1) {
                stringBuilder.append((char)n);
                n = ((InputStream)object).read();
            }
            return stringBuilder.toString();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    static String lookupPath(String string) {
        String[] stringArray;
        String string2 = System.getenv("PATH");
        if (string.indexOf(File.separatorChar) != -1) return string;
        if (string2 == null) return string;
        String[] stringArray2 = stringArray = string2.split(File.pathSeparator);
        int n = stringArray2.length;
        int n2 = 0;
        while (n2 < n) {
            String string3 = stringArray2[n2];
            File file = new File(string3, string);
            if (file.exists() && file.isFile()) {
                return file.getAbsolutePath();
            }
            ++n2;
        }
        return string;
    }

    static final class AlarmThread
    extends Thread {
        private static final String PREFIX = "OCaml-Java-AlarmThread-";
        private static final AtomicInteger NEXT_ID = new AtomicInteger();
        private final CodeRunner codeRunner;
        private final Context context;
        private long millis;
        private final long interval;
        private final SignalKind signal;
        private boolean activated;
        private long start;

        AlarmThread(CodeRunner codeRunner, long l, long l2, SignalKind signalKind) {
            super(codeRunner.getContext().getThreadsState().getThreadGroup(), AlarmThread.getNextName());
            if ($assertionsDisabled || codeRunner != null) {
                if ($assertionsDisabled || l > 0L) {
                    if ($assertionsDisabled || l2 >= 0L) {
                        if ($assertionsDisabled || signalKind != null) {
                            this.codeRunner = codeRunner;
                            this.context = codeRunner.getContext();
                            this.millis = l;
                            this.interval = l2;
                            this.signal = signalKind;
                            this.activated = true;
                            this.start();
                            return;
                        }
                        throw new AssertionError((Object)"null sgn");
                    }
                    throw new AssertionError((Object)"itv should be >= 0");
                }
                throw new AssertionError((Object)"val should be > 0");
            }
            throw new AssertionError((Object)"null runner");
        }

        long getInterval() {
            return this.interval;
        }

        long getValue() {
            return this.millis - (System.currentTimeMillis() - this.start);
        }

        long unactivate() {
            this.activated = false;
            return this.millis - (System.currentTimeMillis() - this.start);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            do {
                block8: {
                    Channel channel;
                    this.start = System.currentTimeMillis();
                    try {
                        Thread.sleep(this.millis);
                        if (!this.activated) break block8;
                    }
                    catch (InterruptedException interruptedException) {
                        return;
                    }
                    Signals.enqueueSignal(new Signal(this.signal));
                    try {
                        Signals.processSignal(this.codeRunner);
                    }
                    catch (FalseExit falseExit) {
                        this.context.getSignalsState().setAsyncException(falseExit);
                    }
                    catch (Fail.Exception exception) {
                        channel = this.context.getFilesState().getChannel(2);
                        Value value = this.context.getCodeState().getGlobalData();
                        String string = Misc.convertException(exception.asValue(value), value);
                        Channel.tryWrite(channel, "Error in signal handler: exception " + string);
                    }
                    catch (Fatal.Exception exception) {
                        channel = this.context.getFilesState().getChannel(2);
                        Channel.tryWrite(channel, "Error in signal handler: exception " + exception.getMessage());
                    }
                    catch (OCamlJavaException oCamlJavaException) {
                        channel = this.context.getFilesState().getChannel(2);
                        Channel.tryWrite(channel, "Error in signal handler: exception " + oCamlJavaException.getMessage());
                    }
                }
                this.millis = this.interval;
            } while (this.millis > 0L);
        }

        private static String getNextName() {
            StringBuilder stringBuilder = new StringBuilder(PREFIX);
            stringBuilder.append(NEXT_ID.getAndIncrement());
            return stringBuilder.toString();
        }
    }

    static final class DirList {
        private int nextIndex;
        private final String[] elems;
        private boolean open;

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        DirList(Value value) throws Fail.Exception {
            assert (value != null) : "null path";
            this.nextIndex = 0;
            String[] stringArray = null;
            FilesState filesState = CurrentContext.FILES_STATE;
            if (filesState.getFileHook() != null) {
                try {
                    stringArray = DirectoryContents.getAsArray(filesState, value);
                }
                catch (Throwable throwable) {
                    Unix.fail("opendir", "unable to get directory content");
                }
            }
            if (stringArray == null) {
                File file = CurrentContext.FILES_STATE.getRealFile(value);
                stringArray = file.list();
            }
            if (stringArray != null) {
                int n = stringArray.length;
                this.elems = new String[n + 2];
                this.elems[0] = ".";
                this.elems[1] = "..";
                System.arraycopy(stringArray, 0, this.elems, 2, n);
                this.open = true;
                return;
            }
            Unix.fail("opendir", "unable to get directory content");
            this.elems = null;
            this.open = false;
        }

        String next() throws Fail.Exception {
            block1: {
                block2: {
                    block0: {
                        if (!this.open) break block0;
                        if (this.nextIndex >= this.elems.length) break block1;
                        break block2;
                    }
                    Unix.fail("readdir", Unix.DIRLISTING_CLOSED_MSG);
                    return null;
                }
                return this.elems[this.nextIndex++];
            }
            Fail.raiseEndOfFile();
            return null;
        }

        void rewind() throws Fail.Exception {
            if (this.open) {
                this.nextIndex = 0;
            } else {
                Unix.fail("rewinddir", Unix.DIRLISTING_CLOSED_MSG);
            }
        }

        void close() {
            this.open = false;
        }
    }
}

