/*
 * Decompiled with CFR 0.152.
 */
package ocaml.stdlib;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import org.ocamljava.runtime.annotations.markers.CompiledModule;
import org.ocamljava.runtime.kernel.AbstractNativeRunner;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.Fatal;
import org.ocamljava.runtime.kernel.OCamlJavaModule;
import org.ocamljava.runtime.kernel.ThreadLocalFactory;
import org.ocamljava.runtime.primitives.stdlib.Ints;
import org.ocamljava.runtime.values.Value;

@CompiledModule
public final class Int64
implements OCamlJavaModule {
    public static final ThreadLocal GLOBALS;
    private static final ThreadLocal CONSTANTS;
    public static final MethodHandle succ_1031;
    public static final MethodHandle pred_1033;
    public static final MethodHandle abs_1035;
    public static final MethodHandle lognot_1039;
    public static final MethodHandle to_string_1042;
    public static final MethodHandle compare_1048;

    static {
        CONSTANTS = ThreadLocalFactory.constantsStorage(Int64.class);
        GLOBALS = ThreadLocalFactory.globalStorage("Int64");
        succ_1031 = cfr_ldc_0();
        pred_1033 = cfr_ldc_1();
        abs_1035 = cfr_ldc_2();
        lognot_1039 = cfr_ldc_3();
        to_string_1042 = cfr_ldc_4();
        compare_1048 = cfr_ldc_5();
    }

    public static Value createConstants() {
        return Value.createBlock(0, Value.createString("%d"));
    }

    public static Value succ_1031(Value n) throws Fail.Exception, Fatal.Exception {
        return Value.createInt64(n.asInt64() + 1L);
    }

    public static Value pred_1033(Value n) throws Fail.Exception, Fatal.Exception {
        return Value.createInt64(n.asInt64() - 1L);
    }

    public static Value abs_1035(Value n) throws Fail.Exception, Fatal.Exception {
        return (int)(n.asInt64() < 0L ? 0L : 1L) != 0 ? n : Value.createInt64(-n.asInt64());
    }

    public static Value lognot_1039(Value n) throws Fail.Exception, Fatal.Exception {
        return Value.createInt64(n.asInt64() ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public static Value to_string_1042(Value n) throws Fail.Exception, Fatal.Exception {
        Value value = (Value)CONSTANTS.get();
        return Ints.caml_int64_format(value.get0(), n);
    }

    public static Value compare_1048(Value x, Value y) throws Fail.Exception, Fatal.Exception {
        return Ints.caml_int64_compare(x, y);
    }

    public static Value entry() throws Fail.Exception, Fatal.Exception {
        Value value = AbstractNativeRunner.createGlobal("Int64", 11);
        value.set0(Value.createInt64(0L));
        value.set1(Value.createInt64(1L));
        value.set2(Value.createInt64(-1L));
        Value value2 = Value.createClosure(succ_1031);
        value.set3(value2);
        value2 = Value.createClosure(pred_1033);
        value.set4(value2);
        value2 = Value.createClosure(abs_1035);
        value.set5(value2);
        value.set7(Value.createInt64(Long.MIN_VALUE));
        value.set6(Value.createInt64(Long.MAX_VALUE));
        value2 = Value.createClosure(lognot_1039);
        value.set(8, value2);
        value2 = Value.createClosure(to_string_1042);
        value.set(9, value2);
        value2 = Value.createClosure(compare_1048, 2);
        value.set(10, value2);
        return Value.ZERO;
    }

    /*
     * Works around MethodHandle LDC.
     */
    static MethodHandle cfr_ldc_0() {
        try {
            return MethodHandles.lookup().findStatic(Int64.class, "succ_1031", MethodType.fromMethodDescriptorString("(Lorg/ocamljava/runtime/values/Value;)Lorg/ocamljava/runtime/values/Value;", null));
        }
        catch (NoSuchMethodException | IllegalAccessException except) {
            throw new IllegalArgumentException(except);
        }
    }

    /*
     * Works around MethodHandle LDC.
     */
    static MethodHandle cfr_ldc_1() {
        try {
            return MethodHandles.lookup().findStatic(Int64.class, "pred_1033", MethodType.fromMethodDescriptorString("(Lorg/ocamljava/runtime/values/Value;)Lorg/ocamljava/runtime/values/Value;", null));
        }
        catch (NoSuchMethodException | IllegalAccessException except) {
            throw new IllegalArgumentException(except);
        }
    }

    /*
     * Works around MethodHandle LDC.
     */
    static MethodHandle cfr_ldc_2() {
        try {
            return MethodHandles.lookup().findStatic(Int64.class, "abs_1035", MethodType.fromMethodDescriptorString("(Lorg/ocamljava/runtime/values/Value;)Lorg/ocamljava/runtime/values/Value;", null));
        }
        catch (NoSuchMethodException | IllegalAccessException except) {
            throw new IllegalArgumentException(except);
        }
    }

    /*
     * Works around MethodHandle LDC.
     */
    static MethodHandle cfr_ldc_3() {
        try {
            return MethodHandles.lookup().findStatic(Int64.class, "lognot_1039", MethodType.fromMethodDescriptorString("(Lorg/ocamljava/runtime/values/Value;)Lorg/ocamljava/runtime/values/Value;", null));
        }
        catch (NoSuchMethodException | IllegalAccessException except) {
            throw new IllegalArgumentException(except);
        }
    }

    /*
     * Works around MethodHandle LDC.
     */
    static MethodHandle cfr_ldc_4() {
        try {
            return MethodHandles.lookup().findStatic(Int64.class, "to_string_1042", MethodType.fromMethodDescriptorString("(Lorg/ocamljava/runtime/values/Value;)Lorg/ocamljava/runtime/values/Value;", null));
        }
        catch (NoSuchMethodException | IllegalAccessException except) {
            throw new IllegalArgumentException(except);
        }
    }

    /*
     * Works around MethodHandle LDC.
     */
    static MethodHandle cfr_ldc_5() {
        try {
            return MethodHandles.lookup().findStatic(Int64.class, "compare_1048", MethodType.fromMethodDescriptorString("(Lorg/ocamljava/runtime/values/Value;Lorg/ocamljava/runtime/values/Value;)Lorg/ocamljava/runtime/values/Value;", null));
        }
        catch (NoSuchMethodException | IllegalAccessException except) {
            throw new IllegalArgumentException(except);
        }
    }
}

