/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.javalibs.concurrent;

import java.util.concurrent.atomic.AtomicInteger;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="concurrent", module="AtomicInt32", source="")
public final class AtomicInt32 {
    private AtomicInt32() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"int32"}, returnType="AtomicInt32.t")
    public static Value ocamljava_atomicint32_make(Value initialValue) {
        return Value.createInstance(new AtomicInteger(initialValue.asInt32()));
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"AtomicInt32.t", "int32"}, returnType="int32")
    public static Value ocamljava_atomicint32_add_and_get(Value obj, Value delta) {
        AtomicInteger inst = (AtomicInteger)obj.asCustom();
        int res = inst.addAndGet(delta.asInt32());
        return Value.createInt32(res);
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"AtomicInt32.t", "int32", "int32"}, returnType="bool")
    public static Value ocamljava_atomicint32_compare_and_set(Value obj, Value expect, Value update) {
        AtomicInteger inst = (AtomicInteger)obj.asCustom();
        boolean res = inst.compareAndSet(expect.asInt32(), update.asInt32());
        return res ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"AtomicInt32.t"}, returnType="int32")
    public static Value ocamljava_atomicint32_decrement_and_get(Value obj) {
        AtomicInteger inst = (AtomicInteger)obj.asCustom();
        int res = inst.decrementAndGet();
        return Value.createInt32(res);
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"AtomicInt32.t"}, returnType="int32")
    public static Value ocamljava_atomicint32_get(Value obj) {
        AtomicInteger inst = (AtomicInteger)obj.asCustom();
        int res = inst.get();
        return Value.createInt32(res);
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"AtomicInt32.t", "int32"}, returnType="int32")
    public static Value ocamljava_atomicint32_get_and_add(Value obj, Value delta) {
        AtomicInteger inst = (AtomicInteger)obj.asCustom();
        int res = inst.getAndAdd(delta.asInt32());
        return Value.createInt32(res);
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"AtomicInt32.t"}, returnType="int32")
    public static Value ocamljava_atomicint32_get_and_decrement(Value obj) {
        AtomicInteger inst = (AtomicInteger)obj.asCustom();
        int res = inst.getAndDecrement();
        return Value.createInt32(res);
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"AtomicInt32.t"}, returnType="int32")
    public static Value ocamljava_atomicint32_get_and_increment(Value obj) {
        AtomicInteger inst = (AtomicInteger)obj.asCustom();
        int res = inst.getAndIncrement();
        return Value.createInt32(res);
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"AtomicInt32.t", "int32"}, returnType="int32")
    public static Value ocamljava_atomicint32_get_and_set(Value obj, Value newValue) {
        AtomicInteger inst = (AtomicInteger)obj.asCustom();
        int res = inst.getAndSet(newValue.asInt32());
        return Value.createInt32(res);
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"AtomicInt32.t"}, returnType="int32")
    public static Value ocamljava_atomicint32_increment_and_get(Value obj) {
        AtomicInteger inst = (AtomicInteger)obj.asCustom();
        int res = inst.incrementAndGet();
        return Value.createInt32(res);
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"AtomicInt32.t", "int32"}, returnType="unit")
    public static Value ocamljava_atomicint32_lazy_set(Value obj, Value newValue) {
        AtomicInteger inst = (AtomicInteger)obj.asCustom();
        inst.lazySet(newValue.asInt32());
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"AtomicInt32.t", "int32"}, returnType="unit")
    public static Value ocamljava_atomicint32_set(Value obj, Value newValue) {
        AtomicInteger inst = (AtomicInteger)obj.asCustom();
        inst.set(newValue.asInt32());
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"AtomicInt32.t", "int32", "int32"}, returnType="bool")
    public static Value ocamljava_atomicint32_weak_compare_and_set(Value obj, Value expect, Value update) {
        AtomicInteger inst = (AtomicInteger)obj.asCustom();
        boolean res = inst.weakCompareAndSet(expect.asInt32(), update.asInt32());
        return res ? Value.TRUE : Value.FALSE;
    }
}

