/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.util;

import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.ocamljava.runtime.util.NoSignalSupport;
import org.ocamljava.runtime.util.Signal;
import org.ocamljava.runtime.util.SignalHandler;
import org.ocamljava.runtime.util.SignalKind;
import org.ocamljava.runtime.util.SystemSignalHandler;

public final class SignalSupport {
    public static final SignalHandler DEFAULT_HANDLER;
    public static final SignalHandler IGNORE_HANDLER;
    static final boolean AVAILABLE;
    static final String CLASS_SIGNAL = "sun.misc.Signal";
    static final Constructor<?> CSTR_SIGNAL;
    static final Method MTH_SIGNAL_GET_NAME;
    static final Method MTH_SIGNAL_GET_NUMBER;
    static final Method MTH_SIGNAL_HANDLE;
    static final Method MTH_SIGNAL_RAISE;
    static final Method MTH_HANDLER_HANDLE;
    private static final String METH_SIGNAL_GET_NAME = "getName";
    private static final String METH_SIGNAL_GET_NUMBER = "getNumber";
    private static final String METH_SIGNAL_HANDLE = "handle";
    private static final String METH_SIGNAL_RAISE = "raise";
    private static final String CLASS_HANDLER = "sun.misc.SignalHandler";
    private static final String METH_HANDLER_HANDLE = "handle";
    private static final String FLD_HANDLER_DEFAULT = "SIG_DFL";
    private static final String FLD_HANDLER_IGNORE = "SIG_IGN";
    private static final Class<?> CL_SIGNAL;
    private static final Class<?> CL_HANDLER;

    private SignalSupport() {
    }

    public static boolean isAvailable() {
        return NoSignalSupport.AVAILABLE;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean handle(SignalHandler signalHandler, Signal ... signalArray) {
        int n;
        int n2;
        Signal[] signalArray2;
        Object object;
        block12: {
            if (!NoSignalSupport.$assertionsDisabled && signalHandler == null) {
                throw new AssertionError((Object)"null handler");
            }
            if (!NoSignalSupport.$assertionsDisabled && signalArray == null) {
                throw new AssertionError((Object)"null signals");
            }
            if (!NoSignalSupport.isAvailable()) return false;
            if (signalHandler instanceof SystemSignalHandler) {
                object = ((SystemSignalHandler)signalHandler).getActualHandler();
                break block12;
            }
            Object object2 = Proxy.newProxyInstance(SignalSupport.class.getClassLoader(), new Class[]{NoSignalSupport.CL_HANDLER}, (InvocationHandler)new ProxyHandler(signalHandler));
            Signal[] signalArray3 = signalArray;
            int n3 = signalArray3.length;
            int n4 = 0;
            while (n4 < n3) {
                Signal signal = signalArray3[n4];
                if (signal.isValid()) {
                    NoSignalSupport.MTH_SIGNAL_HANDLE.invoke(null, signal.inst, object2);
                }
                ++n4;
            }
            return true;
            {
                catch (Throwable throwable) {
                    return false;
                }
            }
        }
        try {
            signalArray2 = signalArray;
            n2 = signalArray2.length;
            n = 0;
        }
        catch (Throwable throwable) {
            return false;
        }
        while (n < n2) {
            Signal signal = signalArray2[n];
            if (signal.isValid()) {
                NoSignalSupport.MTH_SIGNAL_HANDLE.invoke(null, signal.inst, object);
            }
            ++n;
        }
        return true;
    }

    public static void test(PrintStream printStream) {
        block1: {
            if (!NoSignalSupport.$assertionsDisabled && printStream == null) break block1;
            SignalKind[] signalKindArray = SignalKind.values();
            int n = signalKindArray.length;
            int n2 = 0;
            while (true) {
                String string;
                Object[] objectArray;
                block5: {
                    block3: {
                        block4: {
                            block2: {
                                if (n2 >= n) break block2;
                                SignalKind signalKind = signalKindArray[n2];
                                objectArray = new Object[2];
                                objectArray[0] = signalKind.name();
                                if (!new Signal(signalKind).isValid()) break block3;
                                break block4;
                            }
                            return;
                        }
                        string = "supported";
                        break block5;
                    }
                    string = "unsupported";
                }
                objectArray[1] = string;
                printStream.printf("signal '%s' is %s\n", objectArray);
                ++n2;
            }
        }
        throw new AssertionError((Object)"null out");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static {
        boolean bl;
        Object object;
        Object object2;
        Method method;
        Method method2;
        Method method3;
        Method method4;
        Method method5;
        Constructor<?> constructor;
        Class<?> clazz;
        Class<?> clazz2;
        try {
            clazz2 = Class.forName(CLASS_SIGNAL);
            clazz = Class.forName(CLASS_HANDLER);
            constructor = clazz2.getConstructor(String.class);
            method5 = clazz2.getMethod(METH_SIGNAL_GET_NAME, new Class[0]);
            method4 = clazz2.getMethod(METH_SIGNAL_GET_NUMBER, new Class[0]);
            method3 = clazz2.getMethod("handle", clazz2, clazz);
            method2 = clazz2.getMethod(METH_SIGNAL_RAISE, clazz2);
            method = clazz.getMethod("handle", clazz2);
            object2 = clazz.getField(FLD_HANDLER_DEFAULT).get(null);
            object = clazz.getField(FLD_HANDLER_IGNORE).get(null);
            bl = true;
        }
        catch (Throwable throwable) {
            clazz2 = null;
            clazz = null;
            constructor = null;
            method5 = null;
            method4 = null;
            method3 = null;
            method2 = null;
            method = null;
            object2 = null;
            object = null;
            bl = false;
        }
        CL_SIGNAL = clazz2;
        CL_HANDLER = clazz;
        CSTR_SIGNAL = constructor;
        MTH_SIGNAL_GET_NAME = method5;
        MTH_SIGNAL_GET_NUMBER = method4;
        MTH_SIGNAL_HANDLE = method3;
        MTH_SIGNAL_RAISE = method2;
        MTH_HANDLER_HANDLE = method;
        DEFAULT_HANDLER = new SystemSignalHandler(object2);
        IGNORE_HANDLER = new SystemSignalHandler(object);
        AVAILABLE = bl;
    }

    private static final class ProxyHandler
    implements InvocationHandler {
        private final SignalHandler handler;

        private ProxyHandler(SignalHandler signalHandler) {
            if ($assertionsDisabled || signalHandler != null) {
                this.handler = signalHandler;
                return;
            }
            throw new AssertionError((Object)"null h");
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            if (!method.getName().equals("handle")) return null;
            if (!method.getReturnType().equals(Void.class)) return null;
            if (method.getParameterTypes().length != 1) return null;
            if (!method.getParameterTypes()[0].getName().equals(SignalSupport.CLASS_SIGNAL)) return null;
            this.handler.handle(new Signal(objectArray[0]));
            return null;
        }
    }
}

