/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.bigarray;

import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.Fatal;
import org.ocamljava.runtime.primitives.otherlibs.bigarray.BigArray;
import org.ocamljava.runtime.util.IntegerUtils;
import org.ocamljava.runtime.values.Value;

final class MemArray {
    private final ByteBuffer data;
    private final int[] dim;
    private final long flags;

    /*
     * Unable to fully structure code
     */
    MemArray(long var1_1, int[] var3_2, ByteBuffer var4_3) throws Fail.Exception, Fatal.Exception {
        block8: {
            block9: {
                block7: {
                    super();
                    var5_4 = var3_2.length;
                    if (MemArray.$assertionsDisabled) break block7;
                    if (var5_4 < 1) break block8;
                    if (var5_4 > 16) break block8;
                }
                if (!MemArray.$assertionsDisabled && (var1_1 & 255L) > 11L) break block9;
                var6_5 = new int[var5_4];
                System.arraycopy(var3_2, 0, var6_5, 0, var5_4);
                if (var4_3 != null) {
                    this.data = var4_3;
                    this.flags = var1_1 & 511L | 1024L;
lbl13:
                    // 2 sources

                    while (true) {
                        this.dim = var6_5;
                        return;
                    }
                }
                var7_6 = 1L;
                var9_7 = 0;
                while (true) {
                    block13: {
                        block11: {
                            block12: {
                                block10: {
                                    if (var9_7 >= var5_4) break block10;
                                    if ((var7_6 *= (long)var6_5[var9_7]) < 0L) break block11;
                                    break block12;
                                }
                                var9_8 = var7_6 * (long)BigArray.CAML_BA_ELEMENT_SIZE[(int)var1_1 & 255];
                                if (var9_8 < 0L || var9_8 > 0x7FFFFFFFL) {
                                    Fail.raiseOutOfMemory();
                                }
                                this.data = ByteBuffer.allocate(IntegerUtils.ensure32s(var9_8));
                                this.flags = var1_1 & 511L | 0L;
                                ** continue;
                            }
                            if (var7_6 <= 0x7FFFFFFFL) break block13;
                        }
                        Fail.raiseOutOfMemory();
                    }
                    ++var9_7;
                }
            }
            throw new AssertionError((Object)"invalid element kind");
        }
        throw new AssertionError((Object)"invalid number of dimensions");
    }

    ByteBuffer getData() {
        return this.data;
    }

    int getNumDims() {
        return this.dim.length;
    }

    int[] getDims() {
        return this.dim;
    }

    int getDim(int n) throws ArrayIndexOutOfBoundsException {
        return this.dim[n];
    }

    long getFlags() {
        return this.flags;
    }

    Value get(int[] nArray) throws Fail.Exception {
        if ($assertionsDisabled || nArray != null) {
            if (nArray.length != this.dim.length) {
                Fail.invalidArgument("Bigarray.get: wrong number of indices");
            }
            int n = this.offset(nArray);
            switch ((int)this.flags & 0xFF) {
                case 0: {
                    return Value.createDouble(this.data.getFloat(n * 4));
                }
                case 1: {
                    return Value.createDouble(this.data.getDouble(n * 8));
                }
                case 2: {
                    return Value.createLong(this.data.get(n * 1));
                }
                case 3: {
                    return Value.createLong(IntegerUtils.signedToUnsignedByte(this.data.get(n * 1)));
                }
                case 4: {
                    return Value.createLong(this.data.getShort(n * 2));
                }
                case 5: {
                    return Value.createLong(IntegerUtils.signedToUnsignedShort(this.data.getShort(n * 2)));
                }
                case 6: {
                    return Value.createInt32(this.data.getInt(n * 4));
                }
                case 7: {
                    return Value.createInt64(this.data.getLong(n * 8));
                }
                case 9: {
                    return Value.createNativeInt(this.data.getLong(n * 8));
                }
                case 8: {
                    return Value.createLong(this.data.getLong(n * 8));
                }
                case 10: {
                    return Value.createDoubleArray(this.data.getFloat(n * 8), this.data.getFloat(n * 8) + 4.0f);
                }
                case 11: {
                    return Value.createDoubleArray(this.data.getDouble(n * 16), this.data.getDouble(n * 16) + 8.0);
                }
            }
            assert (false) : "invalid elements kind";
            return Value.UNIT;
        }
        throw new AssertionError((Object)"null index");
    }

    void set(int[] nArray, Value value) throws Fail.Exception {
        if ($assertionsDisabled || nArray != null) {
            if (nArray.length != this.dim.length) {
                Fail.invalidArgument("Bigarray.set: wrong number of indices");
            }
            int n = this.offset(nArray);
            switch ((int)this.flags & 0xFF) {
                case 0: {
                    this.data.putFloat(n * 4, (float)value.asDouble());
                    break;
                }
                case 1: {
                    this.data.putDouble(n * 8, value.asDouble());
                    break;
                }
                case 2: 
                case 3: {
                    this.data.put(n * 1, (byte)value.asLong());
                    break;
                }
                case 4: 
                case 5: {
                    this.data.putShort(n * 2, (short)value.asLong());
                    break;
                }
                case 6: {
                    this.data.putInt(n * 4, value.asInt32());
                    break;
                }
                case 7: {
                    this.data.putLong(n * 8, value.asInt64());
                    break;
                }
                case 9: {
                    this.data.putLong(n * 8, value.asNativeInt());
                    break;
                }
                case 8: {
                    this.data.putLong(n * 8, value.asLong());
                    break;
                }
                case 10: {
                    this.data.putFloat(n * 8, (float)value.getDouble0());
                    this.data.putFloat(n * 8 + 4, (float)value.getDouble1());
                    break;
                }
                case 11: {
                    this.data.putDouble(n * 16, value.getDouble0());
                    this.data.putDouble(n * 16 + 8, value.getDouble1());
                    break;
                }
                default: {
                    assert (false) : "invalid elements kind";
                    break;
                }
            }
            return;
        }
        throw new AssertionError((Object)"null index");
    }

    long getNumElems() {
        long l = 1L;
        int n = this.dim.length;
        for (int i = 0; i < n; ++i) {
            l *= (long)this.dim[i];
        }
        return l;
    }

    /*
     * Enabled aggressive block sorting
     */
    int offset(int[] nArray) throws Fail.Exception {
        assert (nArray != null) : "null index";
        int n = 0;
        if ((this.flags & 0x100L) != 0L) {
            int n2 = nArray.length - 1;
            while (n2 >= 0) {
                if (nArray[n2] - 1 >= this.dim[n2]) {
                    Fail.arrayBoundError();
                }
                n = n * this.dim[n2] + (nArray[n2] - 1);
                --n2;
            }
            return n;
        }
        int n3 = 0;
        while (n3 < nArray.length) {
            if (nArray[n3] >= this.dim[n3]) {
                Fail.arrayBoundError();
            }
            n = n * this.dim[n3] + nArray[n3];
            ++n3;
        }
        return n;
    }

    void unMap() {
        ((MappedByteBuffer)this.data).force();
    }
}

