/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.unix;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SocketChannel;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.kernel.Channel;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.FalseExit;
import org.ocamljava.runtime.primitives.otherlibs.unix.Unix;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="unix", module="Unix", source="otherlibs/unix/sendrecv.c")
public final class Sendrecv {
    private Sendrecv() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Primitive(compatibility=PrimitiveCompatibility.PARTIAL, comment={"Flags are ignored."}, parameterTypes={"Unix.file_descr", "string", "int", "int", "Unix.msg_flag list"}, returnType="int")
    public static Value unix_recv(Value value, Value value2, Value value3, Value value4, Value value5) throws Fail.Exception, FalseExit {
        DatagramChannel datagramChannel;
        Object object;
        try {
            Channel channel = CurrentContext.FILES_STATE.getChannel(value.asCastedInt());
            if (channel == null) {
                Unix.fail("recv", "invalid descriptor");
                return Value.UNIT;
            }
            object = channel.asSocket();
            datagramChannel = channel.asDatagramSocket();
            if (object != null) {
                int n = channel.read(value2.getBytesForModification(), value3.asCastedInt(), value4.asCastedInt());
                return Value.createLong(n);
            }
        }
        catch (InterruptedIOException interruptedIOException) {
            object = FalseExit.createFromContext(CurrentContext.CONTEXT);
            ((Throwable)object).fillInStackTrace();
            throw object;
        }
        catch (IOException iOException) {
            Unix.fail("recv", iOException);
            return Value.UNIT;
        }
        if (datagramChannel != null) {
            ByteBuffer byteBuffer = ByteBuffer.wrap(value2.getBytesForModification(), value3.asCastedInt(), value4.asCastedInt());
            datagramChannel.receive(byteBuffer);
            return Value.createLong(byteBuffer.position());
        }
        Unix.fail("recv", "invalid descriptor");
        return Value.UNIT;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Primitive(compatibility=PrimitiveCompatibility.PARTIAL, comment={"Flags are ignored."}, parameterTypes={"Unix.file_descr", "string", "int", "int", "Unix.msg_flag list"}, returnType="int")
    public static Value unix_send(Value value, Value value2, Value value3, Value value4, Value value5) throws Fail.Exception, FalseExit {
        DatagramChannel datagramChannel;
        Object object;
        try {
            Channel channel = CurrentContext.FILES_STATE.getChannel(value.asCastedInt());
            if (channel == null) {
                Unix.fail("send", "invalid descriptor");
                return Value.UNIT;
            }
            object = channel.asSocket();
            datagramChannel = channel.asDatagramSocket();
            if (object != null) {
                int n = ((SocketChannel)object).write(ByteBuffer.wrap(value2.getBytes(), value3.asCastedInt(), value4.asCastedInt()));
                return Value.createLong(n);
            }
        }
        catch (InterruptedIOException interruptedIOException) {
            object = FalseExit.createFromContext(CurrentContext.CONTEXT);
            ((Throwable)object).fillInStackTrace();
            throw object;
        }
        catch (IOException iOException) {
            Unix.fail("send", iOException);
            return Value.UNIT;
        }
        if (datagramChannel != null) {
            ByteBuffer byteBuffer = ByteBuffer.wrap(value2.getBytes(), value3.asCastedInt(), value4.asCastedInt());
            datagramChannel.send(byteBuffer, datagramChannel.getRemoteAddress());
            return Value.createLong(byteBuffer.position());
        }
        Unix.fail("send", "invalid descriptor");
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.PARTIAL, comment={"Flags are ignored."}, parameterTypes={"Unix.file_descr", "string", "int", "int", "Unix.msg_flag list"}, returnType="int * Unix.sockaddr")
    public static Value unix_recvfrom(Value value, Value value2, Value value3, Value value4, Value value5) throws Fail.Exception, FalseExit {
        Channel channel = CurrentContext.FILES_STATE.getChannel(value.asCastedInt());
        if (channel == null) {
            Unix.fail("recvfrom", "invalid descriptor");
            return Value.UNIT;
        }
        DatagramChannel datagramChannel = channel.asDatagramSocket();
        if (datagramChannel == null) {
            Unix.fail("recvfrom", "invalid descriptor");
            return Value.UNIT;
        }
        try {
            ByteBuffer byteBuffer = ByteBuffer.wrap(value2.getBytesForModification(), value3.asCastedInt(), value4.asCastedInt());
            SocketAddress socketAddress = datagramChannel.receive(byteBuffer);
            return Value.createBlock(0, Value.createLong(byteBuffer.position()), Unix.createSockAddr((InetSocketAddress)socketAddress));
        }
        catch (InterruptedIOException interruptedIOException) {
            FalseExit falseExit = FalseExit.createFromContext(CurrentContext.CONTEXT);
            falseExit.fillInStackTrace();
            throw falseExit;
        }
        catch (IOException iOException) {
            Unix.fail("recvfrom", iOException);
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.PARTIAL, comment={"Flags are ignored."}, parameterTypes={"Unix.file_descr", "string", "int", "int", "Unix.msg_flag list", "Unix.sockaddr"}, returnType="int")
    public static Value unix_sendto(Value value, Value value2, Value value3, Value value4, Value value5, Value value6) throws Fail.Exception, FalseExit {
        Channel channel;
        InetSocketAddress inetSocketAddress;
        block6: {
            try {
                inetSocketAddress = new InetSocketAddress(InetAddress.getByAddress(value6.get0().getBytes()), value6.get1().asCastedInt());
                channel = CurrentContext.FILES_STATE.getChannel(value.asCastedInt());
                if (channel != null) break block6;
            }
            catch (IOException iOException) {
                Unix.fail("sendto", iOException);
                return Value.UNIT;
            }
            Unix.fail("sendto", "invalid descriptor");
            return Value.UNIT;
        }
        DatagramChannel datagramChannel = channel.asDatagramSocket();
        if (datagramChannel == null) {
            Unix.fail("sendto", "invalid descriptor");
            return Value.UNIT;
        }
        try {
            datagramChannel.send(ByteBuffer.wrap(value2.getBytes(), value3.asCastedInt(), value4.asCastedInt()), inetSocketAddress);
            return value4;
        }
        catch (InterruptedIOException interruptedIOException) {
            FalseExit falseExit = FalseExit.createFromContext(CurrentContext.CONTEXT);
            falseExit.fillInStackTrace();
            throw falseExit;
        }
        catch (IOException iOException) {
            Unix.fail("sendto", iOException);
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.PARTIAL, comment={"Flags are ignored."}, parameterTypes={"Unix.file_descr", "string", "int", "int", "Unix.msg_flag list", "Unix.sockaddr"}, returnType="int")
    public static Value unix_sendto_native(Value value, Value value2, Value value3, Value value4, Value value5, Value value6) throws Fail.Exception, FalseExit {
        return Sendrecv.unix_sendto(value, value2, value3, value4, value5, value6);
    }
}

