/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.values;

import java.util.Arrays;
import org.ocamljava.runtime.kernel.Fatal;
import org.ocamljava.runtime.values.AbstractDoubleArrayValue;
import org.ocamljava.runtime.values.BlockValue;
import org.ocamljava.runtime.values.CustomOperations;
import org.ocamljava.runtime.values.Value;

public final class LargeDoubleArrayValue
extends AbstractDoubleArrayValue {
    private static final int BITS = 31;
    private static final int MASK = Integer.MAX_VALUE;
    private long length;
    private long sizeTagged;
    private long sizeMinusOneTagged;
    private Value sizeWrapped;
    private double[][] values;

    LargeDoubleArrayValue(long l) {
        super(254, l * 1L);
        int n = (int)(l >> 31) + 1;
        int n2 = (int)l & Integer.MAX_VALUE;
        this.length = l;
        this.sizeTagged = l << 1 | 1L;
        this.sizeMinusOneTagged = l - 1L << 1 | 1L;
        this.sizeWrapped = Value.createLong(l);
        this.values = new double[n][];
        for (int i = 0; i < n - 1; ++i) {
            this.values[i] = new double[Integer.MIN_VALUE];
        }
        this.values[n - 1] = new double[n2];
    }

    @Override
    public double getDouble(long l) throws ArrayIndexOutOfBoundsException {
        int n = (int)(l >> 31);
        int n2 = (int)l & Integer.MAX_VALUE;
        return this.values[n][n2];
    }

    @Override
    public double getDouble(int n) throws ArrayIndexOutOfBoundsException {
        return this.values[0][n];
    }

    @Override
    public void setDouble(long l, double d) throws ArrayIndexOutOfBoundsException {
        int n = (int)(l >> 31);
        int n2 = (int)l & Integer.MAX_VALUE;
        this.values[n][n2] = d;
    }

    @Override
    public void setDouble(int n, double d) throws ArrayIndexOutOfBoundsException {
        this.values[0][n] = d;
    }

    @Override
    public long sizeDoubles() {
        return this.length;
    }

    @Override
    public long arrayLength() {
        return this.length;
    }

    @Override
    public long arrayLengthTagged() {
        return this.sizeTagged;
    }

    @Override
    public long arrayLengthMinusOneTagged() {
        return this.sizeMinusOneTagged;
    }

    @Override
    public Value arrayLengthWrapped() {
        return this.sizeWrapped;
    }

    @Override
    protected void truncateInstance(long l) {
        double[][] dArray = this.values;
        int n = (int)(l >> 31) + 1;
        int n2 = (int)l & Integer.MAX_VALUE;
        this.length = l;
        this.sizeTagged = l << 1 | 1L;
        this.sizeMinusOneTagged = l - 1L << 1 | 1L;
        this.sizeWrapped = Value.createLong(l);
        this.values = new double[n][];
        int n3 = 0;
        while (true) {
            if (n3 < n - 1) {
                this.values[n3] = new double[Integer.MIN_VALUE];
            } else {
                this.values[n - 1] = new double[n2];
                for (n3 = 0; n3 < n2; ++n3) {
                    this.values[n - 1][n3] = dArray[n - 1][n3];
                }
                return;
            }
            for (int i = 0; i < Integer.MIN_VALUE; ++i) {
                this.values[n3][i] = dArray[n3][i];
            }
            ++n3;
        }
    }

    @Override
    public void copy(BlockValue blockValue) {
        long l = Math.min(this.length, blockValue.sizeDoubles());
        for (long i = 0L; i < l; ++i) {
            this.setDouble(i, blockValue.getDouble(i));
        }
    }

    @Override
    public LargeDoubleArrayValue duplicate() {
        long l = this.length;
        LargeDoubleArrayValue largeDoubleArrayValue = new LargeDoubleArrayValue(l);
        for (long i = 0L; i < l; ++i) {
            largeDoubleArrayValue.setDouble(i, this.getDouble(i));
        }
        return largeDoubleArrayValue;
    }

    @Override
    public void copyValuesIntoArray(Value[] valueArray) {
        int n = (int)Math.min(Integer.MAX_VALUE, this.sizeDoubles());
        for (int i = 0; i < n; ++i) {
            valueArray[i] = Value.createDouble(this.getDouble(i));
        }
    }

    @Override
    public void copyValuesIntoArray(Value[] valueArray, int n) {
        int n2 = (int)Math.min(Integer.MAX_VALUE, this.sizeDoubles());
        for (int i = 0; i < n2; ++i) {
            valueArray[n + i] = Value.createDouble(this.getDouble(i));
        }
    }

    @Override
    public void copyDoublesIntoArray(double[] dArray, int n) {
        int n2 = (int)Math.min(Integer.MAX_VALUE, this.sizeDoubles());
        for (int i = 0; i < n2; ++i) {
            dArray[n + i] = this.getDouble(i);
        }
    }

    @Override
    public void copyRawLongsIntoArray(long[] lArray, int n) {
        int n2 = (int)Math.min(Integer.MAX_VALUE, this.sizeDoubles());
        for (int i = 0; i < n2; ++i) {
            lArray[n + i] = (long)this.getDouble(i);
        }
    }

    @Override
    public Value subArray(long l, long l2) {
        LargeDoubleArrayValue largeDoubleArrayValue = new LargeDoubleArrayValue(l2);
        for (long i = 0L; i < l2; ++i) {
            largeDoubleArrayValue.setDouble(i, this.getDouble(i + l));
        }
        return largeDoubleArrayValue;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void blitArray(long l, Value value, long l2, long l3) {
        if (l2 >= l) {
            for (long i = l3 - 1L; i >= 0L; --i) {
                value.setDouble(l2 + i, this.getDouble(l + i));
            }
            return;
        }
        for (long i = 0L; i < l3; ++i) {
            value.setDouble(l2 + i, this.getDouble(l + i));
        }
    }

    public int hashCode() {
        int n = 0;
        double[] dArray = this.values[0];
        int n2 = Math.min(32, dArray.length);
        for (int i = 0; i < n2; ++i) {
            n += (int)Double.doubleToRawLongBits(dArray[i]);
        }
        return n;
    }

    public boolean equals(Object object) {
        int n;
        LargeDoubleArrayValue largeDoubleArrayValue;
        block4: {
            block3: {
                block2: {
                    if (!(object instanceof LargeDoubleArrayValue)) break block2;
                    largeDoubleArrayValue = (LargeDoubleArrayValue)object;
                    n = this.values.length;
                    int n2 = largeDoubleArrayValue.values.length;
                    if (n != n) break block3;
                    break block4;
                }
                return false;
            }
            return false;
        }
        int n3 = 0;
        while (n3 < n && Arrays.equals(this.values[n3], largeDoubleArrayValue.values[n3])) {
            ++n3;
        }
        return n3 == n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("LargeDoubleArrayValue(");
        int n = this.values.length;
        int n2 = 0;
        block0: while (true) {
            if (n2 >= n) {
                stringBuilder.append(")");
                return stringBuilder.toString();
            }
            int n3 = this.values[n2].length;
            int n4 = 0;
            while (true) {
                block4: {
                    block5: {
                        block3: {
                            if (n4 >= n3) break block3;
                            if (n2 + n4 == 0) break block4;
                            break block5;
                        }
                        ++n2;
                        continue block0;
                    }
                    stringBuilder.append(", ");
                }
                stringBuilder.append(this.values[n2][n4]);
                ++n4;
            }
            break;
        }
    }

    @Override
    public void setParent(BlockValue blockValue) {
        assert (false) : "setParent(BlockValue) called on an instance of " + this.getClass();
    }

    @Override
    public BlockValue getParent() {
        assert (false) : "getParent() called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public CustomOperations getCustomOperations() {
        assert (false) : "getCustomOperations() called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public Object asCustom() {
        assert (false) : "asCustom() called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public void setCustom(Object object) {
        assert (false) : "setCustom(Object) called on an instance of " + this.getClass();
    }

    @Override
    public int asInt32() {
        assert (false) : "asInt32() called on an instance of " + this.getClass();
        return 0;
    }

    @Override
    public void setInt32(int n) {
        assert (false) : "setInt32(int) called on an instance of " + this.getClass();
    }

    @Override
    public long asInt64() {
        assert (false) : "asInt64() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public void setInt64(long l) {
        assert (false) : "setInt64(int) called on an instance of " + this.getClass();
    }

    @Override
    public long asNativeInt() {
        assert (false) : "asNativeInt() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public void setNativeInt(long l) {
        assert (false) : "setNativeInt(long) called on an instance of " + this.getClass();
    }

    @Override
    public int asCastedInt() {
        return -1;
    }

    @Override
    public int asBoundedInt() throws Fatal.Exception {
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public long getCode() {
        assert (this.getTag() == 247 || this.getTag() == 249) : "getCode() called on an instance of " + this.getClass();
        {
            return this.get0().asCodeOffset();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setCode(long l) {
        if ($assertionsDisabled || this.getTag() == 247 || this.getTag() == 249) {
            this.set0(Value.createCodeOffset(l));
            return;
        }
        throw new AssertionError((Object)("setCode(long) called on an instance of " + this.getClass()));
    }

    @Override
    public double asDouble() {
        assert (false) : "asDouble() called on an instance of " + this.getClass();
        return 0.0;
    }

    @Override
    public void setDouble(double d) {
        assert (false) : "setDouble(double) called on an instance of " + this.getClass();
    }

    @Override
    public Value getWeak(long l) throws ArrayIndexOutOfBoundsException {
        assert (false) : "getWeak(long) called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public void setWeak(long l, Value value) throws ArrayIndexOutOfBoundsException {
        assert (false) : "setWeak(long, Value) called on an instance of " + this.getClass();
    }

    @Override
    public long sizeWeakValues() {
        assert (false) : "sizeWeakValues() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public long sizeBytes() {
        assert (false) : "sizeBytes() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public long sizeBytesTagged() {
        assert (false) : "sizeBytesTagged() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public long sizeBytesMinusOneTagged() {
        assert (false) : "sizeBytesMinusOneTagged() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public Value sizeBytesWrapped() {
        assert (false) : "sizeBytesWrapped() called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public String asString() {
        assert (false) : "asString() called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public byte[] getBytes() {
        assert (false) : "getBytes() called on an instance of " + this.getClass();
        return new byte[0];
    }

    @Override
    public byte[] getBytesForModification() {
        assert (false) : "getBytesForModification() called on an instance of " + this.getClass();
        return new byte[0];
    }

    @Override
    public int[] getUnsignedBytes() {
        assert (false) : "getUnsignedBytes() called on an instance of " + this.getClass();
        return new int[0];
    }

    @Override
    public byte getByte(long l) throws ArrayIndexOutOfBoundsException {
        assert (false) : "getByte(long) called on an instance of " + this.getClass();
        return 0;
    }

    @Override
    public void setByte(long l, byte by) throws ArrayIndexOutOfBoundsException {
        assert (false) : "setByte(long, byte) called on an instance of " + this.getClass();
    }

    @Override
    public int getUnsignedByte(long l) throws ArrayIndexOutOfBoundsException {
        assert (false) : "getUnsignedByte(long) called on an instance of " + this.getClass();
        return 0;
    }

    @Override
    public void setUnsignedByte(long l, int n) throws ArrayIndexOutOfBoundsException {
        assert (false) : "setUnsignedByte(long, int) called on an instance of " + this.getClass();
    }

    @Override
    public void set(Value value, long l) throws ArrayIndexOutOfBoundsException {
        if ($assertionsDisabled || value != null) {
            this.setDouble(l, value.asDouble());
            return;
        }
        throw new AssertionError((Object)"null x");
    }

    @Override
    public void set(int n, Value value) throws ArrayIndexOutOfBoundsException {
        if ($assertionsDisabled || value != null) {
            this.setDouble(n, value.asDouble());
            return;
        }
        throw new AssertionError((Object)"null x");
    }

    @Override
    public void set(long l, Value value) throws ArrayIndexOutOfBoundsException {
        if ($assertionsDisabled || value != null) {
            this.setDouble(l, value.asDouble());
            return;
        }
        throw new AssertionError((Object)"null x");
    }

    @Override
    public Value get(int n) throws ArrayIndexOutOfBoundsException {
        return Value.createDouble(this.getDouble(n));
    }

    @Override
    public Value get(long l) throws ArrayIndexOutOfBoundsException {
        return Value.createDouble(this.getDouble(l));
    }

    @Override
    public long sizeLongs() {
        return this.length;
    }

    @Override
    public void setRawLong(int n, long l) throws ArrayIndexOutOfBoundsException {
        this.setDouble(n, (double)l);
    }

    @Override
    public void setRawLong(long l, long l2) throws ArrayIndexOutOfBoundsException {
        this.setDouble(l, (double)l2);
    }

    @Override
    public long getRawLong(int n) throws ArrayIndexOutOfBoundsException {
        return (long)this.getDouble(n);
    }

    @Override
    public long getRawLong(long l) throws ArrayIndexOutOfBoundsException {
        return (long)this.getDouble(l);
    }

    @Override
    public void setGenericDouble(int n, double d) throws ArrayIndexOutOfBoundsException {
        this.setDouble(n, d);
    }

    @Override
    public void setGenericDouble(long l, double d) throws ArrayIndexOutOfBoundsException {
        this.setDouble(l, d);
    }

    @Override
    public double getGenericDouble(int n) throws ArrayIndexOutOfBoundsException {
        return this.getDouble(n);
    }

    @Override
    public double getGenericDouble(long l) throws ArrayIndexOutOfBoundsException {
        return this.getDouble(l);
    }

    @Override
    public void setRawLong0(long l) {
        this.setDouble(0, (double)l);
    }

    @Override
    public long getRawLong0() {
        return (long)this.getDouble(0);
    }

    @Override
    public void setGenericDouble0(double d) {
        this.setDouble(0, d);
    }

    @Override
    public double getGenericDouble0() {
        return this.getDouble(0);
    }

    @Override
    public void setDouble0(double d) {
        this.setDouble(0, d);
    }

    @Override
    public double getDouble0() {
        return this.getDouble(0);
    }

    @Override
    public void set0(Value value) {
        this.setDouble(0, value.asDouble());
    }

    @Override
    public Value get0() {
        return Value.createDouble(this.getDouble(0));
    }

    @Override
    public void setRawLong1(long l) {
        this.setDouble(1, (double)l);
    }

    @Override
    public long getRawLong1() {
        return (long)this.getDouble(1);
    }

    @Override
    public void setGenericDouble1(double d) {
        this.setDouble(1, d);
    }

    @Override
    public double getGenericDouble1() {
        return this.getDouble(1);
    }

    @Override
    public void setDouble1(double d) {
        this.setDouble(1, d);
    }

    @Override
    public double getDouble1() {
        return this.getDouble(1);
    }

    @Override
    public void set1(Value value) {
        this.setDouble(1, value.asDouble());
    }

    @Override
    public Value get1() {
        return Value.createDouble(this.getDouble(1));
    }

    @Override
    public void setRawLong2(long l) {
        this.setDouble(2, (double)l);
    }

    @Override
    public long getRawLong2() {
        return (long)this.getDouble(2);
    }

    @Override
    public void setGenericDouble2(double d) {
        this.setDouble(2, d);
    }

    @Override
    public double getGenericDouble2() {
        return this.getDouble(2);
    }

    @Override
    public void setDouble2(double d) {
        this.setDouble(2, d);
    }

    @Override
    public double getDouble2() {
        return this.getDouble(2);
    }

    @Override
    public void set2(Value value) {
        this.setDouble(2, value.asDouble());
    }

    @Override
    public Value get2() {
        return Value.createDouble(this.getDouble(2));
    }

    @Override
    public void setRawLong3(long l) {
        this.setDouble(3, (double)l);
    }

    @Override
    public long getRawLong3() {
        return (long)this.getDouble(3);
    }

    @Override
    public void setGenericDouble3(double d) {
        this.setDouble(3, d);
    }

    @Override
    public double getGenericDouble3() {
        return this.getDouble(3);
    }

    @Override
    public void setDouble3(double d) {
        this.setDouble(3, d);
    }

    @Override
    public double getDouble3() {
        return this.getDouble(3);
    }

    @Override
    public void set3(Value value) {
        this.setDouble(3, value.asDouble());
    }

    @Override
    public Value get3() {
        return Value.createDouble(this.getDouble(3));
    }

    @Override
    public void setRawLong4(long l) {
        this.setDouble(4, (double)l);
    }

    @Override
    public long getRawLong4() {
        return (long)this.getDouble(4);
    }

    @Override
    public void setGenericDouble4(double d) {
        this.setDouble(4, d);
    }

    @Override
    public double getGenericDouble4() {
        return this.getDouble(4);
    }

    @Override
    public void setDouble4(double d) {
        this.setDouble(4, d);
    }

    @Override
    public double getDouble4() {
        return this.getDouble(4);
    }

    @Override
    public void set4(Value value) {
        this.setDouble(4, value.asDouble());
    }

    @Override
    public Value get4() {
        return Value.createDouble(this.getDouble(4));
    }

    @Override
    public void setRawLong5(long l) {
        this.setDouble(5, (double)l);
    }

    @Override
    public long getRawLong5() {
        return (long)this.getDouble(5);
    }

    @Override
    public void setGenericDouble5(double d) {
        this.setDouble(5, d);
    }

    @Override
    public double getGenericDouble5() {
        return this.getDouble(5);
    }

    @Override
    public void setDouble5(double d) {
        this.setDouble(5, d);
    }

    @Override
    public double getDouble5() {
        return this.getDouble(5);
    }

    @Override
    public void set5(Value value) {
        this.setDouble(5, value.asDouble());
    }

    @Override
    public Value get5() {
        return Value.createDouble(this.getDouble(5));
    }

    @Override
    public void setRawLong6(long l) {
        this.setDouble(6, (double)l);
    }

    @Override
    public long getRawLong6() {
        return (long)this.getDouble(6);
    }

    @Override
    public void setGenericDouble6(double d) {
        this.setDouble(6, d);
    }

    @Override
    public double getGenericDouble6() {
        return this.getDouble(6);
    }

    @Override
    public void setDouble6(double d) {
        this.setDouble(6, d);
    }

    @Override
    public double getDouble6() {
        return this.getDouble(6);
    }

    @Override
    public void set6(Value value) {
        this.setDouble(6, value.asDouble());
    }

    @Override
    public Value get6() {
        return Value.createDouble(this.getDouble(6));
    }

    @Override
    public void setRawLong7(long l) {
        this.setDouble(7, (double)l);
    }

    @Override
    public long getRawLong7() {
        return (long)this.getDouble(7);
    }

    @Override
    public void setGenericDouble7(double d) {
        this.setDouble(7, d);
    }

    @Override
    public double getGenericDouble7() {
        return this.getDouble(7);
    }

    @Override
    public void setDouble7(double d) {
        this.setDouble(7, d);
    }

    @Override
    public double getDouble7() {
        return this.getDouble(7);
    }

    @Override
    public void set7(Value value) {
        this.setDouble(7, value.asDouble());
    }

    @Override
    public Value get7() {
        return Value.createDouble(this.getDouble(7));
    }
}

