/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.kernel;

import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.ocamljava.runtime.context.Context;
import org.ocamljava.runtime.context.ContextWithRuntimeLock;
import org.ocamljava.runtime.context.ContextWithoutRuntimeLock;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.kernel.AbstractCodeRunner;
import org.ocamljava.runtime.kernel.AtExit;
import org.ocamljava.runtime.kernel.CodeRunner;
import org.ocamljava.runtime.kernel.Debug;
import org.ocamljava.runtime.kernel.Executable;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.FalseExit;
import org.ocamljava.runtime.kernel.Fatal;
import org.ocamljava.runtime.kernel.MarshalIntern;
import org.ocamljava.runtime.kernel.OCamlJavaException;
import org.ocamljava.runtime.kernel.OCamlJavaThread;
import org.ocamljava.runtime.kernel.Signals;
import org.ocamljava.runtime.kernel.StandardError;
import org.ocamljava.runtime.parameters.NativeParameters;
import org.ocamljava.runtime.values.Value;

public abstract class AbstractNativeRunner
extends AbstractCodeRunner
implements Executable {
    protected Value result;
    protected Throwable exception;
    private final Map<Class<?>, Value> constants;
    private final Map<String, Value> globals;
    private int globalsInited;
    private Throwable backtraceInfo;

    public AbstractNativeRunner(NativeParameters nativeParameters) {
        super(nativeParameters.hasRuntimeLock() ? new ContextWithRuntimeLock(nativeParameters, true, new File(".")) : new ContextWithoutRuntimeLock(nativeParameters, true, new File(".")));
        OCamlJavaThread.registerCodeRunner(Thread.currentThread(), this);
        this.constants = new HashMap();
        this.globals = new HashMap<String, Value>();
        this.globalsInited = 0;
        this.result = null;
        this.exception = null;
        this.backtraceInfo = null;
    }

    public AbstractNativeRunner(AbstractNativeRunner abstractNativeRunner) {
        super(abstractNativeRunner.context);
        this.constants = abstractNativeRunner.constants;
        this.globals = abstractNativeRunner.globals;
        this.globalsInited = abstractNativeRunner.globalsInited;
        this.result = null;
        this.exception = null;
        this.backtraceInfo = null;
    }

    public final Value getResult() {
        return this.result;
    }

    public static void checkSignals() throws Fail.Exception, Fatal.Exception, FalseExit, OCamlJavaException {
        Signals.processSignal(OCamlJavaThread.getCodeRunner());
    }

    public static Value getAtom(int n) {
        return CurrentContext.CODE_STATE.getAtom(n);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Value loadConstants(Class<?> clazz) throws OCamlJavaException {
        Context context = CurrentContext.CONTEXT;
        try {
            InputStream inputStream = clazz.getResourceAsStream(clazz.getSimpleName() + ".consts");
            if (inputStream == null) {
                throw new OCamlJavaException("unable to load constants for " + clazz);
            }
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            Value value = MarshalIntern.inputVal(context, dataInputStream, true);
            dataInputStream.close();
            inputStream.close();
            return value;
        }
        catch (IOException | Fail.Exception | Fatal.Exception exception) {
            throw new OCamlJavaException("unable to load constants for " + clazz, exception);
        }
    }

    public final void loadConstant(Class<?> clazz) throws OCamlJavaException {
        Value value = AbstractNativeRunner.loadConstants(clazz);
        this.constants.put(clazz, value);
    }

    public final void setConstant(Class<?> clazz, Value value) {
        this.constants.put(clazz, value);
    }

    public static Value getConstant(Class<?> clazz, long l) {
        if ($assertionsDisabled || clazz != null) {
            CodeRunner codeRunner = OCamlJavaThread.getCodeRunner();
            return ((AbstractNativeRunner)codeRunner).constants.get(clazz).get(l);
        }
        throw new AssertionError((Object)"null id");
    }

    public static Value getConstants(Class<?> clazz) {
        if ($assertionsDisabled || clazz != null) {
            CodeRunner codeRunner = OCamlJavaThread.getCodeRunner();
            return ((AbstractNativeRunner)codeRunner).constants.get(clazz);
        }
        throw new AssertionError((Object)"null id");
    }

    public static Value createGlobal(String string, long l) {
        if ($assertionsDisabled || string != null) {
            if ($assertionsDisabled || l >= 0L) {
                CodeRunner codeRunner = OCamlJavaThread.getCodeRunner();
                Value value = Value.createBlock(0, l);
                ((AbstractNativeRunner)codeRunner).globals.put(string, value);
                return value;
            }
            throw new AssertionError((Object)"sz should be >= 0");
        }
        throw new AssertionError((Object)"null id");
    }

    public final void registerPredefinedException(String string) {
        if ($assertionsDisabled || string != null) {
            String string2 = "caml_bucket_" + string;
            String string3 = "caml_exn_" + string;
            Value value = Value.createBlock(0, Value.createString(string));
            CodeRunner codeRunner = OCamlJavaThread.getCodeRunner();
            this.globals.put(string3, value);
            this.globals.put(string2, Value.createBlock(0, value));
            return;
        }
        throw new AssertionError((Object)"null name");
    }

    public static Value getGlobal(String string) {
        if ($assertionsDisabled || string != null) {
            CodeRunner codeRunner = OCamlJavaThread.getCodeRunner();
            return ((AbstractNativeRunner)codeRunner).globals.get(string);
        }
        throw new AssertionError((Object)"null id");
    }

    final Value getGlobalFromInstance(String string) {
        assert (string != null) : "null id";
        {
            return this.globals.get(string);
        }
    }

    public static void setGlobal(String string, Value value) {
        if ($assertionsDisabled || string != null) {
            CodeRunner codeRunner = OCamlJavaThread.getCodeRunner();
            ((AbstractNativeRunner)codeRunner).globals.put(string, value);
            return;
        }
        throw new AssertionError((Object)"null id");
    }

    public final int getGlobalsInited() {
        return this.globalsInited;
    }

    public final void incrGlobalsInited() {
        ++this.globalsInited;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final Value callback(Value value, Value ... valueArray) throws Fail.Exception, Fatal.Exception, FalseExit {
        AbstractNativeRunner abstractNativeRunner;
        block9: {
            assert (value != null) : "null closure";
            assert (valueArray != null) : "null params";
            assert (valueArray.length + 4 <= 256) : "params is too long";
            Thread thread = Thread.currentThread();
            boolean bl = thread instanceof OCamlJavaThread;
            boolean bl2 = OCamlJavaThread.isRegistered(thread);
            boolean bl3 = !bl && !bl2;
            if (bl3) {
                this.context.getThreadsState().addAdditionalThread(thread);
            }
            abstractNativeRunner = this.copy();
            abstractNativeRunner.threadStatus = null;
            abstractNativeRunner.setup(value, valueArray);
            abstractNativeRunner.exception = null;
            try {
                abstractNativeRunner.run();
                if (bl3) break block9;
            }
            catch (Throwable throwable) {
                if (bl3) throw throwable;
                this.context.getThreadsState().removeAdditionalThread(thread);
                throw throwable;
            }
            this.context.getThreadsState().removeAdditionalThread(thread);
        }
        if (abstractNativeRunner.exception == null) return abstractNativeRunner.result;
        if (abstractNativeRunner.exception instanceof Fail.Exception) {
            throw (Fail.Exception)abstractNativeRunner.exception;
        }
        if (abstractNativeRunner.exception instanceof Fatal.Exception) {
            throw (Fatal.Exception)abstractNativeRunner.exception;
        }
        if (abstractNativeRunner.exception instanceof FalseExit) {
            AtExit.execute(null);
            throw (FalseExit)abstractNativeRunner.exception;
        }
        Fatal.raise("error in callback: " + abstractNativeRunner.exception);
        return abstractNativeRunner.result;
    }

    /*
     * Exception decompiling
     */
    @Override
    public final void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [6 : 81->95)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void execute() {
        block4: {
            block5: {
                block3: {
                    OCamlJavaThread.registerCodeRunner(Thread.currentThread(), this);
                    this.context.getThreadsState().setMainCodeRunner(this);
                    this.setup(null, new Value[0]);
                    OCamlJavaThread oCamlJavaThread = new OCamlJavaThread(this.context.getThreadsState().getThreadGroup(), this);
                    this.context.getThreadsState().setMainThread(oCamlJavaThread);
                    oCamlJavaThread.start();
                    while (oCamlJavaThread.isAlive()) {
                        try {
                            oCamlJavaThread.join();
                        }
                        catch (InterruptedException interruptedException) {
                            return;
                        }
                    }
                    Signals.unregisterContext(this.context);
                    this.context.getSignalsState().clearSignals();
                    if (this.exception == null || this.exception instanceof FalseExit) break block3;
                    StandardError.reportNativeException(this, this.exception);
                    if (!Debug.ENABLED) break block4;
                    break block5;
                }
                AtExit.execute(null);
                return;
            }
            System.out.println("*** Debugging information:");
            this.exception.printStackTrace(System.out);
        }
        AtExit.execute(null);
    }

    @Override
    public final void executeSilently() {
        this.execute();
    }

    public final void executeWithBindings(Map<String, Value> map) {
        this.bindings = map;
        this.execute();
    }

    /*
     * Enabled aggressive block sorting
     */
    private StackTraceElement[] filterBackTrace(StackTraceElement[] stackTraceElementArray) {
        assert (stackTraceElementArray != null) : "null elems";
        boolean bl = ((NativeParameters)this.context.getParameters()).isSimplifiedBacktrace();
        ArrayList<StackTraceElement> arrayList = new ArrayList<StackTraceElement>(Arrays.asList(stackTraceElementArray));
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            boolean bl2;
            StackTraceElement stackTraceElement = (StackTraceElement)iterator.next();
            String string = stackTraceElement.getClassName();
            boolean bl3 = bl2 = string.startsWith("java.lang.") || string.startsWith("java.lang.reflect.") || string.startsWith("java.lang.invoke.") || string.startsWith("org.ocamljava.runtime.kernel.") || string.startsWith("org.ocamljava.runtime.values.");
            if ((!bl || !bl2) && stackTraceElement.getFileName() != null && stackTraceElement.getLineNumber() >= 0) continue;
            iterator.remove();
        }
        return arrayList.toArray(new StackTraceElement[arrayList.size()]);
    }

    @Override
    public final void printExceptionBacktrace(PrintStream printStream) {
        if ($assertionsDisabled || printStream != null) {
            for (StackTraceElement stackTraceElement : this.filterBackTrace(this.exception.getStackTrace())) {
                printStream.println("\tat " + stackTraceElement);
            }
            return;
        }
        throw new AssertionError((Object)"null out");
    }

    public final void setBacktraceInfo(Throwable throwable) {
        if (this.context.getCodeState().isBacktraceActive()) {
            this.backtraceInfo = throwable;
        }
    }

    @Override
    public final void clearBacktraceInfo() {
        this.backtraceInfo = null;
    }

    public final void clearException() {
        this.exception = null;
    }

    @Override
    public final Value getExceptionBacktrace() {
        if (this.backtraceInfo == null) {
            return Value.createBlock(0, Value.createBlock(0));
        }
        StackTraceElement[] stackTraceElementArray = this.filterBackTrace(this.backtraceInfo.getStackTrace());
        int n = stackTraceElementArray.length;
        Value value = Value.createBlock(0, n);
        int n2 = 0;
        while (true) {
            Value value2;
            StackTraceElement stackTraceElement;
            block5: {
                block3: {
                    block4: {
                        block2: {
                            if (n2 >= n) break block2;
                            stackTraceElement = stackTraceElementArray[n2];
                            if (n2 != 0) break block3;
                            break block4;
                        }
                        return Value.createBlock(0, value);
                    }
                    value2 = Value.TRUE;
                    break block5;
                }
                value2 = Value.FALSE;
            }
            Value value3 = Value.createBlock(0, value2, Value.createString(stackTraceElement.getFileName()), Value.createLong(stackTraceElement.getLineNumber()), Value.ZERO, Value.ZERO);
            value.set(n2, value3);
            ++n2;
        }
    }

    @Override
    public final CodeRunner createNewThread(Value value) {
        AbstractNativeRunner abstractNativeRunner = this.copy();
        if (value != null) {
            abstractNativeRunner.setThreadStatus(value);
        }
        return abstractNativeRunner;
    }

    protected abstract AbstractNativeRunner copy();

    protected abstract void moduleMain();
}

