/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank.canvas3D;

import com.onemoonscientific.swank.BindCmd;
import com.onemoonscientific.swank.SwkWidget;
import com.onemoonscientific.swank.Widgets;
import com.onemoonscientific.swank.canvas3D.SwkCanvas;
import com.onemoonscientific.swank.canvas3D.SwkCanvasWidgetCmd;
import java.awt.EventQueue;
import javax.swing.SwingUtilities;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.ReflectObject;
import tcl.lang.TclException;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;

public class SwkCanvasCmd
implements Command {
    public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
        if (argv.length > 2 && "help".equals(argv[1].toString())) {
            if ("options".startsWith(argv[2].toString())) {
                SwkCanvas.getWidgetOptions(interp);
            } else if ("commands".startsWith(argv[2].toString())) {
                SwkCanvas.getWidgetCmds(interp);
            }
        } else if (!EventQueue.isDispatchThread()) {
            this.cmdProcNotET(interp, argv);
        } else {
            throw new TclException(interp, "Can't create widgets on event queue");
        }
    }

    public void cmdProcNotET(Interp interp, TclObject[] argv) throws TclException {
        if (argv.length < 2) {
            throw new TclNumArgsException(interp, 1, argv, "pathName ?options?");
        }
        if (!argv[1].toString().startsWith(".")) {
            throw new TclException(interp, "bad window path name \"" + argv[1].toString() + "\"");
        }
        String cmdName = argv[0].toString();
        String className = argv[0].toString().substring(0, 1).toUpperCase() + argv[0].toString().substring(1);
        String widgetName = argv[1].toString();
        CmdProc cmdProc = new CmdProc(interp, className, widgetName);
        try {
            SwingUtilities.invokeAndWait(cmdProc);
        }
        catch (InterruptedException iE) {
            throw new TclException(interp, iE.toString());
        }
        catch (Exception e) {
            throw new TclException(interp, e.toString());
        }
        SwkCanvas swkcanvas = cmdProc.getwidget();
        if (Widgets.exists((Interp)interp, (String)argv[1].toString())) {
            swkcanvas = (SwkCanvas)Widgets.get((Interp)interp, (String)argv[1].toString());
            if (swkcanvas.isCreated()) {
                throw new TclException(interp, "window name \"" + argv[1].toString() + "\" already exists in parent");
            }
            swkcanvas.className = className.intern();
        } else {
            if (argv[1].toString().length() > 1 && Character.isUpperCase(argv[1].toString().charAt(1))) {
                throw new TclException(interp, "window name starts with an upper-case letter: \"" + argv[1].toString().charAt(1) + "\"");
            }
            swkcanvas.className = className.intern();
            Object children = null;
            interp.createCommand(argv[1].toString(), (Command)new SwkCanvasWidgetCmd());
            TclObject tObj = ReflectObject.newInstance((Interp)interp, SwkCanvas.class, (Object)swkcanvas);
            tObj.preserve();
            swkcanvas.configure(interp, argv, 2);
            Widgets.addNewWidget((Interp)interp, (String)argv[1].toString(), (TclObject)tObj);
        }
        swkcanvas.setCreated(true);
        BindCmd.addDefaultListeners((Interp)interp, (SwkWidget)swkcanvas);
        interp.setResult(argv[1].toString());
    }

    class CmdProc
    implements Runnable {
        Interp interp;
        TclObject[] argv = null;
        String className = "";
        String widgetName = "";
        SwkCanvas swkcanvas = null;

        CmdProc(Interp interp, String className, String widgetName) {
            this.interp = interp;
            this.className = className;
            this.widgetName = widgetName;
        }

        public SwkCanvas getwidget() {
            return this.swkcanvas;
        }

        public void run() {
            this.swkcanvas = new SwkCanvas(this.interp, this.widgetName, this.className);
        }
    }
}

