/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank.canvas3D;

import com.onemoonscientific.swank.SwkException;
import com.onemoonscientific.swank.canvas3D.CanvasParameter;
import com.onemoonscientific.swank.canvas3D.RadiusInterface;
import com.onemoonscientific.swank.canvas3D.RadiusParameter;
import com.onemoonscientific.swank.canvas3D.SwkImageCanvas;
import com.onemoonscientific.swank.canvas3D.SwkShape;
import com.sun.j3d.utils.geometry.Sphere;
import java.util.Map;
import java.util.TreeMap;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import tcl.lang.Interp;
import tcl.lang.TclDouble;
import tcl.lang.TclException;
import tcl.lang.TclInteger;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclString;

public class SwkSphere
extends SwkShape
implements RadiusInterface {
    int nDivisions = 15;
    float radius = 1.0f;
    Point3d a = new Point3d();
    static CanvasParameter[] parameters = new CanvasParameter[]{new RadiusParameter()};
    static Map parameterMap = new TreeMap();

    SwkSphere(SwkImageCanvas canvas) {
        super(canvas);
    }

    public CanvasParameter[] getParameters() {
        return parameters;
    }

    public Map getParameterMap() {
        return parameterMap;
    }

    public void coords(SwkImageCanvas canvas, double[] coords) throws SwkException {
        this.a.x = coords[0];
        this.a.y = coords[1];
        this.a.z = coords[2];
        this.genShape();
    }

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double radius) {
        this.radius = (float)radius;
    }

    void makeObjectNode() {
        this.objectNode = new Sphere(this.radius, 1, this.nDivisions, this.appearance);
    }

    TransformGroup makeTransform() {
        Transform3D t3D = new Transform3D();
        t3D.setTranslation(new Vector3d(this.a.x, this.a.y, this.a.z));
        TransformGroup tG = new TransformGroup(t3D);
        return tG;
    }

    public void config(Interp interp, TclObject[] argv, int start) throws TclException {
        if ((argv.length - start) % 2 != 0) {
            throw new TclNumArgsException(interp, 0, argv, "-option value ? -option value? ...");
        }
        boolean doGen = false;
        for (int i = start; i < argv.length; i += 2) {
            if ("-radius".startsWith(argv[i].toString())) {
                this.radius = (float)TclDouble.get((Interp)interp, (TclObject)argv[i + 1]);
                doGen = true;
            } else if ("-ndivisions".startsWith(argv[i].toString())) {
                this.nDivisions = TclInteger.get((Interp)interp, (TclObject)argv[i + 1]);
                doGen = true;
            } else if (argv[i].toString().startsWith("-tag")) {
                // empty if block
            }
            if (!doGen) continue;
            this.makeObjectNode();
        }
    }

    public TclObject itemGet(Interp interp, TclObject argv) throws TclException {
        return TclString.newInstance((String)"");
    }

    static {
        SwkSphere.initializeParameters(parameters, parameterMap);
    }
}

