/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.graph;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.util.Formatter;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JFrame;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.FalseExit;
import org.ocamljava.runtime.parameters.CommonParameters;
import org.ocamljava.runtime.primitives.otherlibs.graph.Events;
import org.ocamljava.runtime.util.EncodingUtils;
import org.ocamljava.runtime.util.IntegerUtils;
import org.ocamljava.runtime.values.Value;

public final class GraphSlot {
    public static final Object SLOT = new Object();
    static final Object SLOT_TITLE = new Object();
    static final String DEFAULT_TITLE = "OCaml graphics";
    private static final int DEFAULT_WIDTH = 640;
    private static final int DEFAULT_HEIGHT = 480;
    private static final String DEFAULT_FONT_NAME = "Dialog";
    private static final int DEFAULT_FONT_STYLE = 0;
    private static final int DEFAULT_FONT_SIZE = 12;
    private static final int EVENT_QUEUE_SIZE = 256;
    private final GraphCanvas canvas;
    private final Frame frame;
    private boolean displayMode;
    private boolean rememberMode;
    private Font font;
    private final Color background;
    private Color color;
    private BufferedImage buffer;
    private BufferedImage backingStore;
    private int x;
    private int y;
    private int lineWidth;
    private boolean mouseButton;
    private final List<Event> eventQueue;

    public GraphSlot(CommonParameters commonParameters, String string, String string2) throws HeadlessException {
        if ($assertionsDisabled || commonParameters != null) {
            if ($assertionsDisabled || string != null) {
                if ($assertionsDisabled || string2 != null) {
                    int n;
                    int n2;
                    Object object;
                    this.displayMode = true;
                    this.rememberMode = true;
                    this.font = new Font(DEFAULT_FONT_NAME, 0, 12);
                    this.background = Color.WHITE;
                    this.color = Color.BLACK;
                    this.x = 0;
                    this.y = 0;
                    this.lineWidth = 1;
                    this.mouseButton = false;
                    this.eventQueue = new LinkedList<Event>();
                    if (string2.matches("[0-9]+x[0-9]+")) {
                        object = string2.split("x");
                        n2 = Integer.parseInt(object[0]);
                        n = Integer.parseInt(object[1]);
                    } else {
                        n2 = 640;
                        n = 480;
                    }
                    this.buffer = new BufferedImage(n2, n, 2);
                    object = this.buffer.createGraphics();
                    ((Graphics)object).setColor(Color.WHITE);
                    ((Graphics)object).fillRect(0, 0, n2, n);
                    ((Graphics)object).dispose();
                    this.backingStore = new BufferedImage(n2, n, 2);
                    Graphics2D graphics2D = this.backingStore.createGraphics();
                    graphics2D.setColor(Color.WHITE);
                    graphics2D.fillRect(0, 0, n2, n);
                    graphics2D.dispose();
                    this.canvas = new GraphCanvas(n2, n);
                    this.canvas.addMouseListener(new MouseAdapter(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void mousePressed(MouseEvent mouseEvent) {
                            GraphSlot graphSlot = GraphSlot.this;
                            synchronized (graphSlot) {
                                mouseEvent.consume();
                                GraphSlot.this.mouseButton = true;
                                GraphSlot.this.addEvent(new Event(0, mouseEvent.getX(), mouseEvent.getY(), true, null));
                                return;
                            }
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void mouseReleased(MouseEvent mouseEvent) {
                            GraphSlot graphSlot = GraphSlot.this;
                            synchronized (graphSlot) {
                                mouseEvent.consume();
                                GraphSlot.this.mouseButton = false;
                                GraphSlot.this.addEvent(new Event(1, mouseEvent.getX(), mouseEvent.getY(), false, null));
                                return;
                            }
                        }
                    });
                    this.canvas.addMouseMotionListener(new MouseMotionAdapter(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         * Enabled aggressive block sorting
                         * Enabled unnecessary exception pruning
                         * Enabled aggressive exception aggregation
                         */
                        @Override
                        public void mouseMoved(MouseEvent mouseEvent) {
                            GraphSlot graphSlot = GraphSlot.this;
                            synchronized (graphSlot) {
                                mouseEvent.consume();
                                GraphSlot.this.addEvent(new Event(3, mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getButton() != 0, null));
                                return;
                            }
                        }
                    });
                    this.canvas.addKeyListener(new KeyAdapter(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void keyPressed(KeyEvent keyEvent) {
                            GraphSlot graphSlot = GraphSlot.this;
                            synchronized (graphSlot) {
                                keyEvent.consume();
                                GraphSlot.this.addEvent(new Event(2, 0, 0, false, IntegerUtils.signedToUnsignedByte(EncodingUtils.convertCharToByte(keyEvent.getKeyChar()))));
                                return;
                            }
                        }
                    });
                    if (commonParameters.isBareCanvas()) {
                        this.frame = null;
                    } else {
                        if (commonParameters.isFrameAWT()) {
                            this.frame = new Frame(string);
                        } else {
                            JFrame jFrame = new JFrame(string);
                            jFrame.setDefaultCloseOperation(3);
                            this.frame = jFrame;
                        }
                        this.frame.setLayout(new BorderLayout());
                        this.frame.add((Component)this.canvas, "Center");
                        this.frame.pack();
                        this.frame.setVisible(true);
                        this.canvas.requestFocus();
                    }
                    return;
                }
                throw new AssertionError((Object)"null geom");
            }
            throw new AssertionError((Object)"null id");
        }
        throw new AssertionError((Object)"null params");
    }

    static void fail(String string, String string2) throws Fail.Exception {
        if ($assertionsDisabled || string != null) {
            Value value = CurrentContext.CODE_STATE.getCallback("Graphics.Graphic_failure");
            if (value == null) {
                Fail.invalidArgument("Exception Graphics.graphic_failure not initialized, must link graphics.cma");
            } else {
                StringBuilder stringBuilder = new StringBuilder();
                Formatter formatter = new Formatter(stringBuilder);
                formatter.format(string, string2);
                Fail.raiseWithString(value, stringBuilder.toString());
            }
            return;
        }
        throw new AssertionError((Object)"null fmt");
    }

    static GraphSlot checkGraph() throws Fail.Exception {
        GraphSlot graphSlot = (GraphSlot)CurrentContext.CODE_STATE.getSlot(SLOT);
        if (graphSlot != null) {
            return graphSlot;
        }
        GraphSlot.fail("Graphic screen not opened", "");
        return null;
    }

    public Frame getFrame() {
        return this.frame;
    }

    public Canvas getCanvas() {
        return this.canvas;
    }

    void setDisplayMode(boolean bl) {
        this.displayMode = bl;
    }

    void setRememberMode(boolean bl) {
        this.rememberMode = bl;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        if ($assertionsDisabled || font != null) {
            this.font = font;
            return;
        }
        throw new AssertionError((Object)"null f");
    }

    public Color getBackground() {
        return this.background;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        if ($assertionsDisabled || color != null) {
            this.color = color;
            return;
        }
        throw new AssertionError((Object)"null c");
    }

    public BufferedImage getBuffer() {
        return this.buffer;
    }

    public BufferedImage getBackingStore() {
        return this.backingStore;
    }

    Graphics2D createWindowGraphics() {
        if (this.displayMode) {
            Graphics2D graphics2D = this.buffer.createGraphics();
            graphics2D.setFont(this.font);
            graphics2D.setColor(this.color);
            graphics2D.setStroke(new BasicStroke(this.lineWidth));
            return graphics2D;
        }
        return null;
    }

    Graphics2D createBackingStoreGraphics() {
        if (this.rememberMode) {
            Graphics2D graphics2D = this.backingStore.createGraphics();
            graphics2D.setFont(this.font);
            graphics2D.setColor(this.color);
            graphics2D.setStroke(new BasicStroke(this.lineWidth));
            return graphics2D;
        }
        return null;
    }

    public int getX() {
        return this.x;
    }

    public void setX(int n) {
        this.x = n;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int n) {
        this.y = n;
    }

    public int getWidth() {
        return this.canvas.width;
    }

    public int getHeight() {
        return this.canvas.height;
    }

    int convertY(int n) {
        return this.buffer.getHeight() - 1 - n;
    }

    public int getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(int n) {
        this.lineWidth = Math.max(1, n);
    }

    synchronized boolean isMouseButton() {
        return this.mouseButton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addEvent(Event event) {
        List<Event> list = this.eventQueue;
        synchronized (list) {
            this.eventQueue.add(event);
            while (true) {
                if (this.eventQueue.size() <= 256) {
                    this.eventQueue.notifyAll();
                    return;
                }
                this.eventQueue.remove(0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    Value waitEvent(boolean bl, boolean bl2, boolean bl3, boolean bl4) throws FalseExit, Fail.Exception {
        Event event;
        block5: while (true) {
            int n;
            List<Event> list = this.eventQueue;
            // MONITORENTER : list
            Iterator<Event> iterator = this.eventQueue.iterator();
            do {
                if (iterator.hasNext()) {
                    event = iterator.next();
                    iterator.remove();
                    n = event.getKind();
                    if (n == 0 && bl) break block5;
                    continue;
                }
                try {
                    this.eventQueue.wait();
                    // MONITOREXIT : list
                    continue block5;
                }
                catch (InterruptedException interruptedException) {
                    FalseExit falseExit = FalseExit.createFromContext(CurrentContext.CONTEXT);
                    falseExit.fillInStackTrace();
                    throw falseExit;
                }
            } while (!(n == 1 && bl2 || n == 2 && bl3) && (n != 3 || !bl4));
            break;
        }
        // MONITOREXIT : list
        return Events.allocateResult(this, event.getMouseX(), event.getMouseY(), event.isButton(), event.getKey());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Integer getKey() {
        List<Event> list = this.eventQueue;
        synchronized (list) {
            Event event;
            Iterator<Event> iterator = this.eventQueue.iterator();
            do {
                if (iterator.hasNext()) continue;
                return null;
            } while ((event = iterator.next()).getKind() != 2);
            return event.getKey();
        }
    }

    void changeSize(int n, int n2) {
        if (this.frame != null) {
            this.canvas.changeSize(n, n2);
            this.frame.pack();
        }
    }

    void repaint() {
        this.canvas.repaint();
        Toolkit.getDefaultToolkit().sync();
    }

    private final class GraphCanvas
    extends Canvas {
        static final long serialVersionUID = -2093019317115730463L;
        private int width;
        private int height;

        private GraphCanvas(int n, int n2) {
            this.width = n;
            this.height = n2;
        }

        private void changeSize(int n, int n2) {
            this.width = n;
            this.height = n2;
            this.setSize(n, n2);
        }

        @Override
        public Dimension getSize(Dimension dimension) {
            dimension.width = this.width;
            dimension.height = this.height;
            return new Dimension(this.width, this.height);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(this.width, this.height);
        }

        @Override
        public Dimension getMinimumSize() {
            return new Dimension(this.width, this.height);
        }

        @Override
        public Dimension getMaximumSize() {
            return new Dimension(this.width, this.height);
        }

        @Override
        public synchronized void paint(Graphics graphics) {
            Dimension dimension = this.getSize();
            int n = dimension.width;
            int n2 = dimension.height;
            if (GraphSlot.this.buffer.getWidth() != n || GraphSlot.this.buffer.getHeight() != n2) {
                int n3 = n2 - GraphSlot.this.buffer.getHeight();
                BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
                Graphics2D graphics2D = bufferedImage.createGraphics();
                graphics2D.setColor(GraphSlot.this.background);
                graphics2D.fillRect(0, 0, n, n2);
                graphics2D.drawImage((Image)GraphSlot.this.buffer, 0, n3, null);
                graphics2D.dispose();
                GraphSlot.this.buffer = bufferedImage;
                BufferedImage bufferedImage2 = new BufferedImage(n, n2, 2);
                Graphics2D graphics2D2 = bufferedImage2.createGraphics();
                graphics2D2.setColor(GraphSlot.this.background);
                graphics2D2.fillRect(0, 0, n, n2);
                graphics2D2.drawImage((Image)GraphSlot.this.backingStore, 0, n3, null);
                graphics2D2.dispose();
                GraphSlot.this.backingStore = bufferedImage2;
            }
            super.paint(graphics);
            graphics.drawImage(GraphSlot.this.buffer, 0, 0, null);
        }
    }

    private static final class Event {
        private final int kind;
        private final int mouseX;
        private final int mouseY;
        private final boolean button;
        private final Integer key;

        private Event(int n, int n2, int n3, boolean bl, Integer n4) {
            this.kind = n;
            this.mouseX = n2;
            this.mouseY = n3;
            this.button = bl;
            this.key = n4;
        }

        private int getKind() {
            return this.kind;
        }

        private int getMouseX() {
            return this.mouseX;
        }

        private int getMouseY() {
            return this.mouseY;
        }

        private boolean isButton() {
            return this.button;
        }

        private Integer getKey() {
            return this.key;
        }
    }
}

