/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.kernel;

import org.ocamljava.runtime.values.Value;

public final class NativeComparisons {
    private NativeComparisons() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean equalValues(Value value, Value value2) {
        assert (value != null) : "null v1";
        assert (value2 != null) : "null v2";
        if (!value.isBlock()) {
            if (value.getRawValue() != value2.getRawValue()) return false;
            return true;
        }
        if (!value2.isBlock()) return false;
        if (value != value2) return false;
        return true;
    }

    public static boolean notEqualValues(Value value, Value value2) {
        if ($assertionsDisabled || value != null) {
            assert (value2 != null) : "null v2";
            {
                return !NativeComparisons.equalValues(value, value2);
            }
        }
        throw new AssertionError((Object)"null v1");
    }

    public static boolean lowerThanValue(Value value, Value value2) {
        if ($assertionsDisabled || value != null) {
            assert (value2 != null) : "null v2";
            {
                return Value.compare(value, value2) < 0;
            }
        }
        throw new AssertionError((Object)"null v1");
    }

    public static boolean lowerEqualValue(Value value, Value value2) {
        if ($assertionsDisabled || value != null) {
            assert (value2 != null) : "null v2";
            {
                return Value.compare(value, value2) <= 0;
            }
        }
        throw new AssertionError((Object)"null v1");
    }

    public static boolean greaterThanValue(Value value, Value value2) {
        if ($assertionsDisabled || value != null) {
            assert (value2 != null) : "null v2";
            {
                return Value.compare(value, value2) > 0;
            }
        }
        throw new AssertionError((Object)"null v1");
    }

    public static boolean greaterEqualValue(Value value, Value value2) {
        if ($assertionsDisabled || value != null) {
            assert (value2 != null) : "null v2";
            {
                return Value.compare(value, value2) >= 0;
            }
        }
        throw new AssertionError((Object)"null v1");
    }

    public static boolean isOutValue(Value value, Value value2) {
        if ($assertionsDisabled || value != null) {
            assert (value2 != null) : "null v2";
            {
                return Value.compareUnsigned(value, value2) < 0;
            }
        }
        throw new AssertionError((Object)"null v1");
    }
}

