/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import org.ocamljava.runtime.util.MemoryInputStream;

public final class RandomAccessInputStream {
    private static final String FILE_MODE_READ = "r";
    private static final int BUFFER_SIZE = 65536;
    private final byte[] bytes;
    private final RandomAccessFile file;

    public RandomAccessInputStream(File file) throws FileNotFoundException {
        if ($assertionsDisabled || file != null) {
            this.file = new RandomAccessFile(file, FILE_MODE_READ);
            this.bytes = null;
            return;
        }
        throw new AssertionError((Object)"null f");
    }

    public RandomAccessInputStream(String string) throws FileNotFoundException {
        this(new File(string));
    }

    /*
     * Enabled aggressive block sorting
     */
    public RandomAccessInputStream(InputStream inputStream, int n) throws IOException {
        assert (inputStream != null) : "null in";
        assert (n >= 0) : "maxSize should be >= 0";
        if (n == 0) {
            this.bytes = new byte[0];
        } else {
            byte[] byArray = new byte[65536];
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            int n2 = inputStream.read(byArray);
            for (int i = 0; n2 != -1 && i < n; i += n2) {
                byteArrayOutputStream.write(byArray, 0, n2);
                n2 = inputStream.read(byArray);
            }
            this.bytes = byteArrayOutputStream.toByteArray();
        }
        this.file = null;
    }

    public RandomAccessInputStream(InputStream inputStream) throws IOException {
        this(inputStream, Integer.MAX_VALUE);
    }

    public DataInput dataInputFrom(long l) throws IOException {
        if ($assertionsDisabled || l >= 0L) {
            if (this.file != null) {
                this.file.seek(l);
                return this.file;
            }
            if ($assertionsDisabled || l <= Integer.MAX_VALUE) {
                int n = (int)l;
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.bytes, n, this.bytes.length - n);
                return new DataInputStream(byteArrayInputStream);
            }
            throw new AssertionError((Object)"ofs should be <= Integer.MAX_VALUE when in 'stream' mode");
        }
        throw new AssertionError((Object)"ofs should be >= 0");
    }

    public byte[] readBytes(long l, int n) throws IOException {
        block4: {
            block5: {
                block8: {
                    byte[] byArray;
                    block7: {
                        block6: {
                            if (!$assertionsDisabled && l < 0L) break block4;
                            if (!$assertionsDisabled && n < 0) break block5;
                            byArray = new byte[n];
                            if (this.file == null) break block6;
                            this.file.seek(l);
                            this.file.readFully(byArray);
                            break block7;
                        }
                        if (!$assertionsDisabled && l > Integer.MAX_VALUE) break block8;
                        try {
                            System.arraycopy(this.bytes, (int)l, byArray, 0, n);
                        }
                        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                            throw new IOException(indexOutOfBoundsException.toString());
                        }
                    }
                    return byArray;
                }
                throw new AssertionError((Object)"ofs should be <= Integer.MAX_VALUE when in 'stream' mode");
            }
            throw new AssertionError((Object)"len should be >= 0");
        }
        throw new AssertionError((Object)"ofs should be >= 0");
    }

    public void close() throws IOException {
        if (this.file != null) {
            this.file.close();
        }
    }

    public long length() throws IOException {
        if (this.file != null) {
            return this.file.length();
        }
        return this.bytes.length;
    }

    public MemoryInputStream createInputStream() {
        if (this.bytes != null) {
            return new MemoryInputStream(this.bytes);
        }
        return null;
    }
}

