/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.annotations.primitives;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.ocamljava.runtime.annotations.parameters.Parameters;
import org.ocamljava.runtime.annotations.primitives.AbstractPrimitivesConverter;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.context.ContextWithoutRuntimeLock;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.MarshalExtern;
import org.ocamljava.runtime.values.Value;

public final class Primitives2Marshalled
extends AbstractPrimitivesConverter {
    private final FileOutputStream out;
    private final List<Value> values;

    private Primitives2Marshalled(String string, String string2) throws IOException {
        super(string, null);
        if ($assertionsDisabled || string2 != null) {
            this.out = new FileOutputStream(string2);
            this.values = new ArrayList<Value>();
            return;
        }
        throw new AssertionError((Object)"null f");
    }

    @Override
    protected void beforeWalk() {
        this.values.clear();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void visitClass(String string) {
        int n;
        int n2;
        Method[] methodArray;
        ArrayList<String> arrayList;
        try {
            Class<?> clazz = Class.forName(string);
            PrimitiveProvider primitiveProvider = clazz.getAnnotation(PrimitiveProvider.class);
            if (primitiveProvider == null) return;
            arrayList = new ArrayList<String>();
            methodArray = clazz.getDeclaredMethods();
            n2 = methodArray.length;
            n = 0;
        }
        catch (Throwable throwable) {
            return;
        }
        while (true) {
            if (n < n2) {
                Method method = methodArray[n];
                Primitive primitive = method.getAnnotation(Primitive.class);
                if (primitive != null) {
                    arrayList.add(method.getName());
                }
            } else {
                int n3 = arrayList.size();
                Value value = Value.createBlock(0, n3);
                n = 0;
                while (true) {
                    if (n >= n3) {
                        this.values.add(Value.createBlock(0, Value.createString(string), value));
                        return;
                    }
                    value.set(n, Value.createString((String)arrayList.get(n)));
                    ++n;
                }
            }
            ++n;
        }
    }

    @Override
    protected void afterWalk() {
    }

    private void write() throws IOException {
        int n = this.values.size();
        Value value = Value.createBlock(0, n);
        for (int i = 0; i < n; ++i) {
            value.set(i, this.values.get(i));
        }
        try {
            ContextWithoutRuntimeLock contextWithoutRuntimeLock = new ContextWithoutRuntimeLock(Parameters.defaultByteCodeParameters(), false, new File("."));
            this.out.write(MarshalExtern.externValue(contextWithoutRuntimeLock, value, Value.EMPTY_LIST));
            return;
        }
        catch (Fail.Exception exception) {
            throw new IOException("error in marshalling");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] stringArray) {
        PrintStream printStream = System.err;
        if (stringArray.length != 2) {
            printStream.println("error: a path, and a file should be provided");
            System.exit(1);
            return;
        }
        try {
            Primitives2Marshalled primitives2Marshalled = new Primitives2Marshalled(stringArray[0], stringArray[1]);
            primitives2Marshalled.walkFileTree();
            primitives2Marshalled.write();
        }
        catch (IOException iOException) {
            printStream.printf("i/o error: %s\n", iOException.getMessage());
            System.exit(1);
        }
        System.exit(0);
    }
}

