/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.util;

import org.ocamljava.runtime.kernel.Fatal;

public final class IntegerUtils {
    private static final int BYTE_CARDINAL = 256;
    private static final int SHORT_CARDINAL = 65536;
    private static final long INTEGER_CARDINAL = 0x100000000L;

    private IntegerUtils() {
    }

    public static long signedToUnsigned(int n) {
        return (long)n & 0xFFFFFFFFL;
    }

    public static int unsignedToSigned(long l) {
        block3: {
            block2: {
                if ($assertionsDisabled) break block2;
                if (l < 0L) break block3;
                if (l >= 0x100000000L) break block3;
            }
            return (int)l;
        }
        throw new AssertionError((Object)"x should be in 0..INTEGER_CARDINAL-1");
    }

    public static int signedToUnsignedByte(int n) {
        block3: {
            block2: {
                if ($assertionsDisabled) break block2;
                if (n < -128) break block3;
                if (n > 127) break block3;
            }
            return n & 0xFF;
        }
        throw new AssertionError((Object)"x should be in Byte.MIN_VALUE..Byte.MAX_VALUE");
    }

    public static int unsignedToSignedByte(int n) {
        block3: {
            block2: {
                if ($assertionsDisabled) break block2;
                if (n < 0) break block3;
                if (n >= 256) break block3;
            }
            return (byte)n;
        }
        throw new AssertionError((Object)"x should be in 0..BYTE_CARDINAL-1");
    }

    public static int signedToUnsignedShort(int n) {
        block3: {
            block2: {
                if ($assertionsDisabled) break block2;
                if (n < Short.MIN_VALUE) break block3;
                if (n > Short.MAX_VALUE) break block3;
            }
            return n & 0xFFFF;
        }
        throw new AssertionError((Object)"x should be in Short.MIN_VALUE..Short.MAX_VALUE");
    }

    public static int unsignedToSignedShort(int n) {
        block3: {
            block2: {
                if ($assertionsDisabled) break block2;
                if (n < 0) break block3;
                if (n >= 65536) break block3;
            }
            return (short)n;
        }
        throw new AssertionError((Object)"x should be in 0..SHORT_CARDINAL-1");
    }

    public static int ensure32s(long l) throws Fatal.Exception {
        if (l < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
            Fatal.raise64bitElement();
            return 0;
        }
        return (int)l;
    }
}

