/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank;

import com.onemoonscientific.swank.ResourceObject;
import com.onemoonscientific.swank.SwankUtil;
import com.onemoonscientific.swank.SwkSMenu;
import com.onemoonscientific.swank.UpdateOnEventThread;
import com.onemoonscientific.swank.Widgets;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.ReflectObject;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclInteger;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;

class SwkSMenuWidgetCmd
implements Command {
    private static final String[] validCmds = new String[]{"cget", "configure", "add", "delete"};
    private static final int OPT_CGET = 0;
    private static final int OPT_CONFIGURE = 1;
    private static final int OPT_ADD = 2;
    private static final int OPT_DELETE = 3;
    static boolean gotDefaults = false;
    Interp interp = null;

    SwkSMenuWidgetCmd() {
    }

    public static String[] getValidCmds() {
        return validCmds;
    }

    public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
        if (argv.length < 2) {
            throw new TclNumArgsException(interp, 1, argv, "option ?arg arg ...?");
        }
        int opt = TclIndex.get(interp, argv[1], validCmds, "option", 0);
        TclObject tObj = (TclObject)Widgets.getWidget(interp, argv[0].toString());
        this.interp = interp;
        if (tObj == null) {
            throw new TclException(interp, "bad window path name \"" + argv[0].toString() + "\"");
        }
        SwkSMenu swksmenu = (SwkSMenu)ReflectObject.get((Interp)interp, (TclObject)tObj);
        switch (opt) {
            case 0: {
                if (argv.length != 3) {
                    throw new TclNumArgsException(interp, 2, argv, "option");
                }
                interp.setResult(swksmenu.jget(interp, argv[2]));
                break;
            }
            case 1: {
                if (!gotDefaults) {
                    swksmenu.setResourceDefaults();
                    gotDefaults = true;
                }
                if (argv.length == 2) {
                    swksmenu.jgetAll(interp);
                    break;
                }
                if (argv.length == 3) {
                    String result = swksmenu.jget(interp, argv[2]);
                    ResourceObject ro = (ResourceObject)SwkSMenu.resourceDB.get(argv[2].toString());
                    if (ro == null) {
                        throw new TclException(interp, "unknown option \"" + argv[2].toString() + "\"");
                    }
                    TclObject list = TclList.newInstance();
                    TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)argv[2].toString()));
                    TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)ro.resource));
                    TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)ro.className));
                    TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)ro.defaultVal));
                    TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)result));
                    interp.setResult(list);
                    break;
                }
                swksmenu.configure(interp, argv, 2);
                break;
            }
            case 2: {
                SwankUtil.addmenu(interp, swksmenu, argv);
                break;
            }
            case 3: {
                this.delete(interp, swksmenu, argv);
                break;
            }
            default: {
                throw new TclRuntimeError("TclIndex.get() error");
            }
        }
    }

    void delete(Interp interp, SwkSMenu swksmenu, TclObject[] argv) throws TclException {
        if (argv.length < 3 || argv.length > 4) {
            throw new TclNumArgsException(interp, 2, argv, "first ?last");
        }
        TclObject firstArg = argv[2].duplicate();
        TclObject lastArg = null;
        if (argv.length == 4) {
            lastArg = argv[3].duplicate();
        }
        new Delete().exec(swksmenu, firstArg, lastArg);
    }

    class Delete
    extends UpdateOnEventThread {
        SwkSMenu swksmenu = null;
        TclObject firstArg = null;
        TclObject lastArg = null;
        String sIndex = null;
        String sIndexLast = null;
        int first = 0;
        int last = 0;

        Delete() {
        }

        void exec(SwkSMenu swksmenu, TclObject firstArg, TclObject lastArg) {
            this.firstArg = firstArg;
            this.lastArg = lastArg;
            this.swksmenu = swksmenu;
            try {
                this.first = TclInteger.get((Interp)SwkSMenuWidgetCmd.this.interp, (TclObject)firstArg);
            }
            catch (TclException tclE) {
                this.sIndex = firstArg.toString();
            }
            if (lastArg != null) {
                try {
                    this.last = TclInteger.get((Interp)SwkSMenuWidgetCmd.this.interp, (TclObject)lastArg);
                }
                catch (TclException tclE) {
                    this.sIndexLast = lastArg.toString();
                }
            }
            this.execOnThread();
        }

        public void run() {
            if (this.sIndex != null) {
                try {
                    this.first = this.swksmenu.getIndex(this.sIndex, -1);
                }
                catch (TclException Tce) {
                    // empty catch block
                }
            }
            if (this.lastArg == null) {
                this.last = this.first;
            } else if (this.sIndexLast != null) {
                try {
                    this.last = this.swksmenu.getIndex(this.sIndexLast, -1);
                }
                catch (TclException Tce) {
                    // empty catch block
                }
            }
            if (this.last < this.first) {
                int hold = this.last;
                this.last = this.first;
                this.first = hold;
            }
            for (int i = this.last; i >= this.first; --i) {
                if (i < 0 || i >= this.swksmenu.getComponentCount()) continue;
                this.swksmenu.remove(i);
            }
        }
    }
}

