/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank.canvas;

import com.onemoonscientific.swank.SwkException;
import com.onemoonscientific.swank.canvas.CanvasParameter;
import com.onemoonscientific.swank.canvas.ItemTreeNode;
import com.onemoonscientific.swank.canvas.StrokeParameters;
import com.onemoonscientific.swank.canvas.SwkImageCanvas;
import com.onemoonscientific.swank.canvas.SwkShapeConfig;
import com.onemoonscientific.swank.canvas.SwkShapeRunnable;
import com.onemoonscientific.swank.canvas.Transformer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.LinkedHashMap;
import java.util.Map;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclString;

public abstract class SwkShape
implements SwkShapeConfig {
    public static final byte ACTIVE = 0;
    public static final byte DISABLED = 1;
    public static final byte HIDDEN = 2;
    static BasicStroke bstroke = new BasicStroke();
    public static int handleSize = 6;
    StrokeParameters strokePar = StrokeParameters.getDefault();
    Shape shape = null;
    ItemTreeNode node = null;
    int id;
    public double[] storeCoords = null;
    Color fill = null;
    GradientPaint fillGradient = null;
    Point2D gradPt1 = null;
    Point2D gradPt2 = null;
    TexturePaint texturePaint = null;
    String imageName = "";
    Color outline = Color.black;
    BasicStroke stroke = null;
    boolean newStroke = false;
    boolean newTransform = false;
    float width = 1.0f;
    float height = 1.0f;
    Transformer transformer = null;
    float rotate = 0.0f;
    float xShear = 0.0f;
    float yShear = 0.0f;
    byte state = 0;
    Map tags = new LinkedHashMap();
    String[] tagNames = null;
    SwkImageCanvas canvas = null;
    boolean selected = false;

    public SwkShape() {
    }

    public SwkShape(Shape shape, SwkImageCanvas canvas) {
        this.shape = shape;
        this.canvas = canvas;
    }

    public int getState() {
        return this.state;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public float getXShear() {
        return this.xShear;
    }

    public float getYShear() {
        return this.yShear;
    }

    public void setNode(String nodeName) {
        try {
            SwkShape shapeNode = this.canvas.getShape(nodeName);
            ItemTreeNode newParent = shapeNode.node;
            System.out.println("set node for " + this.getId() + " to " + nodeName);
            newParent.add(this.node);
        }
        catch (SwkException swkException) {
            // empty catch block
        }
    }

    public String getNode() {
        return "";
    }

    public String getStateString() {
        if (this.state == 0) {
            return "normal";
        }
        if (this.state == 1) {
            return "disabled";
        }
        if (this.state == 2) {
            return "hidden";
        }
        throw new RuntimeException("invalid state value");
    }

    public void setState(byte newState) {
        this.state = newState;
    }

    public double[] getStoreCoords() {
        return this.storeCoords;
    }

    public AffineTransform getTransform() {
        if (this.transformer != null) {
            if (this.transformer.isValid()) {
                return this.transformer.getTransform();
            }
            this.transformer = null;
        }
        return null;
    }

    public Shape getShape() {
        return this.shape;
    }

    public SwkImageCanvas getCanvas() {
        return this.canvas;
    }

    public int getId() {
        return this.id;
    }

    public Color getFill() {
        return this.fill;
    }

    public void setFill(Color color) {
        this.fill = color;
    }

    public GradientPaint getFillGradient() {
        return this.fillGradient;
    }

    public TexturePaint getTexturePaint() {
        return this.texturePaint;
    }

    public Color getOutline() {
        return this.outline;
    }

    public void setOutline(Color color) {
        this.outline = color;
    }

    public BasicStroke getStroke() {
        return this.stroke;
    }

    public float getWidth() {
        return this.width;
    }

    public void setWidth(double value) {
        this.width = (float)value;
    }

    public int getCap() {
        return this.strokePar.getCap();
    }

    public void setCap(int newValue) {
        this.strokePar = StrokeParameters.setCap(this.strokePar, newValue);
    }

    public int getJoin() {
        return this.strokePar.getJoin();
    }

    public void setJoin(int newValue) {
        this.strokePar = StrokeParameters.setJoin(this.strokePar, newValue);
    }

    public float getMiterLimit() {
        return this.strokePar.getMiterLimit();
    }

    public float[] getDash() {
        return this.strokePar.getDash();
    }

    public void setDash(float[] newDash) {
        this.strokePar = StrokeParameters.setDash(this.strokePar, newDash);
    }

    public float getDashPhase() {
        return this.strokePar.getDashPhase();
    }

    public void setDashPhase(float newPhase) {
        this.strokePar = StrokeParameters.setDashPhase(this.strokePar, newPhase);
    }

    public boolean getDashIntPattern() {
        return this.strokePar.isDashIntPattern();
    }

    public void setDashIntPattern(boolean newPar) {
        this.strokePar = StrokeParameters.setDashIntPattern(this.strokePar, newPar);
    }

    public String getDashString() {
        return this.strokePar.getDashString();
    }

    public void setDashString(String newString) {
        this.strokePar = StrokeParameters.setDashString(this.strokePar, newString);
    }

    public float getRotate() {
        return this.rotate;
    }

    public Map getTags() {
        return this.tags;
    }

    public void setTags(String[] tags) {
        this.tagNames = tags;
    }

    public void setCanvas(SwkImageCanvas canvas) {
        this.canvas = canvas;
    }

    public void setShape(Shape shape) {
        this.shape = shape;
    }

    public Cursor getHandleCursor(int handle) {
        Cursor cursor;
        switch (handle) {
            case 0: {
                cursor = Cursor.getPredefinedCursor(6);
                break;
            }
            case 1: {
                cursor = Cursor.getPredefinedCursor(8);
                break;
            }
            case 2: {
                cursor = Cursor.getPredefinedCursor(7);
                break;
            }
            case 3: {
                cursor = Cursor.getPredefinedCursor(11);
                break;
            }
            case 4: {
                cursor = Cursor.getPredefinedCursor(5);
                break;
            }
            case 5: {
                cursor = Cursor.getPredefinedCursor(9);
                break;
            }
            case 6: {
                cursor = Cursor.getPredefinedCursor(4);
                break;
            }
            case 7: {
                cursor = Cursor.getPredefinedCursor(10);
                break;
            }
            default: {
                cursor = Cursor.getPredefinedCursor(0);
            }
        }
        return cursor;
    }

    public boolean hitHandle(int x, int y, double xTest, double yTest) {
        int fuzz = 2;
        return new Rectangle(x - fuzz, y - fuzz, handleSize + 2 * fuzz, handleSize + 2 * fuzz).contains(xTest, yTest);
    }

    void drawHandle(Graphics2D g2, int x, int y) {
        g2.setPaint(Color.WHITE);
        g2.fillRect(x - handleSize / 2, y - handleSize / 2, handleSize, handleSize);
        g2.setColor(Color.BLACK);
        g2.setStroke(bstroke);
        g2.drawRect(x - handleSize / 2, y - handleSize / 2, handleSize, handleSize);
    }

    public void drawHandles(Graphics2D g2) {
        if (this.shape != null) {
            Rectangle2D bounds = this.shape.getBounds2D();
            double x1 = bounds.getMinX();
            double y1 = bounds.getMinY();
            double x2 = bounds.getMaxX();
            double y2 = bounds.getMaxY();
            double xm = (x1 + x2) / 2.0;
            double ym = (y1 + y2) / 2.0;
            double[] xy = new double[]{x1, y1, xm, y1, x2, y1, x2, ym, x2, y2, xm, y2, x1, y2, x1, ym};
            AffineTransform shapeTransform = this.getTransform();
            if (shapeTransform != null) {
                shapeTransform.transform(xy, 0, xy, 0, xy.length / 2);
            }
            for (int i = 0; i < xy.length; i += 2) {
                this.drawHandle(g2, (int)xy[i], (int)xy[i + 1]);
            }
        }
    }

    public int hitHandles(double testX, double testY) {
        int hitIndex = -1;
        if (this.shape != null) {
            Rectangle2D bounds = this.shape.getBounds2D();
            double x1 = bounds.getMinX();
            double y1 = bounds.getMinY();
            double x2 = bounds.getMaxX();
            double y2 = bounds.getMaxY();
            double xm = (x1 + x2) / 2.0;
            double ym = (y1 + y2) / 2.0;
            double[] xy = new double[]{x1, y1, xm, y1, x2, y1, x2, ym, x2, y2, xm, y2, x1, y2, x1, ym};
            AffineTransform shapeTransform = this.getTransform();
            if (shapeTransform != null) {
                shapeTransform.transform(xy, 0, xy, 0, xy.length / 2);
            }
            for (int i = 0; i < xy.length; i += 2) {
                if (!this.hitHandle((int)xy[i], (int)xy[i + 1], testX, testY)) continue;
                hitIndex = i / 2;
                break;
            }
        }
        return hitIndex;
    }

    public void paintShape(Graphics2D g2) {
        if (this.shape != null) {
            if (this.stroke != null) {
                g2.setStroke(this.stroke);
            } else {
                g2.setStroke(bstroke);
            }
            AffineTransform shapeTransform = this.getTransform();
            Shape shape2 = this.shape;
            if (shapeTransform != null) {
                shape2 = shapeTransform.createTransformedShape(this.shape);
            }
            if (this.texturePaint != null) {
                g2.setPaint(this.texturePaint);
                g2.fill(shape2);
            } else if (this.fillGradient != null) {
                g2.setPaint(this.fillGradient);
                g2.fill(shape2);
            } else if (this.fill != null) {
                g2.setPaint(this.fill);
                g2.fill(shape2);
            }
            if (this.outline != null) {
                g2.setPaint(this.outline);
                g2.draw(shape2);
            }
        }
    }

    public abstract CanvasParameter[] getParameters();

    public void configOld(Interp interp, TclObject[] argv, int start) throws TclException {
        if ((argv.length - start) % 2 != 0) {
            throw new TclNumArgsException(interp, 0, argv, "-option value ? -option value? ...");
        }
    }

    public void configShape(Interp interp, SwkImageCanvas swkCanvas, TclObject[] argv, int start) throws TclException {
        Map parameterMap = this.getParameterMap();
        CanvasParameter[] setPars = new CanvasParameter[(argv.length - start) / 2];
        boolean gotPar = false;
        int i = start;
        int j = 0;
        while (i < argv.length) {
            block9: {
                CanvasParameter cPar = null;
                cPar = this.getPar(argv[i].toString());
                if (cPar == null) {
                    String parName = "com.onemoonscientific.swank.canvas." + argv[i].toString().substring(1, 2).toUpperCase() + argv[i].toString().substring(2).toLowerCase() + "Parameter";
                    Class<?> newClass = null;
                    try {
                        newClass = Class.forName(parName);
                    }
                    catch (ClassNotFoundException cnfE) {
                        break block9;
                    }
                    try {
                        cPar = (CanvasParameter)newClass.newInstance();
                    }
                    catch (InstantiationException iE) {
                        throw new TclException(interp, "can't instantiate " + parName);
                    }
                    catch (IllegalAccessException iaE) {
                        throw new TclException(interp, "can't instantiate " + parName);
                    }
                }
                if (cPar != null) {
                    setPars[j] = (CanvasParameter)cPar.clone();
                    setPars[j].setValue(interp, swkCanvas, argv[i + 1]);
                    gotPar = true;
                }
            }
            i += 2;
            ++j;
        }
        if (gotPar) {
            new SwkShapeRunnable(swkCanvas, this, setPars).exec();
        }
    }

    public static void config(Interp interp, SwkImageCanvas swkCanvas, TclObject[] argv, int start) throws TclException {
        CanvasParameter[] setPars = new CanvasParameter[(argv.length - start) / 2];
        boolean gotPar = false;
        int i = start;
        int j = 0;
        while (i < argv.length) {
            CanvasParameter cPar = null;
            cPar = CanvasParameter.getStdPar(argv[i].toString());
            if (cPar == null) {
                String parName = "com.onemoonscientific.swank.canvas." + argv[i].toString().substring(1, 2).toUpperCase() + argv[i].toString().substring(2) + "Parameter";
                Class<?> newClass = null;
                try {
                    newClass = Class.forName(parName);
                }
                catch (ClassNotFoundException cnfE) {
                    throw new TclException(interp, "class " + parName + " doesn't exist " + cnfE.toString());
                }
                try {
                    cPar = (CanvasParameter)newClass.newInstance();
                }
                catch (InstantiationException iE) {
                    throw new TclException(interp, "can't instantiate " + parName);
                }
                catch (IllegalAccessException iaE) {
                    throw new TclException(interp, "can't instantiate " + parName);
                }
            }
            if (cPar != null) {
                setPars[j] = (CanvasParameter)cPar.clone();
                setPars[j].setValue(interp, swkCanvas, argv[i + 1]);
                gotPar = true;
            }
            i += 2;
            ++j;
        }
        if (gotPar) {
            new SwkShapeRunnable(swkCanvas, argv[start - 1].toString(), setPars).exec();
        }
    }

    public void itemConfigure(Interp interp, TclObject[] argv, int start) throws TclException {
        TclObject list = TclList.newInstance();
        interp.resetResult();
        if (argv.length == start) {
            CanvasParameter[] pars = this.getParameters();
            for (int i = 0; i < pars.length; ++i) {
                TclObject list2 = this.itemGet(interp, pars[i].getName(), true);
                TclList.append((Interp)interp, (TclObject)list, (TclObject)list2);
            }
            interp.setResult(list);
            return;
        }
        interp.setResult(this.itemGet(interp, argv[start].toString(), true));
    }

    public void dispose() {
    }

    public void coords(SwkImageCanvas canvas, double[] coordArray) throws SwkException {
    }

    public double[] coords() {
        return this.storeCoords;
    }

    public TclObject itemGet(Interp interp, String argString, boolean configStyle) throws TclException {
        CanvasParameter par = this.getPar(argString);
        if (par != null) {
            TclObject value = par.getValue(interp, this);
            if (!configStyle) {
                return value;
            }
            TclObject list = TclList.newInstance();
            TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)("-" + par.getName())));
            TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)""));
            TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)""));
            TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)par.getDefault()));
            TclList.append((Interp)interp, (TclObject)list, (TclObject)value);
            return list;
        }
        return TclString.newInstance((String)"");
    }

    public String toString() {
        return String.valueOf(this.id);
    }

    public void move(double x, double y) {
        for (int i = 0; i < this.storeCoords.length; i += 2) {
            int n = i;
            this.storeCoords[n] = this.storeCoords[n] + x;
            int n2 = i + 1;
            this.storeCoords[n2] = this.storeCoords[n2] + y;
        }
        this.applyCoordinates();
    }

    void checkCoordinates(double[] coords) {
        double hold;
        if (coords == null || coords.length != 4) {
            return;
        }
        if (coords[0] > coords[2]) {
            hold = coords[0];
            coords[0] = coords[2];
            coords[2] = hold;
        }
        if (coords[1] > coords[3]) {
            hold = coords[1];
            coords[1] = coords[3];
            coords[3] = hold;
        }
    }

    public void applyCoordinates() {
    }

    public Point2D getGradPt1() {
        return this.gradPt1;
    }

    public Point2D getGradPt2() {
        return this.gradPt2;
    }

    public void setGradPt1(Point2D p1) {
        this.gradPt1 = p1;
    }

    public void setGradPt2(Point2D p2) {
        this.gradPt2 = p2;
    }

    public boolean hitShape(double x1, double y1) {
        boolean hit = false;
        if (this.shape != null) {
            Rectangle bounds;
            Shape checkShape = this.shape;
            AffineTransform shapeTransform = this.getTransform();
            if (shapeTransform != null) {
                checkShape = shapeTransform.createTransformedShape(this.shape);
            }
            if ((this.fill != null || this.fillGradient != null || this.texturePaint != null) && (bounds = checkShape.getBounds()).contains(x1, y1)) {
                hit = true;
            }
            if (!hit) {
                PathIterator pI = checkShape.getPathIterator(null);
                double[] tcoords = new double[6];
                double tx1 = 0.0;
                double ty1 = 0.0;
                double tx2 = 0.0;
                double ty2 = 0.0;
                int closeEnough = 2;
                int closeEnough2 = closeEnough * closeEnough;
                while (!pI.isDone()) {
                    int type = pI.currentSegment(tcoords);
                    if (type == 1) {
                        tx2 = tcoords[0];
                        ty2 = tcoords[1];
                        double dis = Line2D.ptSegDistSq(tx1, ty1, tx2, ty2, x1, y1);
                        tx1 = tx2;
                        ty1 = ty2;
                        if (dis <= (double)closeEnough2) {
                            hit = true;
                            break;
                        }
                    } else if (type == 0) {
                        tx1 = tcoords[0];
                        ty1 = tcoords[1];
                    }
                    pI.next();
                }
            }
        }
        return hit;
    }

    public String hit(double x, double y) {
        return "";
    }

    public void select(TclObject tObj) {
    }

    public int getIndexAtXY(double x, double y) {
        return 0;
    }

    public int getIndex(Interp interp, TclObject indexArg) throws TclException {
        String indexString = indexArg.toString();
        if (indexString.startsWith("@")) {
            if (indexString.length() > 1) {
                int commaPos = indexString.indexOf(44);
                if (commaPos < 0) {
                    throw new TclException(interp, "bad text index \"" + indexString + "\"");
                }
                String xS = indexString.substring(1, commaPos);
                String yS = indexString.substring(commaPos + 1);
                int x = Integer.valueOf(xS);
                int y = Integer.valueOf(yS);
                int offset = this.getIndexAtXY(x, y);
                return offset;
            }
            throw new TclException(interp, "bad text index \"" + indexString + "\"");
        }
        return 0;
    }

    public void scale(double xOrigin, double yOrigin, double xScale, double yScale) {
        for (int i = 0; i < this.storeCoords.length; i += 2) {
            this.storeCoords[i] = (this.storeCoords[i] - xOrigin) * xScale + xOrigin;
            this.storeCoords[i + 1] = (this.storeCoords[i + 1] - yOrigin) * yScale + yOrigin;
        }
        this.applyCoordinates();
    }

    void updateStroke() {
        if (this.newStroke) {
            this.stroke = this.strokePar.getStroke(this.width);
        }
    }

    public void genGradient(AffineTransform aT) {
        if (this.fillGradient != null && this.gradPt1 != null && this.gradPt2 != null) {
            Color c1 = this.fillGradient.getColor1();
            Color c2 = this.fillGradient.getColor2();
            boolean cyclic = this.fillGradient.isCyclic();
            Point2D p1 = new Point2D.Double();
            Point2D p2 = new Point2D.Double();
            double x = (this.storeCoords[2] - this.storeCoords[0]) * this.gradPt1.getX() + this.storeCoords[0];
            double y = (this.storeCoords[3] - this.storeCoords[1]) * this.gradPt1.getY() + this.storeCoords[1];
            ((Point2D)p1).setLocation(x, y);
            x = (this.storeCoords[2] - this.storeCoords[0]) * this.gradPt2.getX() + this.storeCoords[0];
            y = (this.storeCoords[3] - this.storeCoords[1]) * this.gradPt2.getY() + this.storeCoords[1];
            ((Point2D)p2).setLocation(x, y);
            p1 = aT.transform(p1, p1);
            p2 = aT.transform(p2, p2);
            this.fillGradient = new GradientPaint(p1, c1, p2, c2, cyclic);
        }
    }

    public Map getParameterMap() {
        return null;
    }

    public static void initializeParameters(CanvasParameter[] params, Map map) {
        for (int i = 0; i < params.length; ++i) {
            map.put(params[i].getName(), params[i]);
            CanvasParameter cPar = CanvasParameter.getStdPar(params[i].getName());
            if (cPar != null) continue;
            CanvasParameter.addParameter(params[i]);
        }
    }

    public CanvasParameter getPar(String argString) {
        Map map = this.getParameterMap();
        if (map == null) {
            return null;
        }
        CanvasParameter par = CanvasParameter.getPar(map, argString);
        return par;
    }
}

