/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.context;

import org.ocamljava.runtime.values.Value;

public final class GCState {
    private long gcMinorHeapSize = 32768L;
    private long gcMajorHeapIncrement = 63488L;
    private long gcSpaceOverhead = 80L;
    private long gcVerbose = 0L;
    private long gcMaxOverhead = 500L;
    private long gcStackLimit = 262144L;
    private long gcMinorCounter = 0L;
    private long gcMajorCounter = 0L;
    private long gcCompactionCounter = 0L;
    private long gcAllocationPolicy = 0L;

    GCState() {
    }

    public Value makeGcParams() {
        return Value.createBlock(0, Value.createLong(this.gcMinorHeapSize), Value.createLong(this.gcMajorHeapIncrement), Value.createLong(this.gcSpaceOverhead), Value.createLong(this.gcVerbose), Value.createLong(this.gcMaxOverhead), Value.createLong(this.gcStackLimit), Value.createLong(this.gcAllocationPolicy));
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setGcParams(Value value) {
        assert (value != null) : "null params";
        this.gcMinorHeapSize = value.get0().asLong();
        this.gcMajorHeapIncrement = value.get1().asLong();
        this.gcSpaceOverhead = value.get2().asLong();
        this.gcVerbose = value.get3().asLong();
        this.gcMaxOverhead = value.get4().asLong();
        this.gcStackLimit = value.get5().asLong();
        long l = value.get6().asLong();
        this.gcAllocationPolicy = l >= 0L && l <= 1L ? l : 1L;
    }

    public Value makeGcStats() {
        double d = Runtime.getRuntime().totalMemory() / 8L;
        Value value = Value.createLong((long)d);
        Value value2 = Value.createBlock(0, 16L);
        value2.set0(Value.createDouble(d));
        value2.set1(Value.createDouble(d));
        value2.set2(Value.createDouble(d));
        value2.set3(Value.createLong(this.gcMinorCounter));
        value2.set4(Value.createLong(this.gcMajorCounter));
        value2.set5(value);
        value2.set6(Value.ONE);
        value2.set7(Value.ZERO);
        value2.set(8, Value.ZERO);
        value2.set(9, Value.ZERO);
        value2.set(10, Value.ZERO);
        value2.set(11, Value.ZERO);
        value2.set(12, Value.ZERO);
        value2.set(13, Value.createLong(this.gcCompactionCounter));
        value2.set(14, value);
        value2.set(15, Value.ZERO);
        return value2;
    }

    public Value makeGcCounters() {
        double d = Runtime.getRuntime().totalMemory() / 8L;
        return Value.createBlock(0, Value.createDouble(d), Value.createDouble(d), Value.createDouble(d));
    }

    public void incMinorCounter() {
        ++this.gcMinorCounter;
    }

    public void incMajorCounter() {
        ++this.gcMajorCounter;
    }

    public void incCompactionCounter() {
        ++this.gcCompactionCounter;
    }
}

