/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.unix;

import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.RandomAccessFile;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.FalseExit;
import org.ocamljava.runtime.primitives.otherlibs.unix.Unix;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="unix", module="Unix", source="otherlibs/unix/truncate.c")
public final class Truncate {
    private Truncate() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string", "int"}, returnType="unit")
    public static Value unix_truncate(Value value, Value value2) throws Fail.Exception, FalseExit {
        try {
            File file = CurrentContext.FILES_STATE.getRealFile(value);
            new RandomAccessFile(file, "rw").setLength(value2.asLong());
            return Value.UNIT;
        }
        catch (InterruptedIOException interruptedIOException) {
            FalseExit falseExit = FalseExit.createFromContext(CurrentContext.CONTEXT);
            falseExit.fillInStackTrace();
            throw falseExit;
        }
        catch (IOException iOException) {
            Unix.fail("truncate", iOException);
            return Value.UNIT;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string", "int64"}, returnType="unit")
    public static Value unix_truncate_64(Value value, Value value2) throws Fail.Exception, FalseExit {
        try {
            File file = CurrentContext.FILES_STATE.getRealFile(value);
            new RandomAccessFile(file, "rw").setLength(value2.asInt64());
            return Value.UNIT;
        }
        catch (InterruptedIOException interruptedIOException) {
            FalseExit falseExit = FalseExit.createFromContext(CurrentContext.CONTEXT);
            falseExit.fillInStackTrace();
            throw falseExit;
        }
        catch (IOException iOException) {
            Unix.fail("truncate_64", iOException);
            return Value.UNIT;
        }
    }
}

