/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.support.wrappers;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import org.ocamljava.runtime.support.wrappers.ToValue;
import org.ocamljava.runtime.values.Value;

public final class List<T extends ToValue>
implements ToValue,
Iterable<T> {
    private final java.util.List<T> value;

    public List() {
        this.value = new LinkedList<T>();
    }

    public List(java.util.List<T> that) {
        assert (that != null) : "null that";
        this.value = new LinkedList<T>(that);
    }

    public List(T ... elements) {
        assert (elements != null) : "null elements";
        this.value = new LinkedList<T>();
        for (T e : elements) {
            this.value.add(e);
        }
    }

    @Override
    public Iterator<T> iterator() {
        return Collections.unmodifiableList(this.value).iterator();
    }

    @Override
    public Value toValue() {
        Value res = Value.EMPTY_LIST;
        ListIterator<T> it = this.value.listIterator(this.value.size());
        while (it.hasPrevious()) {
            res = Value.createBlock(0, ((ToValue)it.previous()).toValue(), res);
        }
        return res;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof List) {
            List that = (List)obj;
            return this.value.equals(that.value);
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[");
        boolean first = true;
        for (ToValue e : this.value) {
            if (first) {
                first = false;
            } else {
                sb.append("; ");
            }
            sb.append(e.toString());
        }
        sb.append("]");
        return sb.toString();
    }
}

