/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.systhreads;

import java.util.concurrent.Semaphore;
import org.ocamljava.runtime.context.Context;
import org.ocamljava.runtime.kernel.CodeRunner;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.FalseExit;
import org.ocamljava.runtime.kernel.OCamlJavaThread;
import org.ocamljava.runtime.primitives.otherlibs.systhreads.CustomThreadStatus;
import org.ocamljava.runtime.values.Value;

public final class ThreadStatus {
    private Semaphore alive = new Semaphore(1, true);
    private final OCamlJavaThread thread;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ThreadStatus(CodeRunner codeRunner, OCamlJavaThread oCamlJavaThread) {
        try {
            this.alive.acquire();
        }
        catch (InterruptedException interruptedException) {}
        this.thread = oCamlJavaThread != null ? oCamlJavaThread : new OCamlJavaThread(codeRunner.getContext().getThreadsState().getThreadGroup(), codeRunner);
    }

    public static Value createValue(ThreadStatus threadStatus) {
        return Value.createCustom(CustomThreadStatus.OPS, 1L, threadStatus);
    }

    public OCamlJavaThread getThread() {
        return this.thread;
    }

    public void terminate() {
        this.alive.release();
        this.thread.asksToStop();
    }

    public void suspend() {
        this.thread.pause();
    }

    public void resume() {
        this.thread.wakeUp();
    }

    public boolean isSuspended() {
        return this.thread.isPaused();
    }

    public boolean isAlive() {
        return this.alive.availablePermits() == 0;
    }

    void waitTerm(Context context) throws FalseExit, Fail.Exception {
        if ($assertionsDisabled || context != null) {
            try {
                this.alive.acquire();
                this.alive.release();
                return;
            }
            catch (InterruptedException interruptedException) {
                FalseExit falseExit = FalseExit.createFromContext(context);
                falseExit.fillInStackTrace();
                throw falseExit;
            }
        }
        throw new AssertionError((Object)"null ctxt");
    }
}

