/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.util;

import java.nio.ByteOrder;

public final class PlatformUtils {
    private static final boolean IS_WINDOW_PLATFORM = PlatformUtils.initWindowPlatform();
    private static final boolean IS_CYGWIN_PLATFORM = PlatformUtils.initCygwinPlatform();
    private static final boolean IS_BIG_ENDIAN_PLATFORM = PlatformUtils.initBigEndianPlatform();

    private PlatformUtils() {
    }

    public static boolean isWindowPlatform() {
        return IS_WINDOW_PLATFORM;
    }

    public static boolean isCygwinPlatform() {
        return IS_CYGWIN_PLATFORM;
    }

    public static boolean isBigEndianPlatform() {
        return IS_BIG_ENDIAN_PLATFORM;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean initWindowPlatform() {
        try {
            String string = System.getProperty("os.name");
            if (string == null) return false;
            if (string.toLowerCase().indexOf("windows") <= -1) return false;
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean initCygwinPlatform() {
        if (!PlatformUtils.initWindowPlatform()) return false;
        try {
            String string = System.getenv("SHELL");
            if (string == null) return false;
            if (!string.startsWith("/")) return false;
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private static boolean initBigEndianPlatform() {
        return ByteOrder.BIG_ENDIAN.equals(ByteOrder.nativeOrder());
    }
}

