/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.bigarray;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.Fatal;
import org.ocamljava.runtime.primitives.otherlibs.bigarray.MemArray;
import org.ocamljava.runtime.primitives.stdlib.Hash;
import org.ocamljava.runtime.util.IO;
import org.ocamljava.runtime.util.IntegerUtils;
import org.ocamljava.runtime.values.AbstractCustomOperations;
import org.ocamljava.runtime.values.CustomOperations;
import org.ocamljava.runtime.values.Value;

final class CustomBigArray
extends AbstractCustomOperations {
    static final CustomOperations OPS = new CustomBigArray();
    private static final long FLAG_MASK = 511L;

    private CustomBigArray() {
        super("_bigarray", true, true, false, true, true);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void finalize(Value value) {
        MemArray memArray = (MemArray)value.asCustom();
        switch ((int)(memArray.getFlags() & 0x600L)) {
            case 512: {
                assert (false) : "unsupported";
                return;
            }
            case 1024: {
                memArray.unMap();
                return;
            }
            default: {
                assert (false) : "invalid bigarray kind";
                return;
            }
            case 0: 
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int compare(Value value, Value value2, AtomicBoolean atomicBoolean) {
        int n;
        ByteBuffer byteBuffer;
        ByteBuffer byteBuffer2;
        int n2;
        block51: {
            int n3;
            block50: {
                int n4;
                block45: {
                    int n5;
                    block46: {
                        int n6;
                        block47: {
                            int n7;
                            block48: {
                                int n8;
                                block49: {
                                    int n9;
                                    MemArray memArray = (MemArray)value.asCustom();
                                    MemArray memArray2 = (MemArray)value2.asCustom();
                                    long l = memArray.getFlags() & 0x1FFL;
                                    long l2 = memArray2.getFlags() & 0x1FFL;
                                    int[] nArray = memArray.getDims();
                                    int[] nArray2 = memArray2.getDims();
                                    if (l != l2) {
                                        return (int)(l2 - l);
                                    }
                                    if (nArray.length != nArray2.length) {
                                        return nArray2.length - nArray.length;
                                    }
                                    n2 = 0;
                                    block10: while (true) {
                                        block53: {
                                            block54: {
                                                block55: {
                                                    block56: {
                                                        block52: {
                                                            if (n2 >= nArray.length) break block52;
                                                            int n10 = nArray[n2];
                                                            int n11 = nArray2[n2];
                                                            if (n10 != n11) {
                                                                if (n10 < n11) return -1;
                                                                return 1;
                                                            }
                                                            break block53;
                                                        }
                                                        n2 = (int)memArray.getNumElems();
                                                        byteBuffer2 = memArray.getData();
                                                        byteBuffer = memArray2.getData();
                                                        switch ((int)(l & 0xFFL)) {
                                                            case 0: 
                                                            case 10: {
                                                                if ((l & 0xFFL) != 10L) break block54;
                                                                break block55;
                                                            }
                                                            case 1: 
                                                            case 11: {
                                                                if ((l & 0xFFL) == 11L) {
                                                                    break;
                                                                }
                                                                break block56;
                                                            }
                                                            case 2: {
                                                                n4 = 0;
                                                                break block45;
                                                            }
                                                            case 3: {
                                                                n5 = 0;
                                                                break block46;
                                                            }
                                                            case 4: {
                                                                n6 = 0;
                                                                break block47;
                                                            }
                                                            case 5: {
                                                                n7 = 0;
                                                                break block48;
                                                            }
                                                            case 7: 
                                                            case 9: {
                                                                n8 = 0;
                                                                break block49;
                                                            }
                                                            case 6: 
                                                            case 8: {
                                                                n9 = 0;
                                                                break block10;
                                                            }
                                                            default: {
                                                                assert (false) : "invalid elements kind";
                                                                return 0;
                                                            }
                                                        }
                                                        n3 = 2;
                                                        break block50;
                                                    }
                                                    n3 = 1;
                                                    break block50;
                                                }
                                                n = 2;
                                                break block51;
                                            }
                                            n = 1;
                                            break block51;
                                        }
                                        ++n2;
                                    }
                                    while (n9 < n2) {
                                        int n12;
                                        int n13 = byteBuffer2.getInt(n9 * 4);
                                        if (n13 < (n12 = byteBuffer.getInt(n9 * 4))) {
                                            return -1;
                                        }
                                        if (n13 > n12) {
                                            return 1;
                                        }
                                        ++n9;
                                    }
                                    return 0;
                                }
                                while (n8 < n2) {
                                    long l;
                                    long l3 = byteBuffer2.getLong(n8 * 8);
                                    if (l3 < (l = byteBuffer.getLong(n8 * 8))) {
                                        return -1;
                                    }
                                    if (l3 > l) {
                                        return 1;
                                    }
                                    ++n8;
                                }
                                return 0;
                            }
                            while (n7 < n2) {
                                int n14;
                                int n15 = IntegerUtils.signedToUnsignedShort(byteBuffer2.getShort(n7 * 2));
                                if (n15 < (n14 = IntegerUtils.signedToUnsignedShort(byteBuffer.getShort(n7 * 2)))) {
                                    return -1;
                                }
                                if (n15 > n14) {
                                    return 1;
                                }
                                ++n7;
                            }
                            return 0;
                        }
                        while (n6 < n2) {
                            short s;
                            short s2 = byteBuffer2.getShort(n6 * 2);
                            if (s2 < (s = byteBuffer.getShort(n6 * 2))) {
                                return -1;
                            }
                            if (s2 > s) {
                                return 1;
                            }
                            ++n6;
                        }
                        return 0;
                    }
                    while (n5 < n2) {
                        int n16;
                        int n17 = IntegerUtils.signedToUnsignedByte(byteBuffer2.get(n5 * 1));
                        if (n17 < (n16 = IntegerUtils.signedToUnsignedByte(byteBuffer.get(n5 * 1)))) {
                            return -1;
                        }
                        if (n17 > n16) {
                            return 1;
                        }
                        ++n5;
                    }
                    return 0;
                }
                while (n4 < n2) {
                    byte by;
                    byte by2 = byteBuffer2.get(n4 * 1);
                    if (by2 < (by = byteBuffer.get(n4 * 1))) {
                        return -1;
                    }
                    if (by2 > by) {
                        return 1;
                    }
                    ++n4;
                }
                return 0;
            }
            int n18 = n3;
            int n19 = 0;
            while (n19 < n2 * n18) {
                double d;
                double d2 = byteBuffer2.getDouble(n19 * 8);
                if (d2 < (d = byteBuffer.getDouble(n19 * 8))) {
                    return -1;
                }
                if (d2 > d) {
                    return 1;
                }
                if (d2 != d) {
                    atomicBoolean.set(true);
                    if (d2 == d2) {
                        return 1;
                    }
                    if (d == d) {
                        return -1;
                    }
                }
                ++n19;
            }
            return 0;
        }
        int n20 = n;
        int n21 = 0;
        while (n21 < n2 * n20) {
            float f;
            float f2 = byteBuffer2.getFloat(n21 * 4);
            if (f2 < (f = byteBuffer.getFloat(n21 * 4))) {
                return -1;
            }
            if (f2 > f) {
                return 1;
            }
            if (f2 != f) {
                atomicBoolean.set(true);
                if (f2 == f2) {
                    return 1;
                }
                if (f == f) {
                    return -1;
                }
            }
            ++n21;
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public long hash(Value value) {
        int n;
        int n2;
        int n3;
        ByteBuffer byteBuffer;
        block26: {
            block27: {
                block28: {
                    block29: {
                        block30: {
                            block31: {
                                block32: {
                                    block33: {
                                        block34: {
                                            block35: {
                                                block36: {
                                                    block37: {
                                                        block38: {
                                                            MemArray memArray = (MemArray)value.asCustom();
                                                            byteBuffer = memArray.getData();
                                                            n3 = (int)memArray.getNumElems();
                                                            n2 = 0;
                                                            int n4 = (int)(memArray.getFlags() & 0xFFL);
                                                            switch (n4) {
                                                                case 2: 
                                                                case 3: {
                                                                    if (n3 <= 256) break block26;
                                                                    break block27;
                                                                }
                                                                case 4: 
                                                                case 5: {
                                                                    if (n3 <= 128) break block28;
                                                                    break block29;
                                                                }
                                                                case 6: {
                                                                    if (n3 <= 64) break block30;
                                                                    break block31;
                                                                }
                                                                case 8: 
                                                                case 9: {
                                                                    if (n3 <= 64) break block32;
                                                                    break block33;
                                                                }
                                                                case 7: {
                                                                    if (n3 <= 32) break block34;
                                                                    break block35;
                                                                }
                                                                case 0: 
                                                                case 10: {
                                                                    if (n4 != 10) break block36;
                                                                    break block37;
                                                                }
                                                                case 1: 
                                                                case 11: {
                                                                    if (n4 == 11) {
                                                                        break;
                                                                    }
                                                                    break block38;
                                                                }
                                                                default: {
                                                                    assert (false) : "invalid bigarray kind";
                                                                    return n2;
                                                                }
                                                            }
                                                            n3 *= 2;
                                                        }
                                                        if (n3 > 32) {
                                                            n3 = 32;
                                                        }
                                                        int n5 = 0;
                                                        while (n5 < n3) {
                                                            n2 = Hash.caml_hash_mix_double(n2, byteBuffer.getDouble(n5 * 8));
                                                            ++n5;
                                                        }
                                                        return n2;
                                                    }
                                                    n3 *= 2;
                                                }
                                                if (n3 > 64) {
                                                    n3 = 64;
                                                }
                                                int n6 = 0;
                                                while (n6 < n3) {
                                                    n2 = Hash.caml_hash_mix_float(n2, byteBuffer.getFloat(n6 * 4));
                                                    ++n6;
                                                }
                                                return n2;
                                            }
                                            n3 = 32;
                                        }
                                        int n7 = 0;
                                        while (n7 < n3) {
                                            n2 = Hash.caml_hash_mix_int64(n2, byteBuffer.getLong(n7 * 8));
                                            ++n7;
                                        }
                                        return n2;
                                    }
                                    n3 = 64;
                                }
                                int n8 = 0;
                                while (n8 < n3) {
                                    n2 = Hash.caml_hash_mix_intnat(n2, byteBuffer.getLong(n8 * 8));
                                    ++n8;
                                }
                                return n2;
                            }
                            n3 = 64;
                        }
                        int n9 = 0;
                        while (n9 < n3) {
                            n2 = Hash.caml_hash_mix_uint32(n2, byteBuffer.getInt(n9 * 4));
                            ++n9;
                        }
                        return n2;
                    }
                    n3 = 128;
                }
                int n10 = 0;
                while (true) {
                    if (n10 + 2 > n3) {
                        if ((n3 & 1) == 0) return n2;
                        n2 = Hash.caml_hash_mix_uint32(n2, IntegerUtils.signedToUnsignedShort(byteBuffer.getShort(n10 * 2)));
                        return n2;
                    }
                    int n11 = IntegerUtils.signedToUnsignedShort(byteBuffer.getShort(n10 * 2)) | IntegerUtils.signedToUnsignedShort(byteBuffer.getShort((n10 + 1) * 2)) << 16;
                    n2 = Hash.caml_hash_mix_uint32(n2, n11);
                    n10 += 2;
                }
            }
            n3 = 256;
        }
        int n12 = 0;
        while (n12 + 4 <= n3) {
            n = IntegerUtils.signedToUnsignedByte(byteBuffer.get((n12 + 0) * 1)) | IntegerUtils.signedToUnsignedByte(byteBuffer.get((n12 + 1) * 1)) << 8 | IntegerUtils.signedToUnsignedByte(byteBuffer.get((n12 + 2) * 1)) << 16 | IntegerUtils.signedToUnsignedByte(byteBuffer.get((n12 + 3) * 1)) << 24;
            n2 = Hash.caml_hash_mix_uint32(n2, n);
            n12 += 4;
        }
        switch (n3 & 3) {
            case 0: {
                return n2;
            }
            case 1: {
                n = IntegerUtils.signedToUnsignedByte(byteBuffer.get((n12 + 0) * 1));
                return n2;
            }
            case 2: {
                n = IntegerUtils.signedToUnsignedByte(byteBuffer.get((n12 + 0) * 1)) | IntegerUtils.signedToUnsignedByte(byteBuffer.get((n12 + 1) * 1)) << 8;
                return n2;
            }
            case 3: {
                n = IntegerUtils.signedToUnsignedByte(byteBuffer.get((n12 + 0) * 1)) | IntegerUtils.signedToUnsignedByte(byteBuffer.get((n12 + 1) * 1)) << 8 | IntegerUtils.signedToUnsignedByte(byteBuffer.get((n12 + 2) * 1)) << 16;
                return n2;
            }
        }
        assert (false) : "should not happen";
        return n2;
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    @Override
    public CustomOperations.SerializationSizes serialize(DataOutput dataOutput, Value value) throws IOException {
        int n;
        int n2;
        int n3;
        int[] nArray;
        ByteBuffer byteBuffer;
        block32: {
            block33: {
                block27: {
                    block28: {
                        block29: {
                            block30: {
                                block31: {
                                    MemArray memArray = (MemArray)value.asCustom();
                                    byteBuffer = memArray.getData();
                                    nArray = memArray.getDims();
                                    IO.write32s(dataOutput, nArray.length);
                                    IO.write32s(dataOutput, (int)(memArray.getFlags() & 0x1FFL));
                                    n3 = 1;
                                    for (n = 0; n < nArray.length; n3 *= n2, ++n) {
                                        n2 = nArray[n];
                                        IO.write32s(dataOutput, n2);
                                    }
                                    switch ((int)(memArray.getFlags() & 0xFFL)) {
                                        case 2: 
                                        case 3: {
                                            n = 0;
                                            break block27;
                                        }
                                        case 4: 
                                        case 5: {
                                            n = 0;
                                            break block28;
                                        }
                                        case 0: 
                                        case 6: {
                                            n = 0;
                                            break block29;
                                        }
                                        case 10: {
                                            n = 0;
                                            break block30;
                                        }
                                        case 1: 
                                        case 7: {
                                            n = 0;
                                            break block31;
                                        }
                                        case 11: {
                                            n = 0;
                                            break;
                                        }
                                        case 8: {
                                            n = 0;
                                            break block32;
                                        }
                                        case 9: {
                                            n = 0;
                                            break block33;
                                        }
                                        default: {
                                            assert (false) : "invalid bigarray kind";
                                            return new CustomOperations.SerializationSizes(4 + nArray.length * 4, 4 + nArray.length * 8);
                                        }
                                    }
                                    while (n < n3 * 2) {
                                        IO.write64s(dataOutput, byteBuffer.getLong(n * 8));
                                        ++n;
                                    }
                                    return new CustomOperations.SerializationSizes(4 + nArray.length * 4, 4 + nArray.length * 8);
                                }
                                while (n < n3) {
                                    IO.write64s(dataOutput, byteBuffer.getLong(n * 8));
                                    ++n;
                                }
                                return new CustomOperations.SerializationSizes(4 + nArray.length * 4, 4 + nArray.length * 8);
                            }
                            while (n < n3 * 2) {
                                IO.write32s(dataOutput, byteBuffer.getInt(n * 4));
                                ++n;
                            }
                            return new CustomOperations.SerializationSizes(4 + nArray.length * 4, 4 + nArray.length * 8);
                        }
                        while (n < n3) {
                            IO.write32s(dataOutput, byteBuffer.getInt(n * 4));
                            ++n;
                        }
                        return new CustomOperations.SerializationSizes(4 + nArray.length * 4, 4 + nArray.length * 8);
                    }
                    while (n < n3) {
                        IO.write16s(dataOutput, byteBuffer.getShort(n * 2));
                        ++n;
                    }
                    return new CustomOperations.SerializationSizes(4 + nArray.length * 4, 4 + nArray.length * 8);
                }
                while (n < n3) {
                    IO.write8s(dataOutput, byteBuffer.get(n * 1));
                    ++n;
                }
                return new CustomOperations.SerializationSizes(4 + nArray.length * 4, 4 + nArray.length * 8);
            }
            while (true) {
                if (n >= n3 || byteBuffer.getLong(n * 8) < Integer.MIN_VALUE || byteBuffer.getLong(n * 8) > Integer.MAX_VALUE) {
                    if (n != n3) {
                        IO.write8u(dataOutput, 1);
                        n2 = 0;
                        while (n2 < n3) {
                            IO.write64s(dataOutput, byteBuffer.getLong(n * 8));
                            ++n2;
                        }
                        return new CustomOperations.SerializationSizes(4 + nArray.length * 4, 4 + nArray.length * 8);
                    }
                    IO.write8u(dataOutput, 0);
                    n2 = 0;
                    while (n2 < n3) {
                        IO.write32s(dataOutput, (int)byteBuffer.getLong(n * 8));
                        ++n2;
                    }
                    return new CustomOperations.SerializationSizes(4 + nArray.length * 4, 4 + nArray.length * 8);
                }
                ++n;
            }
        }
        while (true) {
            if (n >= n3 || byteBuffer.getLong(n * 8) < -4611686018427387904L || byteBuffer.getLong(n * 8) > 0x3FFFFFFFFFFFFFFFL) {
                if (n != n3) {
                    IO.write8u(dataOutput, 1);
                    n2 = 0;
                    while (n2 < n3) {
                        IO.write64s(dataOutput, byteBuffer.getLong(n * 8));
                        ++n2;
                    }
                    return new CustomOperations.SerializationSizes(4 + nArray.length * 4, 4 + nArray.length * 8);
                }
                IO.write8u(dataOutput, 0);
                n2 = 0;
                while (n2 < n3) {
                    IO.write32s(dataOutput, (int)byteBuffer.getLong(n * 8));
                    ++n2;
                }
                return new CustomOperations.SerializationSizes(4 + nArray.length * 4, 4 + nArray.length * 8);
            }
            ++n;
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public CustomOperations.DeserializedValue deserialize(DataInput var1_1) throws Fail.Exception, Fatal.Exception, IOException {
        block22: {
            block23: {
                block24: {
                    block25: {
                        block26: {
                            block27: {
                                block29: {
                                    block28: {
                                        var2_2 = IntegerUtils.ensure32s(IO.read32u(var1_1));
                                        var3_3 = IO.read32s(var1_1);
                                        var4_4 = new int[var2_2];
                                        var5_5 = 1L;
                                        for (var7_6 = 0; var7_6 < var2_2; ++var7_6) {
                                            var4_4[var7_6] = var8_8 = IntegerUtils.ensure32s(IO.read32u(var1_1));
                                            var5_5 *= (long)var8_8;
                                        }
                                        if ((var3_3 & 255) > 11) {
                                            Fail.failWith("input_value: bad bigarray kind");
                                        }
                                        var7_7 = new MemArray(var3_3, var4_4, null);
                                        var8_9 = var7_7.getData();
                                        switch ((int)(var7_7.getFlags() & 255L)) {
                                            case 2: 
                                            case 3: {
                                                var9_10 = 0;
                                                break block22;
                                            }
                                            case 4: 
                                            case 5: {
                                                var9_10 = 0;
                                                break block23;
                                            }
                                            case 0: 
                                            case 6: {
                                                var9_10 = 0;
                                                break block24;
                                            }
                                            case 10: {
                                                var9_10 = 0;
                                                break block25;
                                            }
                                            case 1: 
                                            case 7: {
                                                var9_10 = 0;
                                                break block26;
                                            }
                                            case 11: {
                                                var9_10 = 0;
                                                break block27;
                                            }
                                            case 8: 
                                            case 9: {
                                                if (IO.read8u(var1_1) == 0) {
                                                    break;
                                                }
                                                break block28;
                                            }
                                            default: {
                                                if (!CustomBigArray.$assertionsDisabled) {
                                                    throw new AssertionError((Object)"invalid elements kind");
                                                }
lbl39:
                                                // 10 sources

                                                while (true) {
                                                    var9_10 = 20 + (var7_7.getNumDims() - 1) * 8;
                                                    var10_11 = Value.createCustom(CustomBigArray.OPS, var9_10, var7_7);
                                                    return new CustomOperations.DeserializedValue(var10_11, var9_10);
                                                }
                                            }
                                        }
                                        break block29;
                                    }
                                    var9_10 = 0;
                                    while (true) {
                                        if ((long)var9_10 >= var5_5) ** GOTO lbl39
                                        var8_9.putLong(var9_10 * 8, IO.read64s(var1_1));
                                        ++var9_10;
                                    }
                                }
                                var9_10 = 0;
                                while (true) {
                                    if ((long)var9_10 >= var5_5) ** GOTO lbl39
                                    var8_9.putLong(var9_10 * 8, IO.read32s(var1_1));
                                    ++var9_10;
                                }
                            }
                            while (true) {
                                if ((long)var9_10 >= var5_5 * 2L) ** GOTO lbl39
                                var8_9.putLong(var9_10 * 8, IO.read64s(var1_1));
                                ++var9_10;
                            }
                        }
                        while (true) {
                            if ((long)var9_10 >= var5_5) ** GOTO lbl39
                            var8_9.putLong(var9_10 * 8, IO.read64s(var1_1));
                            ++var9_10;
                        }
                    }
                    while (true) {
                        if ((long)var9_10 >= var5_5 * 2L) ** GOTO lbl39
                        var8_9.putInt(var9_10 * 4, IO.read32s(var1_1));
                        ++var9_10;
                    }
                }
                while (true) {
                    if ((long)var9_10 >= var5_5) ** GOTO lbl39
                    var8_9.putInt(var9_10 * 4, IO.read32s(var1_1));
                    ++var9_10;
                }
            }
            while (true) {
                if ((long)var9_10 >= var5_5) ** GOTO lbl39
                var8_9.putShort(var9_10 * 2, (short)IO.read16s(var1_1));
                ++var9_10;
            }
        }
        while (true) {
            if ((long)var9_10 < var5_5) ** break;
            ** continue;
            var8_9.put(var9_10 * 1, (byte)IO.read8s(var1_1));
            ++var9_10;
        }
    }
}

