/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.stdlib;

import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="stdlib", module="Array", source="byterun/array.c")
public final class Array {
    private Array() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"'a array", "int"}, returnType="'a")
    public static Value caml_array_get_addr(Value value, Value value2) throws Fail.Exception {
        long l = value2.asLong();
        if (l < 0L || l >= value.sizeValues()) {
            Fail.arrayBoundError();
        }
        return value.get(l);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"float array", "int"}, returnType="float")
    public static Value caml_array_get_float(Value value, Value value2) throws Fail.Exception {
        long l = value2.asLong();
        if (l < 0L || l >= value.sizeDoubles()) {
            Fail.arrayBoundError();
        }
        return Value.createDouble(value.getDouble(l));
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"'a array", "int"}, returnType="'a")
    public static Value caml_array_get(Value value, Value value2) throws Fail.Exception {
        if (value.isDoubleArray()) {
            return Array.caml_array_get_float(value, value2);
        }
        return Array.caml_array_get_addr(value, value2);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"'a array", "int", "'a"}, returnType="unit")
    public static Value caml_array_set_addr(Value value, Value value2, Value value3) throws Fail.Exception {
        long l = value2.asLong();
        if (l < 0L || l >= value.sizeValues()) {
            Fail.arrayBoundError();
        }
        value.set(l, value3);
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"float array", "int", "float"}, returnType="unit")
    public static Value caml_array_set_float(Value value, Value value2, Value value3) throws Fail.Exception {
        long l = value2.asLong();
        if (l < 0L || l >= value.sizeDoubles()) {
            Fail.arrayBoundError();
        }
        value.setDouble(l, value3.asDouble());
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"'a array", "int", "'a"}, returnType="unit")
    public static Value caml_array_set(Value value, Value value2, Value value3) throws Fail.Exception {
        if (value.isDoubleArray()) {
            return Array.caml_array_set_float(value, value2, value3);
        }
        return Array.caml_array_set_addr(value, value2, value3);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"float array", "int"}, returnType="float")
    public static Value caml_array_unsafe_get_float(Value value, Value value2) {
        return Value.createDouble(value.getDouble(value2.asLong()));
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"'a array", "int"}, returnType="'a")
    public static Value caml_array_unsafe_get(Value value, Value value2) {
        if (value.isDoubleArray()) {
            return Array.caml_array_unsafe_get_float(value, value2);
        }
        return value.get(value2.asLong());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"'a array", "int", "'a"}, returnType="unit")
    public static Value caml_array_unsafe_set_addr(Value value, Value value2, Value value3) {
        value.set(value2.asLong(), value3);
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"'a array", "int", "'a"}, returnType="unit")
    public static Value caml_array_unsafe_set_float(Value value, Value value2, Value value3) {
        value.setDouble(value2.asLong(), value3.asDouble());
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"'a array", "int", "'a"}, returnType="unit")
    public static Value caml_array_unsafe_set(Value value, Value value2, Value value3) {
        if (value.isDoubleArray()) {
            return Array.caml_array_unsafe_set_float(value, value2, value3);
        }
        return Array.caml_array_unsafe_set_addr(value, value2, value3);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"int", "'a"}, returnType="'a array")
    public static Value caml_make_vect(Value value, Value value2) throws Fail.Exception {
        double d;
        long l;
        block5: {
            block6: {
                block4: {
                    l = value.asLong();
                    if (l == 0L) {
                        return CurrentContext.CODE_STATE.getAtom(0);
                    }
                    if (!value2.isDouble()) break block4;
                    d = value2.asDouble();
                    if (l * 1L <= 0x3FFFFFFFFFFFFFL) break block5;
                    break block6;
                }
                if (l > 0x3FFFFFFFFFFFFFL) {
                    Fail.invalidArgument("Array.make");
                }
                Value value3 = Value.createBlock(0, l);
                int n = 0;
                while ((long)n < l) {
                    value3.set(n, value2);
                    ++n;
                }
                return value3;
            }
            Fail.invalidArgument("Array.make");
        }
        Value value4 = Value.createDoubleArray(l);
        int n = 0;
        while ((long)n < l) {
            value4.setDouble(n, d);
            ++n;
        }
        return value4;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"'a array"}, returnType="'a array")
    public static Value caml_make_array(Value value) {
        long l = value.getWoSize();
        if (l == 0L) {
            return value;
        }
        Value value2 = value.get0();
        if (value2.isLong() || !value2.isDouble()) {
            return value;
        }
        Value value3 = Value.createDoubleArray(l);
        for (long i = 0L; i < l; ++i) {
            value3.setDouble(i, value.get(i).asDouble());
        }
        return value3;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"'a array", "int", "'a array", "int", "int"}, returnType="unit")
    public static Value caml_array_blit(Value value, Value value2, Value value3, Value value4, Value value5) {
        value.blitArray(value2.asLong(), value3, value4.asLong(), value5.asLong());
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"'a array", "int", "int"}, returnType="'a array")
    public static Value caml_array_sub(Value value, Value value2, Value value3) {
        return value.subArray(value2.asLong(), value3.asLong());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"'a array", "'a array"}, returnType="'a array")
    public static Value caml_array_append(Value value, Value value2) {
        return Array.concat(new Value[]{value, value2});
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"'a array list"}, returnType="'a array")
    public static Value caml_array_concat(Value value) {
        int n = 0;
        Value value2 = value;
        while (value2.isBlock()) {
            ++n;
            value2 = value2.get1();
        }
        Value[] valueArray = new Value[n];
        int n2 = 0;
        value2 = value;
        while (value2.isBlock()) {
            valueArray[n2++] = value2.get0();
            value2 = value2.get1();
        }
        return Array.concat(valueArray);
    }

    private static Value concat(Value[] valueArray) {
        boolean bl = false;
        boolean bl2 = true;
        long l = 0L;
        int n = valueArray.length;
        int n2 = 0;
        while (true) {
            block46: {
                Value value;
                block13: {
                    block14: {
                        block17: {
                            block16: {
                                block20: {
                                    block19: {
                                        block21: {
                                            block18: {
                                                block15: {
                                                    block12: {
                                                        if (n2 >= n) break block12;
                                                        value = valueArray[n2];
                                                        if (!value.isDoubleArray()) break block13;
                                                        break block14;
                                                    }
                                                    if (!bl) break block15;
                                                    if (l >= Value.MAX_INTEGER) break block16;
                                                    break block17;
                                                }
                                                if (!bl2) break block18;
                                                if (l >= Value.MAX_INTEGER) break block19;
                                                break block20;
                                            }
                                            if (l < Value.MAX_INTEGER) break block21;
                                            Value value2 = Value.createBlock(0, l);
                                            long l2 = 0L;
                                            int n3 = 0;
                                            while (true) {
                                                long l3;
                                                Value value3;
                                                block25: {
                                                    block23: {
                                                        block24: {
                                                            block22: {
                                                                if (n3 >= n) break block22;
                                                                value3 = valueArray[n3];
                                                                if (!value3.isDoubleArray()) break block23;
                                                                break block24;
                                                            }
                                                            return value2;
                                                        }
                                                        l3 = value3.sizeDoubles();
                                                        break block25;
                                                    }
                                                    l3 = value3.sizeValues();
                                                }
                                                long l4 = l3;
                                                for (long i = 0L; i < l4; ++i) {
                                                    value2.set(l2 + i, value3.get(i));
                                                }
                                                l2 += l4;
                                                ++n3;
                                            }
                                        }
                                        Value[] valueArray2 = new Value[(int)l];
                                        int n4 = 0;
                                        int n5 = 0;
                                        while (true) {
                                            long l5;
                                            long l6;
                                            block29: {
                                                Value value4;
                                                block27: {
                                                    block28: {
                                                        block26: {
                                                            if (n5 >= n) break block26;
                                                            value4 = valueArray[n5];
                                                            value4.copyValuesIntoArray(valueArray2, n4);
                                                            l6 = n4;
                                                            if (!value4.isDoubleArray()) break block27;
                                                            break block28;
                                                        }
                                                        return Value.createBlock(0, valueArray2);
                                                    }
                                                    l5 = value4.sizeDoubles();
                                                    break block29;
                                                }
                                                l5 = value4.sizeValues();
                                            }
                                            n4 = (int)(l6 + l5);
                                            ++n5;
                                        }
                                    }
                                    Value value5 = Value.createLongBlock(0, l);
                                    long l7 = 0L;
                                    int n6 = 0;
                                    while (true) {
                                        long l8;
                                        Value value6;
                                        block33: {
                                            block31: {
                                                block32: {
                                                    block30: {
                                                        if (n6 >= n) break block30;
                                                        value6 = valueArray[n6];
                                                        if (!value6.isLongBlock()) break block31;
                                                        break block32;
                                                    }
                                                    return value5;
                                                }
                                                l8 = value6.sizeLongs();
                                                break block33;
                                            }
                                            l8 = value6.sizeValues();
                                        }
                                        long l9 = l8;
                                        for (long i = 0L; i < l9; ++i) {
                                            value5.setRawLong(l7 + i, value6.getRawLong(i));
                                        }
                                        l7 += l9;
                                        ++n6;
                                    }
                                }
                                long[] lArray = new long[(int)l];
                                int n7 = 0;
                                int n8 = 0;
                                while (true) {
                                    long l10;
                                    long l11;
                                    block37: {
                                        Value value7;
                                        block35: {
                                            block36: {
                                                block34: {
                                                    if (n8 >= n) break block34;
                                                    value7 = valueArray[n8];
                                                    value7.copyRawLongsIntoArray(lArray, n7);
                                                    l11 = n7;
                                                    if (!value7.isLongBlock()) break block35;
                                                    break block36;
                                                }
                                                return Value.createLongBlock(0, lArray);
                                            }
                                            l10 = value7.sizeLongs();
                                            break block37;
                                        }
                                        l10 = value7.sizeValues();
                                    }
                                    n7 = (int)(l11 + l10);
                                    ++n8;
                                }
                            }
                            Value value8 = Value.createDoubleArray(l);
                            long l12 = 0L;
                            int n9 = 0;
                            while (true) {
                                long l13;
                                Value value9;
                                block41: {
                                    block39: {
                                        block40: {
                                            block38: {
                                                if (n9 >= n) break block38;
                                                value9 = valueArray[n9];
                                                if (!value9.isDoubleArray()) break block39;
                                                break block40;
                                            }
                                            return value8;
                                        }
                                        l13 = value9.sizeDoubles();
                                        break block41;
                                    }
                                    l13 = value9.sizeValues();
                                }
                                long l14 = l13;
                                for (long i = 0L; i < l14; ++i) {
                                    value8.setDouble(l12 + i, value9.getDouble(i));
                                }
                                l12 += l14;
                                ++n9;
                            }
                        }
                        double[] dArray = new double[(int)l];
                        int n10 = 0;
                        int n11 = 0;
                        while (true) {
                            long l15;
                            long l16;
                            block45: {
                                Value value10;
                                block43: {
                                    block44: {
                                        block42: {
                                            if (n11 >= n) break block42;
                                            value10 = valueArray[n11];
                                            value10.copyDoublesIntoArray(dArray, n10);
                                            l16 = n10;
                                            if (!value10.isDoubleArray()) break block43;
                                            break block44;
                                        }
                                        return Value.createDoubleArray(dArray);
                                    }
                                    l15 = value10.sizeDoubles();
                                    break block45;
                                }
                                l15 = value10.sizeValues();
                            }
                            n10 = (int)(l16 + l15);
                            ++n11;
                        }
                    }
                    bl = true;
                    bl2 = false;
                    l += value.sizeDoubles();
                    break block46;
                }
                if (value.isLongBlock()) {
                    l += value.sizeLongs();
                } else {
                    bl2 = false;
                    l += value.sizeValues();
                }
            }
            ++n2;
        }
    }
}

