/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank.chart;

import com.onemoonscientific.swank.GetValueOnEventThread;
import com.onemoonscientific.swank.SwkTableModel;
import com.onemoonscientific.swank.chart.XYData;
import java.awt.EventQueue;
import org.jfree.data.DomainOrder;
import org.jfree.data.xy.TableXYDataset;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclInteger;
import tcl.lang.TclList;
import tcl.lang.TclObject;

public class XYTableData
extends XYData
implements TableXYDataset {
    int xColumn = -1;
    int[] yColumns = new int[0];
    SwkTableModel tableModel = null;

    public XYTableData() {
        this.name = "xyData" + id;
        datasetMap.put(this.name, this);
        ++id;
    }

    public XYTableData(String name) {
        this.name = name;
        datasetMap.put(name, this);
    }

    public void setTableModel(SwkTableModel model) {
        if (EventQueue.isDispatchThread()) {
            this.setTableModelOnEventThread(model);
        } else {
            new SetModel().exec(model);
        }
    }

    public void setTableModelOnEventThread(SwkTableModel model) {
        this.tableModel = model;
        this.xColumn = -1;
        this.yColumns = new int[0];
    }

    public void setXColumn(int column) {
        this.xColumn = column;
    }

    public void setYColumns(Interp interp, TclObject columnArgs) throws TclException {
        TclObject[] columnObjects = TclList.getElements((Interp)interp, (TclObject)columnArgs);
        this.yColumns = new int[columnObjects.length];
        for (int i = 0; i < columnObjects.length; ++i) {
            int column;
            this.yColumns[i] = column = TclInteger.get((Interp)interp, (TclObject)columnObjects[i]);
        }
    }

    public void setYColumns(int[] columns) {
        this.yColumns = columns;
    }

    public int getSeriesCount() {
        return this.yColumns.length;
    }

    public String getSeriesName(int series) {
        if (series >= 0 && series < this.yColumns.length) {
            int yColumn = this.yColumns[series];
            return this.tableModel.getColumnName(yColumn);
        }
        return null;
    }

    public DomainOrder getDomainOrder() {
        return DomainOrder.NONE;
    }

    public int getItemCount(int series) {
        int nRows = 0;
        if (this.tableModel != null) {
            nRows = this.tableModel.getNRows();
        }
        return nRows;
    }

    public int getItemCount() {
        int nRows = 0;
        if (this.tableModel != null) {
            nRows = this.tableModel.getNRows();
        }
        return nRows;
    }

    public Comparable getSeriesKey(int series) {
        return this.getSeriesName(series);
    }

    public int indexOf(Comparable seriesKey) {
        int index = -1;
        for (int i = 0; i < this.yColumns.length; ++i) {
            if (!this.getSeriesName(i).equals(seriesKey.toString())) continue;
            index = i;
            break;
        }
        return index;
    }

    Number getNumber(Object obj) {
        Number result = null;
        if (obj instanceof Number) {
            result = (Number)obj;
        } else {
            try {
                result = Double.valueOf(obj.toString());
            }
            catch (NumberFormatException nfE) {
                result = null;
            }
        }
        return result;
    }

    public double getXValue(int series, int item) {
        double x = 0.0;
        if (this.xColumn < 0 || this.xColumn >= this.tableModel.getNCols()) {
            x = item;
        } else {
            Object xObject = this.tableModel.getValueAt(item, this.xColumn);
            if (xObject instanceof Number) {
                x = ((Number)xObject).doubleValue();
            }
        }
        return x;
    }

    public Number getX(int series, int item) {
        Number x = null;
        if (this.xColumn < 0 || this.xColumn >= this.tableModel.getNCols()) {
            x = item;
        } else {
            Object xObject = this.tableModel.getValueAt(item, this.xColumn);
            x = this.getNumber(xObject);
        }
        return x;
    }

    public double getYValue(int series, int item) {
        double y = 0.0;
        int yColumn = this.yColumns[series];
        if (yColumn < 0 || yColumn >= this.tableModel.getNCols()) {
            y = item;
        } else {
            Object yObject = this.tableModel.getValueAt(item, yColumn);
            if (yObject instanceof Number) {
                y = ((Number)yObject).doubleValue();
            }
        }
        return y;
    }

    public Number getY(int series, int item) {
        Number y = null;
        int yColumn = this.yColumns[series];
        if (yColumn >= 0 && yColumn < this.tableModel.getNCols()) {
            Object yObject = this.tableModel.getValueAt(item, yColumn);
            y = this.getNumber(yObject);
        }
        return y;
    }

    class SetModel
    extends GetValueOnEventThread {
        SwkTableModel model;

        SetModel() {
        }

        void exec(SwkTableModel model) {
            this.model = model;
            this.execOnThread();
        }

        public void run() {
            XYTableData.this.setTableModelOnEventThread(this.model);
        }
    }
}

