/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.context;

import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.ocamljava.runtime.context.Context;
import org.ocamljava.runtime.kernel.Channel;
import org.ocamljava.runtime.kernel.CodeRunner;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.FalseExit;
import org.ocamljava.runtime.kernel.Fatal;
import org.ocamljava.runtime.kernel.Misc;
import org.ocamljava.runtime.kernel.OCamlJavaException;
import org.ocamljava.runtime.values.AbstractCustomValue;
import org.ocamljava.runtime.values.BlockValue;
import org.ocamljava.runtime.values.Value;

public final class FinalizersState {
    private static final Field REFERENT = FinalizersState.initReferent();
    private final Context context;
    private final ReferenceQueue<BlockValue> unreachable;
    private final List<PhantomReference<BlockValue>> references;
    private final Map<Long, List<Infos>> infos;

    FinalizersState(Context context) {
        if ($assertionsDisabled || context != null) {
            this.context = context;
            this.unreachable = new ReferenceQueue();
            this.references = new LinkedList<PhantomReference<BlockValue>>();
            this.infos = new HashMap<Long, List<Infos>>();
            return;
        }
        throw new AssertionError((Object)"null ctxt");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Field initReferent() {
        try {
            Field field = Reference.class.getDeclaredField("referent");
            field.setAccessible(true);
            return field;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public synchronized void addFinalizer(BlockValue blockValue, Value value, CodeRunner codeRunner) {
        if ($assertionsDisabled || blockValue != null) {
            if ($assertionsDisabled || value != null) {
                if ($assertionsDisabled || codeRunner != null) {
                    Long l = new Long(blockValue.getMagicNumber());
                    List<Infos> list = this.infos.get(l);
                    if (list != null) {
                        list.add(new Infos(codeRunner, value));
                    } else {
                        LinkedList<Infos> linkedList = new LinkedList<Infos>();
                        linkedList.add(new Infos(codeRunner, value));
                        this.infos.put(l, linkedList);
                        this.references.add(new PhantomReference<BlockValue>(blockValue, this.unreachable));
                    }
                    return;
                }
                throw new AssertionError((Object)"null runner");
            }
            throw new AssertionError((Object)"null f");
        }
        throw new AssertionError((Object)"null b");
    }

    public synchronized void addFinalizer(BlockValue blockValue) {
        if ($assertionsDisabled || blockValue != null) {
            Long l = new Long(blockValue.getMagicNumber());
            List<Infos> list = this.infos.get(l);
            if (list == null) {
                this.infos.put(l, new LinkedList());
                this.references.add(new PhantomReference<BlockValue>(blockValue, this.unreachable));
            }
            return;
        }
        throw new AssertionError((Object)"null b");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public synchronized void runFinalizers() throws FalseExit {
        Reference<BlockValue> reference = this.unreachable.poll();
        while (reference != null) {
            BlockValue blockValue;
            try {
                blockValue = (BlockValue)REFERENT.get(reference);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace(System.err);
                blockValue = null;
            }
            if (blockValue != null) {
                Object object;
                BlockValue blockValue2 = (BlockValue)blockValue.duplicate();
                List<Infos> list = this.infos.remove(blockValue.getMagicNumber());
                if (blockValue2 instanceof AbstractCustomValue && (object = ((AbstractCustomValue)blockValue2).getCustomOperations()).isFinalized()) {
                    object.finalize(blockValue);
                }
                if (list != null) {
                    object = list.iterator();
                    while (object.hasNext()) {
                        Infos infos = (Infos)object.next();
                        this.runFinalizer(blockValue2, infos.function, infos.runner);
                    }
                }
                this.references.remove(reference);
            }
            reference = this.unreachable.poll();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private synchronized void runFinalizer(BlockValue blockValue, Value value, CodeRunner codeRunner) throws FalseExit {
        assert (blockValue != null) : "null b";
        assert (value != null) : "null f";
        assert (codeRunner != null) : "null runner";
        Context context = codeRunner.getContext();
        try {
            codeRunner.callback(value, blockValue);
            return;
        }
        catch (Fail.Exception exception) {
            Value value2 = context.getCodeState().getGlobalData();
            String string = Misc.convertException(exception.asValue(value2), value2);
            Channel channel = context.getFilesState().getChannel(2);
            Channel.tryWrite(channel, "Error in finalizer: exception " + string);
            return;
        }
        catch (Fatal.Exception | OCamlJavaException exception) {
            Channel channel = context.getFilesState().getChannel(2);
            Channel.tryWrite(channel, "Error in finalizer: exception " + exception.getMessage());
            return;
        }
    }

    private static final class Infos {
        private final CodeRunner runner;
        private final Value function;

        private Infos(CodeRunner codeRunner, Value value) {
            if ($assertionsDisabled || codeRunner != null) {
                if ($assertionsDisabled || value != null) {
                    this.runner = codeRunner;
                    this.function = value;
                    return;
                }
                throw new AssertionError((Object)"null f");
            }
            throw new AssertionError((Object)"null r");
        }
    }
}

