/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank.chart;

import com.onemoonscientific.swank.GetValueOnEventThread;
import com.onemoonscientific.swank.SwkTableModel;
import com.onemoonscientific.swank.chart.XYData;
import java.awt.EventQueue;
import org.jfree.data.DomainOrder;

public class XYTableStatsData
extends XYData {
    int xColumn = -1;
    int meanColumn = -1;
    int sDevColumn = -1;
    SwkTableModel tableModel = null;

    public XYTableStatsData() {
        this.name = "xyData" + id;
        datasetMap.put(this.name, this);
        ++id;
    }

    public XYTableStatsData(String name) {
        this.name = name;
        datasetMap.put(name, this);
    }

    public void setTableModel(SwkTableModel model) {
        if (EventQueue.isDispatchThread()) {
            this.setTableModelOnEventThread(model);
        } else {
            new SetModel().exec(model);
        }
    }

    public void setTableModelOnEventThread(SwkTableModel model) {
        this.tableModel = model;
        this.xColumn = -1;
        this.meanColumn = -1;
    }

    public void setXColumn(int column) {
        this.xColumn = column;
    }

    public void setMeanColumn(int column) {
        this.meanColumn = column;
    }

    public void setSDevColumn(int column) {
        this.sDevColumn = column;
    }

    public int getSeriesCount() {
        if (this.meanColumn != -1) {
            return 1;
        }
        return 0;
    }

    public String getSeriesName(int series) {
        if (this.meanColumn != -1) {
            return this.tableModel.getColumnName(this.meanColumn);
        }
        return null;
    }

    public DomainOrder getDomainOrder() {
        return DomainOrder.NONE;
    }

    public int getItemCount(int series) {
        int nRows = 0;
        if (this.tableModel != null) {
            nRows = this.tableModel.getNRows();
        }
        return nRows;
    }

    public int getItemCount() {
        int nRows = 0;
        if (this.tableModel != null) {
            nRows = this.tableModel.getNRows();
        }
        return nRows;
    }

    public Comparable getSeriesKey(int series) {
        return this.getSeriesName(series);
    }

    public int indexOf(Comparable seriesKey) {
        return this.ySeriesNames.indexOf(seriesKey);
    }

    Number getNumber(Object obj) {
        Number result = null;
        if (obj instanceof Number) {
            result = (Number)obj;
        } else {
            try {
                result = Double.valueOf(obj.toString());
            }
            catch (NumberFormatException nfE) {
                result = null;
            }
        }
        return result;
    }

    public double getXValue(int series, int item) {
        double x = 0.0;
        if (this.xColumn < 0 || this.xColumn >= this.tableModel.getNCols()) {
            x = item;
        } else {
            Object xObject = this.tableModel.getValueAt(item, this.xColumn);
            if (xObject instanceof Number) {
                x = ((Number)xObject).doubleValue();
            } else if (xObject instanceof String) {
                try {
                    x = Double.parseDouble((String)xObject);
                }
                catch (NumberFormatException nfE) {
                    // empty catch block
                }
            }
        }
        return x;
    }

    public Number getX(int series, int item) {
        Number x = null;
        if (this.xColumn < 0 || this.xColumn >= this.tableModel.getNCols()) {
            x = item;
        } else {
            Object xObject = this.tableModel.getValueAt(item, this.xColumn);
            x = this.getNumber(xObject);
        }
        return x;
    }

    public double getYValue(int series, int item) {
        return this.getMeanValue(series, item);
    }

    public Number getY(int series, int item) {
        return this.getMean(series, item);
    }

    public double getMeanValue(int series, int item) {
        double y = 0.0;
        if (this.meanColumn < 0 || this.meanColumn >= this.tableModel.getNCols()) {
            y = item;
        } else {
            Object yObject = this.tableModel.getValueAt(item, this.meanColumn);
            if (yObject instanceof Number) {
                y = ((Number)yObject).doubleValue();
            }
        }
        return y;
    }

    public Number getMean(int series, int item) {
        Number y = null;
        if (this.meanColumn >= 0 && this.meanColumn < this.tableModel.getNCols()) {
            Object yObject = this.tableModel.getValueAt(item, this.meanColumn);
            y = this.getNumber(yObject);
        }
        return y;
    }

    public double getSDevValue(int series, int item) {
        double y = 0.0;
        if (this.sDevColumn < 0 || this.sDevColumn >= this.tableModel.getNCols()) {
            y = item;
        } else {
            Object yObject = this.tableModel.getValueAt(item, this.sDevColumn);
            if (yObject instanceof Number) {
                y = ((Number)yObject).doubleValue();
            }
        }
        return y;
    }

    public Number getSDev(int series, int item) {
        Number y = null;
        if (this.sDevColumn >= 0 && this.sDevColumn < this.tableModel.getNCols()) {
            Object yObject = this.tableModel.getValueAt(item, this.sDevColumn);
            y = this.getNumber(yObject);
        }
        if (y == null) {
            y = new Double(0.0);
        }
        return y;
    }

    class SetModel
    extends GetValueOnEventThread {
        SwkTableModel model;

        SetModel() {
        }

        void exec(SwkTableModel model) {
            this.model = model;
            this.execOnThread();
        }

        public void run() {
            XYTableStatsData.this.setTableModelOnEventThread(this.model);
        }
    }
}

