/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank;

import com.onemoonscientific.swank.EventCmd;
import com.onemoonscientific.swank.SwkAppListener;
import com.onemoonscientific.swank.SwkBind;
import com.onemoonscientific.swank.SwkBinding;
import com.onemoonscientific.swank.SwkChangeListener;
import com.onemoonscientific.swank.SwkComponentListener;
import com.onemoonscientific.swank.SwkFocusListener;
import com.onemoonscientific.swank.SwkJFrame;
import com.onemoonscientific.swank.SwkJSlider;
import com.onemoonscientific.swank.SwkJTextPane;
import com.onemoonscientific.swank.SwkKeyListener;
import com.onemoonscientific.swank.SwkListListener;
import com.onemoonscientific.swank.SwkListSelectionListener;
import com.onemoonscientific.swank.SwkMouseListener;
import com.onemoonscientific.swank.SwkMouseMotionListener;
import com.onemoonscientific.swank.SwkWidget;
import com.onemoonscientific.swank.SwkWindowListener;
import com.onemoonscientific.swank.Widgets;
import com.onemoonscientific.swank.canvas.HitShape;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.ReflectObject;
import tcl.lang.SwkExceptionCmd;
import tcl.lang.TclException;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BindCmd
implements Command {
    public static Hashtable virtualTable = new Hashtable();
    public static Hashtable focusTable = new Hashtable();
    public static Hashtable configureTable = new Hashtable();
    public static Hashtable activationTable = new Hashtable();
    public static Hashtable keyTable = new Hashtable();
    public static Hashtable mouseTable = new Hashtable();
    public static Hashtable stateChangeTable = new Hashtable();
    public static Hashtable selectionChangeTable = new Hashtable();
    public static Hashtable appChangeTable = new Hashtable();
    public static Hashtable mouseMotionTable = new Hashtable();
    public static SwkAppListener swkAppListener = null;

    public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
        if (argv.length < 2) {
            throw new TclNumArgsException(interp, 1, argv, "option ?arg arg ...?");
        }
        String tag = argv[1].toString();
        if (argv.length == 2) {
            this.getBinding(interp, null, tag);
            return;
        }
        if (argv.length == 3) {
            SwkBinding binding = SwkBind.getBinding(interp, argv, 2);
            this.getBinding(interp, binding, tag);
            return;
        }
        SwkBinding binding = SwkBind.getBinding(interp, argv, 2);
        if (binding == null) {
            return;
        }
        if (binding.virtual) {
            Vector sequenceVec = EventCmd.getVirtualEvents(argv[2].toString());
            if (sequenceVec != null) {
                for (int i = 0; i < sequenceVec.size(); ++i) {
                    SwkBinding subBinding = (SwkBinding)sequenceVec.elementAt(i);
                    if (subBinding == null) continue;
                    SwkBind.updateBindingCommand(interp, subBinding, argv, 2);
                    this.addBinding(interp, subBinding, tag);
                }
            }
        } else {
            SwkBind.updateBindingCommand(interp, binding, argv, 2);
            this.addBinding(interp, binding, tag);
        }
    }

    void addBinding(Interp interp, SwkBinding binding, String tag) throws TclException {
        SwkWidget swkWidget = null;
        ArrayList<SwkBinding> bindingVector = null;
        Hashtable currentTable = null;
        if (tag.charAt(0) != '.') {
            if (binding.type == 1) {
                currentTable = focusTable;
            } else if (binding.type == 5) {
                currentTable = configureTable;
            } else if (binding.type == 17) {
                currentTable = activationTable;
            } else if (binding.type == 3) {
                currentTable = keyTable;
            } else if (binding.type == 2) {
                currentTable = mouseTable;
            } else if (binding.type == 4) {
                currentTable = mouseMotionTable;
            } else if (binding.type == 15) {
                currentTable = stateChangeTable;
            } else if (binding.type == 16) {
                currentTable = selectionChangeTable;
            } else if (binding.type == 8) {
                currentTable = appChangeTable;
            } else {
                throw new TclException(interp, "invalid binding type \"" + binding.type + "\" in bind cmd");
            }
            bindingVector = (ArrayList<SwkBinding>)currentTable.get(tag);
            if (bindingVector == null) {
                bindingVector = new ArrayList<SwkBinding>();
                currentTable.put(tag, bindingVector);
            }
        } else {
            TclObject tObj = (TclObject)Widgets.getWidget(interp, tag);
            if (tObj == null) {
                throw new TclException(interp, "bad window path name \"" + tag + "\"");
            }
            swkWidget = (SwkWidget)ReflectObject.get((Interp)interp, (TclObject)tObj);
            if (swkWidget == null) {
                throw new TclException(interp, "Can't find widget " + tObj.toString());
            }
        }
        BindCmd.setupBinding(interp, binding, swkWidget, bindingVector);
    }

    void getBinding(Interp interp, SwkBinding binding, String tag) throws TclException {
        SwkWidget swkWidget = null;
        ArrayList bindingVector = null;
        Hashtable currentTable = null;
        if (tag.charAt(0) != '.') {
            if (binding != null) {
                if (binding.type == 1) {
                    currentTable = focusTable;
                } else if (binding.type == 5) {
                    currentTable = configureTable;
                } else if (binding.type == 17) {
                    currentTable = activationTable;
                } else if (binding.type == 3) {
                    currentTable = keyTable;
                } else if (binding.type == 2) {
                    currentTable = mouseTable;
                } else if (binding.type == 4) {
                    currentTable = mouseMotionTable;
                } else if (binding.type == 15) {
                    currentTable = stateChangeTable;
                } else if (binding.type == 16) {
                    currentTable = selectionChangeTable;
                } else if (binding.type == 8) {
                    currentTable = appChangeTable;
                } else {
                    throw new TclException(interp, "invalid binding type \"" + binding.type + "\" in bind cmd");
                }
                bindingVector = (ArrayList)currentTable.get(tag);
                if (bindingVector == null) {
                    bindingVector = new ArrayList();
                    currentTable.put(tag, bindingVector);
                }
            }
        } else {
            TclObject tObj = (TclObject)Widgets.getWidget(interp, tag);
            if (tObj == null) {
                throw new TclException(interp, "bad window path name \"" + tag + "\"");
            }
            swkWidget = (SwkWidget)ReflectObject.get((Interp)interp, (TclObject)tObj);
            if (swkWidget == null) {
                throw new TclException(interp, "Can't find widget " + tObj.toString());
            }
        }
        if (binding == null) {
            if (tag.charAt(0) != '.') {
                BindCmd.getBindings(interp, tag);
            } else {
                BindCmd.getBindings(interp, swkWidget);
            }
        } else {
            BindCmd.setupBinding(interp, binding, swkWidget, bindingVector, true);
        }
    }

    public static ArrayList<SwkBinding> getMouseBindings(String tag) {
        ArrayList bindingVector = (ArrayList)mouseTable.get(tag);
        return bindingVector;
    }

    public static ArrayList<SwkBinding> getMouseMotionBindings(String tag) {
        ArrayList bindingVector = (ArrayList)mouseMotionTable.get(tag);
        return bindingVector;
    }

    public static ArrayList<SwkBinding> getKeyBindings(String tag) {
        ArrayList bindingVector = (ArrayList)keyTable.get(tag);
        return bindingVector;
    }

    public static ArrayList<SwkBinding> getFocusBindings(String tag) {
        ArrayList bindingVector = (ArrayList)focusTable.get(tag);
        return bindingVector;
    }

    public static ArrayList<SwkBinding> getActivationBindings(String tag) {
        ArrayList bindingVector = (ArrayList)activationTable.get(tag);
        return bindingVector;
    }

    public static ArrayList<SwkBinding> getVirtualBindings(String tag) {
        ArrayList bindingVector = (ArrayList)virtualTable.get(tag);
        return bindingVector;
    }

    public static void addDefaultListeners(Interp interp, SwkWidget swkWidget) {
        SwkKeyListener keyListener;
        if (swkWidget.getFocusListener() == null) {
            SwkFocusListener focusListener = new SwkFocusListener(interp, (Component)((Object)swkWidget));
            ((Component)((Object)swkWidget)).addFocusListener(focusListener);
            swkWidget.setFocusListener(focusListener);
        }
        if (swkWidget.getComponentListener() == null) {
            SwkComponentListener componentListener = new SwkComponentListener(interp, (Component)((Object)swkWidget));
            ((Component)((Object)swkWidget)).addComponentListener(componentListener);
            swkWidget.setComponentListener(componentListener);
        }
        if (swkWidget instanceof SwkJFrame && ((SwkJFrame)swkWidget).getWindowListener() == null) {
            SwkWindowListener windowListener = new SwkWindowListener(interp, (SwkJFrame)swkWidget);
            ((SwkJFrame)swkWidget).addWindowStateListener(windowListener);
            ((SwkJFrame)swkWidget).addWindowListener(windowListener);
            ((SwkJFrame)swkWidget).setWindowListener(windowListener);
        }
        if (swkWidget.getMouseListener() == null) {
            SwkMouseListener mouseListener = new SwkMouseListener(interp, (Component)((Object)swkWidget));
            if (swkWidget instanceof SwkJSlider) {
                SwkJSlider swkslider = (SwkJSlider)swkWidget;
                swkslider.getSlider().addMouseListener(mouseListener);
            } else {
                ((Component)((Object)swkWidget)).addMouseListener(mouseListener);
            }
            swkWidget.setMouseListener(mouseListener);
        }
        if (swkWidget.getMouseMotionListener() == null) {
            SwkMouseMotionListener mouseMotionListener = new SwkMouseMotionListener(interp, (Component)((Object)swkWidget));
            ((Component)((Object)swkWidget)).addMouseMotionListener(mouseMotionListener);
            swkWidget.setMouseListener(mouseMotionListener);
        }
        if (swkWidget instanceof JFrame) {
            if (swkWidget.getKeyListener() == null) {
                try {
                    keyListener = new SwkKeyListener(interp, (Component)((Object)swkWidget));
                    ((JFrame)((Object)swkWidget)).addKeyListener(keyListener);
                    swkWidget.setKeyListener(keyListener);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else if (swkWidget instanceof SwkJTextPane) {
            if (swkWidget.getKeyListener() == null) {
                keyListener = new SwkKeyListener(interp, (Component)((Object)swkWidget));
                ((Component)((Object)swkWidget)).addKeyListener(keyListener);
                swkWidget.setKeyListener(keyListener);
            }
        } else if (swkWidget instanceof JComponent && swkWidget.getKeyListener() == null) {
            keyListener = new SwkKeyListener(interp, (Component)((Object)swkWidget));
            ((JComponent)((Object)swkWidget)).addKeyListener(keyListener);
            swkWidget.setKeyListener(keyListener);
        }
    }

    public static void setupBinding(Interp interp, SwkBinding binding, SwkWidget swkWidget, ArrayList<SwkBinding> bindingVector) throws TclException {
        BindCmd.setupBinding(interp, binding, swkWidget, bindingVector, false);
    }

    public static void setupBinding(Interp interp, SwkBinding binding, SwkWidget swkWidget, ArrayList<SwkBinding> bindingVector, boolean queryBinding) throws TclException {
        if (binding.type == 8) {
            if (swkAppListener == null) {
                KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                swkAppListener = new SwkAppListener(interp);
                focusManager.addPropertyChangeListener(swkAppListener);
            }
            if (!queryBinding) {
                swkAppListener.setBinding(binding);
            }
        } else if (binding.type == 1) {
            if (swkWidget == null) {
                if (!queryBinding) {
                    BindCmd.setClassBinding(bindingVector, binding);
                }
            } else {
                if (swkWidget.getFocusListener() == null) {
                    SwkFocusListener focusListener = new SwkFocusListener(interp, (Component)((Object)swkWidget));
                    ((Component)((Object)swkWidget)).addFocusListener(focusListener);
                    swkWidget.setFocusListener(focusListener);
                }
                if (!queryBinding) {
                    swkWidget.getFocusListener().setBinding(binding);
                } else {
                    bindingVector = swkWidget.getFocusListener().getBindings();
                }
            }
        } else if (binding.type == 5) {
            if (swkWidget == null) {
                if (!queryBinding) {
                    BindCmd.setClassBinding(bindingVector, binding);
                }
            } else {
                if (swkWidget.getComponentListener() == null) {
                    SwkComponentListener componentListener = new SwkComponentListener(interp, (Component)((Object)swkWidget));
                    ((Component)((Object)swkWidget)).addComponentListener(componentListener);
                    swkWidget.setComponentListener(componentListener);
                }
                if (!queryBinding) {
                    swkWidget.getComponentListener().setBinding(binding);
                } else {
                    bindingVector = swkWidget.getComponentListener().getBindings();
                }
            }
        } else if (binding.type == 17) {
            if (swkWidget == null) {
                if (!queryBinding) {
                    BindCmd.setClassBinding(bindingVector, binding);
                }
            } else if (swkWidget instanceof SwkJFrame) {
                if (((SwkJFrame)swkWidget).getWindowListener() == null) {
                    SwkWindowListener windowListener = new SwkWindowListener(interp, (SwkJFrame)swkWidget);
                    ((SwkJFrame)swkWidget).addWindowStateListener(windowListener);
                    ((SwkJFrame)swkWidget).addWindowListener(windowListener);
                    ((SwkJFrame)swkWidget).setWindowListener(windowListener);
                }
                if (!queryBinding) {
                    ((SwkJFrame)swkWidget).getWindowListener().setBinding(binding);
                } else {
                    bindingVector = ((SwkJFrame)swkWidget).getWindowListener().getBindings();
                }
            }
        } else if (binding.type == 15) {
            if (swkWidget == null) {
                if (!queryBinding) {
                    BindCmd.setClassBinding(bindingVector, binding);
                }
            } else if (swkWidget instanceof JTabbedPane) {
                if (swkWidget.getChangeListener() == null) {
                    SwkChangeListener changeListener = new SwkChangeListener(interp, (Component)((Object)swkWidget));
                    ((JTabbedPane)((Object)swkWidget)).addChangeListener(changeListener);
                    swkWidget.setChangeListener(changeListener);
                }
                if (!queryBinding) {
                    swkWidget.getChangeListener().setBinding(binding);
                } else {
                    bindingVector = swkWidget.getChangeListener().getBindings();
                }
            }
        } else if (binding.type == 16) {
            if (swkWidget == null) {
                if (!queryBinding) {
                    BindCmd.setClassBinding(bindingVector, binding);
                }
            } else if (swkWidget instanceof SwkListListener) {
                SwkListListener swkListListener = (SwkListListener)((Object)swkWidget);
                if (swkListListener.getListSelectionListener() == null) {
                    SwkListSelectionListener selectionListener = new SwkListSelectionListener(interp, (Component)((Object)swkWidget));
                    swkListListener.getSelectionModel().addListSelectionListener(selectionListener);
                    swkListListener.setListSelectionListener(selectionListener);
                }
                if (!queryBinding) {
                    swkListListener.getListSelectionListener().setBinding(binding);
                } else {
                    bindingVector = swkListListener.getListSelectionListener().getBindings();
                }
            }
        } else if (binding.type == 2) {
            if (swkWidget == null) {
                if (!queryBinding) {
                    BindCmd.setClassBinding(bindingVector, binding);
                }
            } else {
                if (swkWidget.getMouseListener() == null) {
                    SwkMouseListener mouseListener = new SwkMouseListener(interp, (Component)((Object)swkWidget));
                    if (swkWidget instanceof SwkJSlider) {
                        SwkJSlider swkslider = (SwkJSlider)swkWidget;
                        swkslider.getSlider().addMouseListener(mouseListener);
                    } else {
                        ((Component)((Object)swkWidget)).addMouseListener(mouseListener);
                    }
                    swkWidget.setMouseListener(mouseListener);
                }
                if (!queryBinding) {
                    swkWidget.getMouseListener().setBinding(binding);
                } else {
                    bindingVector = swkWidget.getMouseListener().getBindings();
                }
            }
        } else if (binding.type == 4) {
            if (swkWidget == null) {
                if (!queryBinding) {
                    BindCmd.setClassBinding(bindingVector, binding);
                }
            } else {
                if (swkWidget.getMouseMotionListener() == null) {
                    SwkMouseMotionListener mouseMotionListener = new SwkMouseMotionListener(interp, (Component)((Object)swkWidget));
                    ((Component)((Object)swkWidget)).addMouseMotionListener(mouseMotionListener);
                    swkWidget.setMouseListener(mouseMotionListener);
                }
                if (!queryBinding) {
                    swkWidget.getMouseMotionListener().setBinding(binding);
                } else {
                    bindingVector = swkWidget.getMouseMotionListener().getBindings();
                }
            }
        } else if (binding.type == 3) {
            if (swkWidget == null) {
                if (!queryBinding) {
                    BindCmd.setClassBinding(bindingVector, binding);
                }
            } else if (swkWidget instanceof JFrame) {
                if (swkWidget.getKeyListener() == null) {
                    SwkKeyListener keyListener = new SwkKeyListener(interp, (Component)((Object)swkWidget));
                    ((Component)((Object)swkWidget)).addKeyListener(keyListener);
                    swkWidget.setKeyListener(keyListener);
                }
                if (!queryBinding) {
                    swkWidget.getKeyListener().setBinding(binding);
                } else {
                    bindingVector = swkWidget.getKeyListener().getBindings();
                }
            } else if (swkWidget instanceof SwkJTextPane) {
                if (swkWidget.getKeyListener() == null) {
                    SwkKeyListener keyListener = new SwkKeyListener(interp, (Component)((Object)swkWidget));
                    ((Component)((Object)swkWidget)).addKeyListener(keyListener);
                    swkWidget.setKeyListener(keyListener);
                }
                if (!queryBinding) {
                    swkWidget.getKeyListener().setBinding(binding);
                } else {
                    bindingVector = swkWidget.getKeyListener().getBindings();
                }
            } else if (swkWidget instanceof JComponent) {
                if (swkWidget.getKeyListener() == null) {
                    SwkKeyListener keyListener = new SwkKeyListener(interp, (Component)((Object)swkWidget));
                    ((JComponent)((Object)swkWidget)).addKeyListener(keyListener);
                    swkWidget.setKeyListener(keyListener);
                }
                if (!queryBinding) {
                    swkWidget.getKeyListener().setBinding(binding);
                } else {
                    bindingVector = swkWidget.getKeyListener().getBindings();
                }
            }
        }
        if (queryBinding) {
            BindCmd.getBindings(interp, binding, bindingVector);
        }
    }

    public static void getBindings(Interp interp, SwkBinding binding, ArrayList<SwkBinding> bindingVector) throws TclException {
        TclObject results = TclList.newInstance();
        for (SwkBinding swkBinding : bindingVector) {
            if (binding == null) {
                TclList.append((Interp)interp, (TclObject)results, (TclObject)TclString.newInstance((String)swkBinding.getEvent()));
                continue;
            }
            if (!binding.equals(swkBinding)) continue;
            interp.setResult(swkBinding.getCommand());
            return;
        }
        interp.setResult(results);
    }

    public static void getBindings(Interp interp, SwkWidget swkWidget) throws TclException {
        TclObject results = TclList.newInstance();
        ArrayList<ArrayList<SwkBinding>> bindingVectors = BindCmd.getBindings(swkWidget);
        for (ArrayList<SwkBinding> bindingVector : bindingVectors) {
            for (SwkBinding swkBinding : bindingVector) {
                TclList.append((Interp)interp, (TclObject)results, (TclObject)TclString.newInstance((String)swkBinding.getEvent()));
            }
        }
        interp.setResult(results);
    }

    public static void getBindings(Interp interp, String tag) throws TclException {
        TclObject results = TclList.newInstance();
        ArrayList<ArrayList<SwkBinding>> bindingVectors = BindCmd.getBindings(tag);
        for (ArrayList<SwkBinding> bindingVector : bindingVectors) {
            for (SwkBinding swkBinding : bindingVector) {
                TclList.append((Interp)interp, (TclObject)results, (TclObject)TclString.newInstance((String)swkBinding.getEvent()));
            }
        }
        interp.setResult(results);
    }

    public static ArrayList<ArrayList<SwkBinding>> getBindings(String tag) {
        ArrayList<Hashtable> currentTables = new ArrayList<Hashtable>();
        ArrayList<ArrayList<SwkBinding>> bindingVectors = new ArrayList<ArrayList<SwkBinding>>();
        currentTables.add(focusTable);
        currentTables.add(configureTable);
        currentTables.add(activationTable);
        currentTables.add(keyTable);
        currentTables.add(mouseTable);
        currentTables.add(mouseMotionTable);
        currentTables.add(stateChangeTable);
        currentTables.add(selectionChangeTable);
        currentTables.add(appChangeTable);
        for (Hashtable currentTable : currentTables) {
            ArrayList bindingVector = (ArrayList)currentTable.get(tag);
            if (bindingVector == null) continue;
            bindingVectors.add(bindingVector);
        }
        return bindingVectors;
    }

    public static ArrayList<ArrayList<SwkBinding>> getBindings(SwkWidget swkWidget) {
        SwkListListener swkListListener;
        ArrayList<SwkBinding> bindingVector = null;
        ArrayList<ArrayList<SwkBinding>> bindingVectors = new ArrayList<ArrayList<SwkBinding>>();
        if (swkWidget.getFocusListener() != null && (bindingVector = swkWidget.getFocusListener().getBindings()) != null) {
            bindingVectors.add(bindingVector);
        }
        if (swkWidget.getComponentListener() != null && (bindingVector = swkWidget.getComponentListener().getBindings()) != null) {
            bindingVectors.add(bindingVector);
        }
        if (swkWidget instanceof SwkJFrame && ((SwkJFrame)swkWidget).getWindowListener() != null && (bindingVector = ((SwkJFrame)swkWidget).getWindowListener().getBindings()) != null) {
            bindingVectors.add(bindingVector);
        }
        if (swkWidget.getChangeListener() != null && (bindingVector = swkWidget.getChangeListener().getBindings()) != null) {
            bindingVectors.add(bindingVector);
        }
        if (swkWidget instanceof SwkListListener && (swkListListener = (SwkListListener)((Object)swkWidget)).getListSelectionListener() != null && (bindingVector = swkListListener.getListSelectionListener().getBindings()) != null) {
            bindingVectors.add(bindingVector);
        }
        if (swkWidget.getMouseListener() != null && (bindingVector = swkWidget.getMouseListener().getBindings()) != null) {
            bindingVectors.add(bindingVector);
        }
        if (swkWidget.getMouseMotionListener() != null) {
            bindingVector = swkWidget.getMouseMotionListener().getBindings();
        }
        if (swkWidget.getKeyListener() != null && (bindingVector = swkWidget.getKeyListener().getBindings()) != null) {
            bindingVectors.add(bindingVector);
        }
        return bindingVectors;
    }

    public static void applyBindings(Interp interp, SwkWidget swkWidget, String className) throws TclException {
        int i;
        if (swkWidget == null) {
            throw new TclException(interp, "bad window path name ");
        }
        ArrayList bindingVector = (ArrayList)mouseTable.get(className);
        if (bindingVector != null) {
            for (i = 0; i < bindingVector.size(); ++i) {
                BindCmd.setupBinding(interp, (SwkBinding)bindingVector.get(i), swkWidget, bindingVector);
            }
        }
        if ((bindingVector = (ArrayList)mouseMotionTable.get(className)) != null) {
            for (i = 0; i < bindingVector.size(); ++i) {
                BindCmd.setupBinding(interp, (SwkBinding)bindingVector.get(i), swkWidget, bindingVector);
            }
        }
        if ((bindingVector = (ArrayList)keyTable.get(className)) != null) {
            for (i = 0; i < bindingVector.size(); ++i) {
                BindCmd.setupBinding(interp, (SwkBinding)bindingVector.get(i), swkWidget, bindingVector);
            }
        }
        if ((bindingVector = (ArrayList)focusTable.get(className)) != null) {
            for (i = 0; i < bindingVector.size(); ++i) {
                BindCmd.setupBinding(interp, (SwkBinding)bindingVector.get(i), swkWidget, bindingVector);
            }
        }
        if ((bindingVector = (ArrayList)activationTable.get(className)) != null) {
            for (i = 0; i < bindingVector.size(); ++i) {
                BindCmd.setupBinding(interp, (SwkBinding)bindingVector.get(i), swkWidget, bindingVector);
            }
        }
    }

    public static void doCmd(Interp interp, SwkBinding binding, Component component, ComponentEvent e) throws TclException {
        BindCmd.doCmd(interp, binding, component, (ActionEvent)null);
    }

    public static void doCmd(Interp interp, SwkBinding binding, Component component, ActionEvent e) throws TclException {
        StringBuffer sbuf = new StringBuffer();
        block9: for (int i = 0; i < binding.command.length(); ++i) {
            if (binding.command.charAt(i) != '%') {
                sbuf.append(binding.command.charAt(i));
                continue;
            }
            char type = binding.command.charAt(++i);
            switch (type) {
                case 'x': {
                    sbuf.append("0");
                    continue block9;
                }
                case 'y': {
                    sbuf.append("0");
                    continue block9;
                }
                case 'W': {
                    sbuf.append(component.getName());
                    continue block9;
                }
                case 'K': {
                    sbuf.append(binding.name);
                    continue block9;
                }
                case 'w': {
                    sbuf.append(component.getWidth());
                    continue block9;
                }
                case 'h': {
                    sbuf.append(component.getHeight());
                    continue block9;
                }
                case 's': {
                    if (!(component instanceof JTabbedPane)) continue block9;
                    sbuf.append(((JTabbedPane)component).getSelectedIndex());
                }
            }
        }
        SwkExceptionCmd.doExceptionCmd(interp, sbuf.toString());
    }

    public static void doCmd(Interp interp, String command, InputEvent e) throws TclException {
        BindCmd.doCmd(interp, command, e, null);
    }

    public static void doCmd(Interp interp, String command, InputEvent e, HitShape hitShape) throws TclException {
        StringBuffer sbuf = new StringBuffer();
        block16: for (int i = 0; i < command.length(); ++i) {
            int x = 0;
            int y = 0;
            Component comp = null;
            if (command.charAt(i) != '%') {
                sbuf.append(command.charAt(i));
                continue;
            }
            char type = command.charAt(++i);
            switch (type) {
                case 'b': {
                    if (e instanceof MouseEvent) {
                        MouseEvent mE = (MouseEvent)e;
                        switch (mE.getButton()) {
                            case 1: {
                                sbuf.append('1');
                                continue block16;
                            }
                            case 2: {
                                sbuf.append('2');
                                continue block16;
                            }
                            case 3: {
                                sbuf.append('3');
                                continue block16;
                            }
                        }
                        sbuf.append('0');
                        continue block16;
                    }
                    sbuf.append("??");
                    continue block16;
                }
                case 'd': {
                    if (hitShape != null && hitShape.getShape() != null) {
                        sbuf.append(hitShape.getShape().getId());
                        if (hitShape.getHandle() < 0) continue block16;
                        sbuf.append('.');
                        sbuf.append(hitShape.getHandle());
                        continue block16;
                    }
                    sbuf.append("??");
                    continue block16;
                }
                case 't': {
                    sbuf.append(System.currentTimeMillis());
                    continue block16;
                }
                case 'X': 
                case 'x': {
                    if (e instanceof MouseEvent) {
                        x = ((MouseEvent)e).getX();
                    } else {
                        comp = e.getComponent();
                        if (comp instanceof SwkWidget) {
                            x = ((SwkWidget)((Object)comp)).getMouseX();
                        }
                    }
                    if (type == 'X') {
                        x = (int)((double)x + e.getComponent().getLocationOnScreen().getX());
                    }
                    sbuf.append(x);
                    continue block16;
                }
                case 'Y': 
                case 'y': {
                    if (e instanceof MouseEvent) {
                        y = ((MouseEvent)e).getY();
                    } else {
                        comp = e.getComponent();
                        if (comp instanceof SwkWidget) {
                            y = ((SwkWidget)((Object)comp)).getMouseY();
                        }
                    }
                    if (type == 'Y') {
                        y = (int)((double)y + e.getComponent().getLocationOnScreen().getY());
                    }
                    sbuf.append(y);
                    continue block16;
                }
                case 'W': {
                    sbuf.append(e.getComponent().getName());
                    continue block16;
                }
                case 'k': {
                    if (e instanceof KeyEvent) {
                        sbuf.append(((KeyEvent)e).getKeyCode());
                        continue block16;
                    }
                    sbuf.append("??");
                    continue block16;
                }
                case 'K': {
                    if (!(e instanceof KeyEvent)) continue block16;
                    char ch = ((KeyEvent)e).getKeyChar();
                    if (ch != '\uffff' && !Character.isISOControl(ch) && !Character.isWhitespace(ch)) {
                        sbuf.append(ch);
                        continue block16;
                    }
                    int keyCode = ((KeyEvent)e).getKeyCode();
                    KeyEvent cfr_ignored_0 = (KeyEvent)e;
                    sbuf.append(KeyEvent.getKeyText(keyCode));
                    continue block16;
                }
                case 'A': {
                    if (!(e instanceof KeyEvent)) continue block16;
                    char keyChar = ((KeyEvent)e).getKeyChar();
                    if (keyChar == '{' || keyChar == '}') {
                        sbuf.append("\\" + keyChar);
                        continue block16;
                    }
                    if (keyChar == '\\') {
                        sbuf.append("\\\\");
                        continue block16;
                    }
                    sbuf.append("{" + keyChar + "}");
                    continue block16;
                }
                default: {
                    sbuf.append("??");
                }
            }
        }
        SwkExceptionCmd.doExceptionCmd(interp, sbuf.toString());
    }

    public static void setClassBinding(ArrayList<SwkBinding> bindings, SwkBinding newBinding) {
        SwkBind.setBinding(bindings, newBinding);
    }

    public static void setVirtualBinding(SwkWidget swkWidget, SwkBinding newBinding) {
        SwkBinding binding = null;
        ArrayList<SwkBinding> bindings = swkWidget.getVirtualBindings();
        if (bindings == null) {
            bindings = new ArrayList();
            swkWidget.setVirtualBindings(bindings);
        }
        if (!newBinding.add) {
            for (int i = 0; i < bindings.size(); ++i) {
                binding = bindings.get(i);
                if (!binding.equals(newBinding)) continue;
                bindings.set(i, newBinding);
                return;
            }
        }
        bindings.add(newBinding);
    }
}

