/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank;

import com.onemoonscientific.swank.BindEvent;
import com.onemoonscientific.swank.FocusCmd;
import com.onemoonscientific.swank.ResourceObject;
import com.onemoonscientific.swank.Setter;
import com.onemoonscientific.swank.SwankUtil;
import com.onemoonscientific.swank.SwkBinding;
import com.onemoonscientific.swank.SwkBorder;
import com.onemoonscientific.swank.SwkChangeListener;
import com.onemoonscientific.swank.SwkComponentListener;
import com.onemoonscientific.swank.SwkFocusListener;
import com.onemoonscientific.swank.SwkIndex;
import com.onemoonscientific.swank.SwkJLabelWidgetCmd;
import com.onemoonscientific.swank.SwkKeyCommandListener;
import com.onemoonscientific.swank.SwkKeyListener;
import com.onemoonscientific.swank.SwkMouseListener;
import com.onemoonscientific.swank.SwkMouseMotionListener;
import com.onemoonscientific.swank.SwkTextVariable;
import com.onemoonscientific.swank.SwkWidget;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.IllegalComponentStateException;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import tcl.lang.Interp;
import tcl.lang.TclBoolean;
import tcl.lang.TclEvent;
import tcl.lang.TclException;
import tcl.lang.TclInteger;
import tcl.lang.TclList;
import tcl.lang.TclObject;
import tcl.lang.TclString;
import tcl.lang.VarTrace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwkJLabel
extends JLabel
implements SwkWidget,
Printable,
VarTrace,
SwkTextVariable {
    static Hashtable resourceDB = null;
    String name = null;
    String className = null;
    LinkedList children = null;
    ArrayList<SwkBinding> virtualBindings = null;
    int active = 0;
    boolean created = false;
    TclObject tclObject = null;
    final Interp interp;
    Insets emptyBorderInsets = new Insets(0, 0, 0, 0);
    Vector tagList = new Vector();
    Dimension minimumSize = null;
    String jhelptarget = "";
    String state = "normal";
    int[] anchor = new int[]{0, 0};
    int borderWidth = 2;
    String bitmap;
    String bitmapName = "";
    Color disabledForeground;
    Color highlightBackground = Color.white;
    Color highlightColor = Color.red;
    int highlightThickness;
    String justify = "";
    int padx;
    int pady;
    String relief = null;
    String takeFocus = null;
    int underline;
    int wraplength;
    String xScrollCommand = null;
    String yScrollCommand = null;
    String textVariable = "";
    int swkwidth = 1;
    int swkheight = 1;
    private Insets insets = new Insets(0, 0, 0, 0);
    private int symbolSize = 0;
    SwkMouseListener mouseListener = null;
    SwkKeyListener keyListener = null;
    SwkKeyCommandListener keyCommandListener = null;
    SwkFocusListener focusListener = null;
    SwkComponentListener componentListener = null;
    SwkChangeListener changeListener = null;
    SwkMouseMotionListener mouseMotionListener = null;
    int mouseX = 0;
    int mouseY = 0;
    static String[] validCmds = new String[]{"-anchor", "-autoscrolls", "-background", "-bd", "-bg", "-bitmap", "-border", "-borderwidth", "-class", "-cursor", "-disabledforeground", "-disabledicon", "-enabled", "-fg", "-focusable", "-focuscycleroot", "-focustraversalkeysenabled", "-focustraversalpolicyprovider", "-font", "-foreground", "-height", "-highlightbackground", "-highlightcolor", "-highlightthickness", "-horizontaltextposition", "-icon", "-icontextgap", "-image", "-jhelptarget", "-justify", "-opaque", "-padx", "-pady", "-relief", "-requestfocusenabled", "-state", "-takefocus", "-text", "-textvariable", "-tooltiptext", "-underline", "-verifyinputwhenfocustarget", "-verticaltextposition", "-visible", "-width", "-wraplength", "-xscrollcommand", "-yscrollcommand"};
    private static final int OPT_ANCHOR = 0;
    private static final int OPT_AUTOSCROLLS = 1;
    private static final int OPT_BACKGROUND = 2;
    private static final int OPT_BD = 3;
    private static final int OPT_BG = 4;
    private static final int OPT_BITMAP = 5;
    private static final int OPT_BORDER = 6;
    private static final int OPT_BORDERWIDTH = 7;
    private static final int OPT_CLASS = 8;
    private static final int OPT_CURSOR = 9;
    private static final int OPT_DISABLEDFOREGROUND = 10;
    private static final int OPT_DISABLEDICON = 11;
    private static final int OPT_ENABLED = 12;
    private static final int OPT_FG = 13;
    private static final int OPT_FOCUSABLE = 14;
    private static final int OPT_FOCUSCYCLEROOT = 15;
    private static final int OPT_FOCUSTRAVERSALKEYSENABLED = 16;
    private static final int OPT_FOCUSTRAVERSALPOLICYPROVIDER = 17;
    private static final int OPT_FONT = 18;
    private static final int OPT_FOREGROUND = 19;
    private static final int OPT_HEIGHT = 20;
    private static final int OPT_HIGHLIGHTBACKGROUND = 21;
    private static final int OPT_HIGHLIGHTCOLOR = 22;
    private static final int OPT_HIGHLIGHTTHICKNESS = 23;
    private static final int OPT_HORIZONTALTEXTPOSITION = 24;
    private static final int OPT_ICON = 25;
    private static final int OPT_ICONTEXTGAP = 26;
    private static final int OPT_IMAGE = 27;
    private static final int OPT_JHELPTARGET = 28;
    private static final int OPT_JUSTIFY = 29;
    private static final int OPT_OPAQUE = 30;
    private static final int OPT_PADX = 31;
    private static final int OPT_PADY = 32;
    private static final int OPT_RELIEF = 33;
    private static final int OPT_REQUESTFOCUSENABLED = 34;
    private static final int OPT_STATE = 35;
    private static final int OPT_TAKEFOCUS = 36;
    private static final int OPT_TEXT = 37;
    private static final int OPT_TEXTVARIABLE = 38;
    private static final int OPT_TOOLTIPTEXT = 39;
    private static final int OPT_UNDERLINE = 40;
    private static final int OPT_VERIFYINPUTWHENFOCUSTARGET = 41;
    private static final int OPT_VERTICALTEXTPOSITION = 42;
    private static final int OPT_VISIBLE = 43;
    private static final int OPT_WIDTH = 44;
    private static final int OPT_WRAPLENGTH = 45;
    private static final int OPT_XSCROLLCOMMAND = 46;
    private static final int OPT_YSCROLLCOMMAND = 47;
    static TreeMap validCmdsTM = new TreeMap();

    public SwkJLabel(Interp interp, String name, String className) {
        this.name = name.intern();
        this.interp = interp;
        if (resourceDB == null) {
            resourceDB = new Hashtable();
            SwkJLabel.initResources();
        }
        this.setOpaque(true);
        this.setHorizontalAlignment(this.anchor[1]);
        this.setVerticalAlignment(this.anchor[0]);
        this.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent fEvent) {
                FocusCmd.setFocusWindow(SwkJLabel.this.getName());
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mEvent) {
                mEvent.getComponent().requestFocus();
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent mEvent) {
                SwkJLabel.this.mouseX = mEvent.getX();
                SwkJLabel.this.mouseY = mEvent.getY();
            }

            public void mouseDragged(MouseEvent mEvent) {
                SwkJLabel.this.mouseX = mEvent.getX();
                SwkJLabel.this.mouseY = mEvent.getY();
            }
        });
        this.tagList.add(name);
        this.tagList.add(className);
        this.tagList.add("swank");
        this.tagList.add("all");
    }

    public static void getWidgetOptions(Interp interp) throws TclException {
        TclObject result = TclList.newInstance();
        int n = validCmds.length;
        for (int i = 0; i < n; ++i) {
            TclList.append((Interp)interp, (TclObject)result, (TclObject)TclString.newInstance((String)validCmds[i]));
        }
        interp.setResult(result);
    }

    public static void getWidgetCmds(Interp interp) throws TclException {
        TclObject result = TclList.newInstance();
        String[] validCmds = SwkJLabelWidgetCmd.getValidCmds();
        int n = validCmds.length;
        for (int i = 0; i < n; ++i) {
            TclList.append((Interp)interp, (TclObject)result, (TclObject)TclString.newInstance((String)validCmds[i]));
        }
        interp.setResult(result);
    }

    @Override
    public int print(Graphics g, PageFormat pageFormat, int pageIndex) throws PrinterException {
        int result = 1;
        if (pageIndex == 0) {
            Graphics2D g2 = (Graphics2D)g;
            double pX = pageFormat.getImageableX();
            double pY = pageFormat.getImageableY();
            double pW = pageFormat.getImageableWidth();
            double pH = pageFormat.getImageableHeight();
            Dimension dimSize = this.getSize();
            double sx = 1.0;
            double sy = 1.0;
            if ((double)dimSize.width > pW) {
                sx = pW / (double)dimSize.width;
                sy = pW / (double)dimSize.width;
            }
            if ((double)dimSize.height * sx > pH) {
                sy = sx * pH / ((double)dimSize.height * sx);
                sx = sx * pH / ((double)dimSize.height * sx);
            }
            g2.translate(pX, pY);
            g2.scale(sx, sy);
            boolean wasBuffered = SwankUtil.disableDoubleBuffering(this);
            this.paint(g2);
            SwankUtil.restoreDoubleBuffering(this, wasBuffered);
            result = 0;
        }
        return result;
    }

    @Override
    public Vector getTagList() {
        return this.tagList;
    }

    @Override
    public void setTagList(Interp interp, TclObject tagListObj) throws TclException {
        TclObject[] tagObjs = TclList.getElements((Interp)interp, (TclObject)tagListObj);
        this.tagList.setSize(0);
        for (int i = 0; i < tagObjs.length; ++i) {
            this.tagList.add(tagObjs[i].toString());
        }
    }

    @Override
    public void setVirtualBindings(ArrayList<SwkBinding> bindings) {
        this.virtualBindings = bindings;
    }

    @Override
    public ArrayList<SwkBinding> getVirtualBindings() {
        return this.virtualBindings;
    }

    @Override
    public Insets getEmptyBorderInsets() {
        return this.emptyBorderInsets;
    }

    @Override
    public LinkedList getChildrenList() {
        return this.children;
    }

    @Override
    public void initChildrenList() {
        this.children = new LinkedList();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setJHelpTarget(String jhelptarget) {
        this.jhelptarget = jhelptarget;
        SwankUtil.setJHelpTarget(this, jhelptarget);
    }

    public String getJHelpTarget() {
        return this.jhelptarget;
    }

    public void setState(String value) {
        this.state = "normal";
        if ("normal".startsWith(value)) {
            this.state = "normal";
            this.setEnabled(true);
        } else if ("active".startsWith(value)) {
            this.state = "active";
            this.setEnabled(true);
        } else if ("disabled".startsWith(value)) {
            this.state = "disabled";
            this.setEnabled(false);
        } else {
            this.state = "normal";
        }
    }

    public String getState() {
        if (this.isEnabled()) {
            if (!this.state.equals("active") && !this.state.equals("normal")) {
                this.state = "normal";
            }
        } else {
            this.state = "disabled";
        }
        return this.state;
    }

    public void setAnchor(int[] anchor) {
        this.setVerticalAlignment(anchor[0]);
        this.setHorizontalAlignment(anchor[1]);
    }

    public String getAnchor() {
        int[] anchor = new int[]{this.getVerticalAlignment(), this.getHorizontalAlignment()};
        return SwankUtil.parseAnchorConstants(anchor);
    }

    public void setBorderWidth(double borderWidth) {
        this.borderWidth = (int)borderWidth;
        if (!(this.getBorder() instanceof SwkBorder)) {
            this.setBorder(new SwkBorder());
        }
    }

    @Override
    public int getBorderWidth() {
        return this.borderWidth;
    }

    public void setBitmap(ImageIcon icon, String name) {
        this.setIcon(icon);
        this.bitmapName = name;
    }

    public String getBitmap() {
        return this.bitmapName;
    }

    public void setDisabledForeground(Color disabledForeground) {
        this.disabledForeground = disabledForeground;
    }

    public Color getDisabledForeground() {
        return this.disabledForeground;
    }

    public void setHighlightBackground(Color highlightBackground) {
        this.highlightBackground = highlightBackground;
    }

    public Color getHighlightBackground() {
        return this.highlightBackground;
    }

    public void setHighlightColor(Color highlightColor) {
        this.highlightColor = highlightColor;
    }

    public Color getHighlightColor() {
        return this.highlightColor;
    }

    public void setHighlightThickness(int highlightThickness) {
        this.highlightThickness = highlightThickness;
    }

    public int getHighlightThickness() {
        return this.highlightThickness;
    }

    public void setJustify(String justify) {
        this.justify = justify;
        this.justify = "left".startsWith(justify) ? "left" : ("right".startsWith(justify) ? "right" : ("center".startsWith(justify) ? "center" : ""));
    }

    public String getJustify() {
        return this.justify;
    }

    public void setPadx(int padx) {
        this.emptyBorderInsets.left = this.padx = padx;
        this.emptyBorderInsets.right = this.padx;
        this.minimumSize = null;
    }

    public int getPadx() {
        return this.padx;
    }

    public void setPady(int pady) {
        this.emptyBorderInsets.top = this.pady = pady;
        this.emptyBorderInsets.bottom = this.pady;
        this.minimumSize = null;
    }

    public int getPady() {
        return this.pady;
    }

    public void setRelief(String relief) {
        if (!(this.getBorder() instanceof SwkBorder)) {
            this.setBorder(new SwkBorder());
        }
        this.relief = relief.intern();
    }

    @Override
    public String getRelief() {
        if (this.relief == null) {
            this.relief = "";
        }
        return this.relief;
    }

    public void setTakeFocus(String takeFocus) {
        this.takeFocus = takeFocus.intern();
    }

    public String getTakeFocus() {
        return this.takeFocus;
    }

    public void setUnderline(int underline) {
        this.underline = underline;
    }

    public int getUnderline() {
        return this.underline;
    }

    public void setWraplength(int wraplength) {
        this.wraplength = wraplength;
        this.minimumSize = null;
    }

    public int getWraplength() {
        return this.wraplength;
    }

    public void setXScrollCommand(String xScrollCommand) {
        this.xScrollCommand = xScrollCommand.intern();
    }

    public String getXScrollCommand() {
        return this.xScrollCommand;
    }

    public void setYScrollCommand(String yScrollCommand) {
        this.yScrollCommand = yScrollCommand.intern();
    }

    public String getYScrollCommand() {
        return this.yScrollCommand;
    }

    @Override
    public void setTextVariable(Interp interp, String name) throws TclException {
        String text = SwankUtil.setupTrace(interp, this, this.textVariable, name);
        this.textVariable = name;
        if (text != null) {
            new Setter(this, 37).exec(text);
        }
    }

    public void setSwkText(String value) {
        if (value != null && this.textVariable != null && !this.textVariable.equals("")) {
            BindEvent bEvent = new BindEvent(this.interp, this.textVariable, null, value);
            this.interp.getNotifier().queueEvent((TclEvent)bEvent, 0);
        }
        super.setText(value);
    }

    public String getSwkText() {
        return super.getText();
    }

    @Override
    public String getTextVariable() {
        return this.textVariable;
    }

    public void traceProc(Interp interp, String string1, String string2, int flags) throws TclException {
        TclObject tObj = interp.getVar(this.textVariable, 1);
        final String s = tObj.toString();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SwkJLabel.this.setText(s);
            }
        });
    }

    public void updateState() {
        if (!this.textVariable.equals("")) {
            try {
                TclObject varObj = this.interp.getVar(this.textVariable, 1);
                if (varObj != null) {
                    this.setText(varObj.toString());
                }
            }
            catch (TclException tclException) {
                // empty catch block
            }
        }
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.minimumSize = null;
    }

    @Override
    public void setText(String s) {
        super.setText(s);
        this.minimumSize = null;
    }

    @Override
    public void setIcon(Icon i) {
        super.setIcon(i);
        this.minimumSize = null;
    }

    public void setBorder(SwkBorder sb) {
        super.setBorder(sb);
        this.minimumSize = null;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = this.getMinimumSize();
        return size;
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.minimumSize == null) {
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            int charW = fontMetrics.charWidth('O');
            String s1 = this.getText();
            Dimension size = new Dimension(0, 0);
            ImageIcon icon = (ImageIcon)this.getIcon();
            if (s1.length() > 0 || icon == null) {
                size.height = (int)((double)(this.swkheight * fontMetrics.getHeight()) * 1.2);
                if (s1.length() > this.swkwidth) {
                    size.width = fontMetrics.stringWidth(s1) + charW;
                    if (this.wraplength > this.swkwidth * charW) {
                        size.width = this.wraplength + charW;
                        size.height = (int)((double)((fontMetrics.stringWidth(s1) / this.wraplength + 1) * fontMetrics.getHeight()) * 1.1);
                        if (!s1.startsWith("<html>")) {
                            this.setText("<html>" + s1 + "</html>");
                        }
                    }
                } else {
                    size.width = this.swkwidth * charW;
                }
            }
            if (icon != null) {
                size.width = icon.getIconWidth() > this.swkwidth ? (size.width += icon.getIconWidth()) : (size.width += this.swkwidth);
                size.height = icon.getIconHeight() > this.swkheight && icon.getIconHeight() > size.height ? icon.getIconHeight() : (icon.getIconHeight() > this.swkheight ? icon.getIconHeight() : this.swkheight);
            }
            this.insets = this.getInsets(this.insets);
            size.height += this.insets.top + this.insets.bottom;
            size.width += this.insets.left + this.insets.right;
            size.width += this.symbolSize;
            this.minimumSize = size;
        }
        return new Dimension(this.minimumSize);
    }

    public void setSwkHeight(int height) {
        this.swkheight = height;
    }

    public int getSwkHeight() {
        return this.swkheight;
    }

    public void setSwkWidth(int width) {
        this.swkwidth = width;
    }

    public int getSwkWidth() {
        return this.swkwidth;
    }

    @Override
    public boolean isCreated() {
        return this.created;
    }

    @Override
    public void setCreated(boolean state) {
        this.created = state;
    }

    @Override
    public int getMouseX() {
        return this.mouseX;
    }

    @Override
    public int getMouseY() {
        return this.mouseY;
    }

    @Override
    public SwkMouseListener getMouseListener() {
        return this.mouseListener;
    }

    @Override
    public void setMouseListener(SwkMouseListener mouseListener) {
        this.mouseListener = mouseListener;
    }

    @Override
    public SwkFocusListener getFocusListener() {
        return this.focusListener;
    }

    @Override
    public void setFocusListener(SwkFocusListener focusListener) {
        this.focusListener = focusListener;
    }

    @Override
    public SwkComponentListener getComponentListener() {
        return this.componentListener;
    }

    @Override
    public void setComponentListener(SwkComponentListener componentListener) {
        this.componentListener = componentListener;
    }

    @Override
    public SwkChangeListener getChangeListener() {
        return this.changeListener;
    }

    @Override
    public void setChangeListener(SwkChangeListener changeListener) {
        this.changeListener = changeListener;
    }

    @Override
    public SwkKeyListener getKeyListener() {
        return this.keyListener;
    }

    @Override
    public void setKeyListener(SwkKeyListener keyListener) {
        this.keyListener = keyListener;
    }

    public SwkKeyCommandListener getKeyCommandListener() {
        return this.keyCommandListener;
    }

    public void setKeyCommandListener(SwkKeyCommandListener keyCommandListener) {
        this.keyCommandListener = keyCommandListener;
    }

    @Override
    public SwkMouseMotionListener getMouseMotionListener() {
        return this.mouseMotionListener;
    }

    @Override
    public void setMouseListener(SwkMouseMotionListener mouseMotionListener) {
        this.mouseMotionListener = mouseMotionListener;
    }

    public void setClassName(String className) {
        this.className = className.intern();
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public void close() throws TclException {
        if (this.textVariable != null && this.textVariable.length() != 0) {
            this.interp.untraceVar(this.textVariable, (VarTrace)this, 33);
        }
    }

    void jgetAll(Interp interp) throws TclException {
        if (EventQueue.isDispatchThread()) {
            System.out.println("never  run on event thread");
        }
        JGetAll jgetAll = new JGetAll(this);
        try {
            SwingUtilities.invokeAndWait(jgetAll);
        }
        catch (InterruptedException iE) {
            throw new TclException(interp, iE.toString());
        }
        catch (Exception e) {
            throw new TclException(interp, e.toString());
        }
        this.getAllConfigurations(interp, jgetAll.roValues);
    }

    ArrayList getAllConfigurations() {
        int nCmds = validCmds.length;
        ArrayList<Object> results = new ArrayList<Object>();
        Enumeration e = resourceDB.keys();
        while (e.hasMoreElements()) {
            String keyName = (String)e.nextElement();
            ResourceObject ro = (ResourceObject)resourceDB.get(keyName);
            if (ro == null) continue;
            String value = this.jget(ro.optNum);
            results.add(keyName);
            results.add(ro);
            results.add(value);
        }
        return results;
    }

    void getAllConfigurations(Interp interp, ArrayList roValues) throws TclException {
        TclObject list2 = TclList.newInstance();
        int n = roValues.size();
        for (int i = 0; i < n; i += 3) {
            TclObject list1 = TclList.newInstance();
            String keyName = (String)roValues.get(i);
            ResourceObject ro = (ResourceObject)roValues.get(i + 1);
            String value = (String)roValues.get(i + 2);
            if (ro == null) continue;
            TclObject tObj = TclString.newInstance((String)keyName);
            TclList.append((Interp)interp, (TclObject)list1, (TclObject)tObj);
            TclList.append((Interp)interp, (TclObject)list1, (TclObject)TclString.newInstance((String)ro.resource));
            TclList.append((Interp)interp, (TclObject)list1, (TclObject)TclString.newInstance((String)ro.className));
            if (ro.defaultVal == null) {
                TclList.append((Interp)interp, (TclObject)list1, (TclObject)TclString.newInstance((String)""));
            } else {
                TclList.append((Interp)interp, (TclObject)list1, (TclObject)TclString.newInstance((String)ro.defaultVal));
            }
            if (value == null) {
                value = "";
            }
            TclList.append((Interp)interp, (TclObject)list1, (TclObject)TclString.newInstance((String)value));
            TclList.append((Interp)interp, (TclObject)list2, (TclObject)list1);
        }
        interp.setResult(list2);
    }

    @Override
    public void setValues(Setter setter, int opt) {
        switch (opt) {
            case 0: {
                this.setAnchor((int[])setter.oValue);
                break;
            }
            case 1: {
                this.setAutoscrolls(setter.bValue);
                break;
            }
            case 2: {
                this.setBackground((Color)setter.oValue);
                break;
            }
            case 3: {
                this.setBorderWidth(setter.dValue);
                break;
            }
            case 4: {
                this.setBackground((Color)setter.oValue);
                break;
            }
            case 5: {
                this.setBitmap((ImageIcon)setter.oValue, setter.sValue);
                break;
            }
            case 6: {
                this.setBorderWidth(setter.dValue);
                break;
            }
            case 7: {
                this.setBorderWidth(setter.dValue);
                break;
            }
            case 8: {
                this.setClassName(setter.sValue);
                break;
            }
            case 9: {
                this.setCursor((Cursor)setter.oValue);
                break;
            }
            case 10: {
                this.setDisabledForeground((Color)setter.oValue);
                break;
            }
            case 11: {
                this.setDisabledIcon((Icon)setter.oValue);
                break;
            }
            case 12: {
                this.setEnabled(setter.bValue);
                break;
            }
            case 13: {
                this.setForeground((Color)setter.oValue);
                break;
            }
            case 14: {
                this.setFocusable(setter.bValue);
                break;
            }
            case 15: {
                this.setFocusCycleRoot(setter.bValue);
                break;
            }
            case 16: {
                this.setFocusTraversalKeysEnabled(setter.bValue);
                break;
            }
            case 17: {
                this.setFocusTraversalPolicyProvider(setter.bValue);
                break;
            }
            case 18: {
                this.setFont((Font)setter.oValue);
                break;
            }
            case 19: {
                this.setForeground((Color)setter.oValue);
                break;
            }
            case 20: {
                this.setSwkHeight(setter.iValue);
                break;
            }
            case 21: {
                this.setHighlightBackground((Color)setter.oValue);
                break;
            }
            case 22: {
                this.setHighlightColor((Color)setter.oValue);
                break;
            }
            case 23: {
                this.setHighlightThickness(setter.iValue);
                break;
            }
            case 24: {
                this.setHorizontalTextPosition(setter.iValue);
                break;
            }
            case 25: {
                this.setIcon((Icon)setter.oValue);
                break;
            }
            case 26: {
                this.setIconTextGap(setter.iValue);
                break;
            }
            case 27: {
                this.setIcon((Icon)setter.oValue);
                break;
            }
            case 28: {
                this.setJHelpTarget(setter.sValue);
                break;
            }
            case 29: {
                this.setJustify(setter.sValue);
                break;
            }
            case 30: {
                this.setOpaque(setter.bValue);
                break;
            }
            case 31: {
                this.setPadx(setter.iValue);
                break;
            }
            case 32: {
                this.setPady(setter.iValue);
                break;
            }
            case 33: {
                this.setRelief(setter.sValue);
                break;
            }
            case 34: {
                this.setRequestFocusEnabled(setter.bValue);
                break;
            }
            case 35: {
                this.setState(setter.sValue);
                break;
            }
            case 36: {
                this.setTakeFocus(setter.sValue);
                break;
            }
            case 37: {
                this.setSwkText(setter.sValue);
                break;
            }
            case 38: {
                this.setYScrollCommand(setter.sValue);
                break;
            }
            case 39: {
                this.setToolTipText(setter.sValue);
                break;
            }
            case 40: {
                this.setUnderline(setter.iValue);
                break;
            }
            case 41: {
                this.setVerifyInputWhenFocusTarget(setter.bValue);
                break;
            }
            case 42: {
                this.setVerticalTextPosition(setter.iValue);
                break;
            }
            case 43: {
                this.setVisible(setter.bValue);
                break;
            }
            case 44: {
                this.setSwkWidth(setter.iValue);
                break;
            }
            case 45: {
                this.setWraplength(setter.iValue);
                break;
            }
            case 46: {
                this.setXScrollCommand(setter.sValue);
                break;
            }
            case 47: {
                this.setYScrollCommand(setter.sValue);
            }
        }
    }

    @Override
    public void configure(Interp interp, TclObject[] argv, int start) throws TclException {
        if (EventQueue.isDispatchThread()) {
            throw new RuntimeException("Configure on eventQueue");
        }
        if (argv.length <= start) {
            return;
        }
        ResourceObject ro = null;
        block50: for (int i = start; i < argv.length; i += 2) {
            if (i + 1 >= argv.length) {
                throw new TclException(interp, "value for \"" + argv[i].toString() + "\" missing");
            }
            ro = (ResourceObject)resourceDB.get(argv[i].toString());
            if (ro == null) {
                throw new TclException(interp, "unknown option \"" + argv[i].toString() + "\"");
            }
            int opt = SwkIndex.get(interp, argv[i], validCmdsTM, "option", 0);
            switch (opt) {
                case 0: {
                    int[] value = SwankUtil.getAnchorConstants(interp, argv[i + 1].toString());
                    new Setter(this, opt).exec(value);
                    continue block50;
                }
                case 1: {
                    boolean value = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block50;
                }
                case 2: {
                    Color value = SwankUtil.getColor(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block50;
                }
                case 3: {
                    double value = SwankUtil.getTkSizeD(interp, this, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block50;
                }
                case 4: {
                    Color value = SwankUtil.getColor(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block50;
                }
                case 5: {
                    ImageIcon value = SwankUtil.getImageIcon(interp, argv[i + 1]);
                    String sValue = argv[i + 1].toString();
                    new Setter(this, opt).exec(value, sValue);
                    continue block50;
                }
                case 6: {
                    double value = SwankUtil.getTkSizeD(interp, this, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block50;
                }
                case 7: {
                    double value = SwankUtil.getTkSizeD(interp, this, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block50;
                }
                case 8: {
                    String value = argv[i + 1].toString();
                    new Setter(this, opt).exec(value);
                    continue block50;
                }
                case 9: {
                    Cursor value = SwankUtil.getCursor(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block50;
                }
                case 10: {
                    Color value = SwankUtil.getColor(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block50;
                }
                case 11: {
                    ImageIcon value = SwankUtil.getImageIcon(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block50;
                }
                case 12: {
                    boolean value = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block50;
                }
                case 13: {
                    Color value = SwankUtil.getColor(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block50;
                }
                case 14: {
                    boolean value = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block50;
                }
                case 15: {
                    boolean value = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block50;
                }
                case 16: {
                    boolean value = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block50;
                }
                case 17: {
                    boolean value = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block50;
                }
                case 18: {
                    Font value = SwankUtil.getFont(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block50;
                }
                case 19: {
                    Color value = SwankUtil.getColor(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block50;
                }
                case 20: {
                    int value = TclInteger.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block50;
                }
                case 21: {
                    Color value = SwankUtil.getColor(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block50;
                }
                case 22: {
                    Color value = SwankUtil.getColor(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block50;
                }
                case 23: {
                    int value = SwankUtil.getTkSize(interp, (Component)this, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block50;
                }
                case 24: {
                    int value = TclInteger.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block50;
                }
                case 25: {
                    ImageIcon value = SwankUtil.getImageIcon(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block50;
                }
                case 26: {
                    int value = TclInteger.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block50;
                }
                case 27: {
                    ImageIcon value = SwankUtil.getImageIcon(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block50;
                }
                case 28: {
                    String value = argv[i + 1].toString();
                    new Setter(this, opt).exec(value);
                    continue block50;
                }
                case 29: {
                    String value = SwankUtil.getJustify(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block50;
                }
                case 30: {
                    boolean value = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block50;
                }
                case 31: {
                    int value = SwankUtil.getTkSize(interp, (Component)this, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block50;
                }
                case 32: {
                    int value = SwankUtil.getTkSize(interp, (Component)this, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block50;
                }
                case 33: {
                    String value = SwankUtil.getTkRelief(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block50;
                }
                case 34: {
                    boolean value = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block50;
                }
                case 35: {
                    String value = SwankUtil.getState(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block50;
                }
                case 36: {
                    String value = argv[i + 1].toString();
                    new Setter(this, opt).exec(value);
                    continue block50;
                }
                case 37: {
                    String value = argv[i + 1].toString();
                    new Setter(this, opt).exec(value);
                    continue block50;
                }
                case 38: {
                    this.setTextVariable(interp, argv[i + 1].toString());
                    continue block50;
                }
                case 39: {
                    String value = argv[i + 1].toString();
                    new Setter(this, opt).exec(value);
                    continue block50;
                }
                case 40: {
                    int value = TclInteger.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block50;
                }
                case 41: {
                    boolean value = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block50;
                }
                case 42: {
                    int value = TclInteger.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block50;
                }
                case 43: {
                    boolean value = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block50;
                }
                case 44: {
                    int value = TclInteger.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block50;
                }
                case 45: {
                    int value = SwankUtil.getTkSize(interp, (Component)this, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block50;
                }
                case 46: {
                    String value = argv[i + 1].toString();
                    new Setter(this, opt).exec(value);
                    continue block50;
                }
                case 47: {
                    String value = argv[i + 1].toString();
                    new Setter(this, opt).exec(value);
                    continue block50;
                }
            }
        }
        SwankUtil.doWait();
        this.repaint();
    }

    String jget(int opt) {
        switch (opt) {
            case 0: {
                return this.getAnchor();
            }
            case 1: {
                return String.valueOf(this.getAutoscrolls());
            }
            case 2: {
                return SwankUtil.parseColor(this.getBackground());
            }
            case 3: {
                return SwankUtil.parseTkSize(this.getBorderWidth());
            }
            case 4: {
                return SwankUtil.parseColor(this.getBackground());
            }
            case 6: {
                return SwankUtil.parseTkSize(this.getBorderWidth());
            }
            case 7: {
                return SwankUtil.parseTkSize(this.getBorderWidth());
            }
            case 8: {
                return this.getClassName();
            }
            case 9: {
                return SwankUtil.parseCursor(this.getCursor());
            }
            case 10: {
                return SwankUtil.parseColor(this.getDisabledForeground());
            }
            case 11: {
                return SwankUtil.parseImageIcon(this.getDisabledIcon());
            }
            case 12: {
                return this.isEnabled() ? "1" : "0";
            }
            case 13: {
                return SwankUtil.parseColor(this.getForeground());
            }
            case 14: {
                return this.isFocusable() ? "1" : "0";
            }
            case 15: {
                return this.isFocusCycleRoot() ? "1" : "0";
            }
            case 16: {
                return String.valueOf(this.getFocusTraversalKeysEnabled());
            }
            case 17: {
                return this.isFocusTraversalPolicyProvider() ? "1" : "0";
            }
            case 18: {
                return SwankUtil.parseFont(this.getFont());
            }
            case 19: {
                return SwankUtil.parseColor(this.getForeground());
            }
            case 20: {
                return Integer.toString(this.getSwkHeight());
            }
            case 21: {
                return SwankUtil.parseColor(this.getHighlightBackground());
            }
            case 22: {
                return SwankUtil.parseColor(this.getHighlightColor());
            }
            case 23: {
                return SwankUtil.parseTkSize(this.getHighlightThickness());
            }
            case 24: {
                return Integer.toString(this.getHorizontalTextPosition());
            }
            case 25: {
                return SwankUtil.parseImageIcon(this.getIcon());
            }
            case 26: {
                return Integer.toString(this.getIconTextGap());
            }
            case 27: {
                return SwankUtil.parseImageIcon(this.getIcon());
            }
            case 28: {
                return this.getJHelpTarget();
            }
            case 29: {
                return this.getJustify();
            }
            case 30: {
                return this.isOpaque() ? "1" : "0";
            }
            case 31: {
                return SwankUtil.parseTkSize(this.getPadx());
            }
            case 32: {
                return SwankUtil.parseTkSize(this.getPady());
            }
            case 33: {
                return SwankUtil.parseTkRelief(this.getRelief());
            }
            case 34: {
                return this.isRequestFocusEnabled() ? "1" : "0";
            }
            case 35: {
                return this.getState();
            }
            case 36: {
                return this.getTakeFocus();
            }
            case 37: {
                return this.getSwkText();
            }
            case 38: {
                return this.getTextVariable();
            }
            case 39: {
                return this.getToolTipText();
            }
            case 40: {
                return Integer.toString(this.getUnderline());
            }
            case 41: {
                return String.valueOf(this.getVerifyInputWhenFocusTarget());
            }
            case 42: {
                return Integer.toString(this.getVerticalTextPosition());
            }
            case 43: {
                return this.isVisible() ? "1" : "0";
            }
            case 44: {
                return Integer.toString(this.getSwkWidth());
            }
            case 45: {
                return SwankUtil.parseTkSize(this.getWraplength());
            }
            case 46: {
                return this.getXScrollCommand();
            }
            case 47: {
                return this.getYScrollCommand();
            }
        }
        return "";
    }

    String jget(Interp interp, TclObject arg) throws TclException {
        int opt = 0;
        try {
            opt = SwkIndex.get(interp, arg, validCmdsTM, "option", 0);
        }
        catch (TclException tclE) {
            throw new TclException(interp, "unknown option \"" + arg + "\"");
        }
        String result = "";
        if (!EventQueue.isDispatchThread()) {
            JGet jget = new JGet(this, opt);
            try {
                SwingUtilities.invokeAndWait(jget);
            }
            catch (InterruptedException iE) {
                throw new TclException(interp, iE.toString());
            }
            catch (Exception e) {
                throw new TclException(interp, e.toString());
            }
            result = jget.result;
        } else {
            result = this.jget(opt);
        }
        return result;
    }

    void setResourceDefaults() throws TclException {
        if (!EventQueue.isDispatchThread()) {
            ResourceDefaultsSetter resourceDefaultsSetter = new ResourceDefaultsSetter(this.interp, this);
            try {
                SwingUtilities.invokeAndWait(resourceDefaultsSetter);
            }
            catch (InterruptedException iE) {
                throw new TclException(this.interp, iE.toString());
            }
            catch (Exception e) {
                throw new TclException(this.interp, e.toString());
            }
        } else {
            this.setResourceDefaultsET();
        }
    }

    void setResourceDefaultsET() {
        Enumeration e = resourceDB.keys();
        while (e.hasMoreElements()) {
            ResourceObject ro;
            String keyName = (String)e.nextElement();
            if (keyName == null || (ro = (ResourceObject)resourceDB.get(keyName)) == null) continue;
            try {
                ro.defaultVal = this.jget(ro.optNum);
            }
            catch (IllegalComponentStateException icsE) {}
        }
    }

    private static void initResources() {
        ResourceObject resourceObject = null;
        resourceObject = new ResourceObject("anchor", "Anchor", 0);
        resourceDB.put("-anchor", resourceObject);
        resourceObject = new ResourceObject("autoscrolls", "Autoscrolls", 1);
        resourceDB.put("-autoscrolls", resourceObject);
        resourceObject = new ResourceObject("background", "Background", 2);
        resourceDB.put("-background", resourceObject);
        resourceObject = new ResourceObject("borderWidth", "BorderWidth", 3);
        resourceDB.put("-bd", resourceObject);
        resourceObject = new ResourceObject("background", "Background", 4);
        resourceDB.put("-bg", resourceObject);
        resourceObject = new ResourceObject("bitmap", "Bitmap", 5);
        resourceDB.put("-bitmap", resourceObject);
        resourceObject = new ResourceObject("borderWidth", "BorderWidth", 6);
        resourceDB.put("-border", resourceObject);
        resourceObject = new ResourceObject("borderWidth", "BorderWidth", 7);
        resourceDB.put("-borderwidth", resourceObject);
        resourceObject = new ResourceObject("className", "ClassName", 8);
        resourceDB.put("-class", resourceObject);
        resourceObject = new ResourceObject("cursor", "Cursor", 9);
        resourceDB.put("-cursor", resourceObject);
        resourceObject = new ResourceObject("disabledForeground", "DisabledForeground", 10);
        resourceDB.put("-disabledforeground", resourceObject);
        resourceObject = new ResourceObject("disabledIcon", "DisabledIcon", 11);
        resourceDB.put("-disabledicon", resourceObject);
        resourceObject = new ResourceObject("enabled", "Enabled", 12);
        resourceDB.put("-enabled", resourceObject);
        resourceObject = new ResourceObject("foreground", "Foreground", 13);
        resourceDB.put("-fg", resourceObject);
        resourceObject = new ResourceObject("focusable", "Focusable", 14);
        resourceDB.put("-focusable", resourceObject);
        resourceObject = new ResourceObject("focusCycleRoot", "FocusCycleRoot", 15);
        resourceDB.put("-focuscycleroot", resourceObject);
        resourceObject = new ResourceObject("focusTraversalKeysEnabled", "FocusTraversalKeysEnabled", 16);
        resourceDB.put("-focustraversalkeysenabled", resourceObject);
        resourceObject = new ResourceObject("focusTraversalPolicyProvider", "FocusTraversalPolicyProvider", 17);
        resourceDB.put("-focustraversalpolicyprovider", resourceObject);
        resourceObject = new ResourceObject("font", "Font", 18);
        resourceDB.put("-font", resourceObject);
        resourceObject = new ResourceObject("foreground", "Foreground", 19);
        resourceDB.put("-foreground", resourceObject);
        resourceObject = new ResourceObject("height", "Height", 20);
        resourceDB.put("-height", resourceObject);
        resourceObject = new ResourceObject("highlightBackground", "HighlightBackground", 21);
        resourceDB.put("-highlightbackground", resourceObject);
        resourceObject = new ResourceObject("highlightColor", "HighlightColor", 22);
        resourceDB.put("-highlightcolor", resourceObject);
        resourceObject = new ResourceObject("highlightThickness", "HighlightThickness", 23);
        resourceDB.put("-highlightthickness", resourceObject);
        resourceObject = new ResourceObject("horizontalTextPosition", "HorizontalTextPosition", 24);
        resourceDB.put("-horizontaltextposition", resourceObject);
        resourceObject = new ResourceObject("icon", "Icon", 25);
        resourceDB.put("-icon", resourceObject);
        resourceObject = new ResourceObject("iconTextGap", "IconTextGap", 26);
        resourceDB.put("-icontextgap", resourceObject);
        resourceObject = new ResourceObject("image", "Image", 27);
        resourceDB.put("-image", resourceObject);
        resourceObject = new ResourceObject("jHelpTarget", "JHelpTarget", 28);
        resourceDB.put("-jhelptarget", resourceObject);
        resourceObject = new ResourceObject("justify", "Justify", 29);
        resourceDB.put("-justify", resourceObject);
        resourceObject = new ResourceObject("opaque", "Opaque", 30);
        resourceDB.put("-opaque", resourceObject);
        resourceObject = new ResourceObject("padx", "Padx", 31);
        resourceDB.put("-padx", resourceObject);
        resourceObject = new ResourceObject("pady", "Pady", 32);
        resourceDB.put("-pady", resourceObject);
        resourceObject = new ResourceObject("relief", "Relief", 33);
        resourceDB.put("-relief", resourceObject);
        resourceObject = new ResourceObject("requestFocusEnabled", "RequestFocusEnabled", 34);
        resourceDB.put("-requestfocusenabled", resourceObject);
        resourceObject = new ResourceObject("state", "State", 35);
        resourceDB.put("-state", resourceObject);
        resourceObject = new ResourceObject("takeFocus", "TakeFocus", 36);
        resourceDB.put("-takefocus", resourceObject);
        resourceObject = new ResourceObject("text", "Text", 37);
        resourceDB.put("-text", resourceObject);
        resourceObject = new ResourceObject("textVariable", "TextVariable", 38);
        resourceDB.put("-textvariable", resourceObject);
        resourceObject = new ResourceObject("toolTipText", "ToolTipText", 39);
        resourceDB.put("-tooltiptext", resourceObject);
        resourceObject = new ResourceObject("underline", "Underline", 40);
        resourceDB.put("-underline", resourceObject);
        resourceObject = new ResourceObject("verifyInputWhenFocusTarget", "VerifyInputWhenFocusTarget", 41);
        resourceDB.put("-verifyinputwhenfocustarget", resourceObject);
        resourceObject = new ResourceObject("verticalTextPosition", "VerticalTextPosition", 42);
        resourceDB.put("-verticaltextposition", resourceObject);
        resourceObject = new ResourceObject("visible", "Visible", 43);
        resourceDB.put("-visible", resourceObject);
        resourceObject = new ResourceObject("width", "Width", 44);
        resourceDB.put("-width", resourceObject);
        resourceObject = new ResourceObject("wraplength", "Wraplength", 45);
        resourceDB.put("-wraplength", resourceObject);
        resourceObject = new ResourceObject("xScrollCommand", "XScrollCommand", 46);
        resourceDB.put("-xscrollcommand", resourceObject);
        resourceObject = new ResourceObject("yScrollCommand", "YScrollCommand", 47);
        resourceDB.put("-yscrollcommand", resourceObject);
    }

    static {
        for (int i = 0; i < validCmds.length; ++i) {
            validCmdsTM.put(validCmds[i], new Integer(i));
        }
    }

    class ResourceDefaultsSetter
    implements Runnable {
        Interp interp;
        SwkJLabel swkjlabel;

        ResourceDefaultsSetter(Interp interp, SwkJLabel swkjlabel) {
            this.interp = interp;
            this.swkjlabel = swkjlabel;
        }

        public void run() {
            SwkJLabel.this.setResourceDefaultsET();
        }
    }

    class JGet
    implements Runnable {
        SwkJLabel swkjlabel;
        int opt = 0;
        String result = "";

        JGet(SwkJLabel swkjlabel, int opt) {
            this.swkjlabel = swkjlabel;
            this.opt = opt;
        }

        public void run() {
            this.result = this.swkjlabel.jget(this.opt);
        }
    }

    class JGetAll
    implements Runnable {
        SwkJLabel swkjlabel;
        ArrayList roValues = null;

        JGetAll(SwkJLabel swkjlabel) {
            this.swkjlabel = swkjlabel;
        }

        public void run() {
            this.roValues = SwkJLabel.this.getAllConfigurations();
        }
    }
}

