/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.support.wrappers;

import java.util.Arrays;
import java.util.Iterator;
import org.ocamljava.runtime.support.wrappers.ToValue;
import org.ocamljava.runtime.values.Value;

public final class Array<T extends ToValue>
implements ToValue,
Iterable<T> {
    private final T[] value;

    public Array(T[] that) {
        assert (that != null) : "null that";
        this.value = that;
    }

    public T[] get() {
        return this.value;
    }

    public T getValue(int index) {
        return this.value[index];
    }

    public void setValue(int index, T v) {
        this.value[index] = v;
    }

    @Override
    public Iterator<T> iterator() {
        return Arrays.asList(this.value).iterator();
    }

    @Override
    public Value toValue() {
        int len = this.value.length;
        Value res = Value.createBlock(0, len);
        boolean allFloats = true;
        for (int i = 0; i < len; ++i) {
            Value v = this.value[i].toValue();
            allFloats = allFloats && v.isDouble();
            res.set(i, v);
        }
        if (allFloats && len > 0) {
            Value floatRes = Value.createDoubleArray(len);
            for (int i = 0; i < len; ++i) {
                floatRes.setDouble(i, res.get(i).asDouble());
            }
            return floatRes;
        }
        return res;
    }

    public int hashCode() {
        return Arrays.hashCode(this.value);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Array) {
            Array that = (Array)obj;
            return Arrays.equals(this.value, that.value);
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[|");
        boolean first = true;
        for (T e : this.value) {
            if (first) {
                first = false;
            } else {
                sb.append("; ");
            }
            sb.append(e.toString());
        }
        sb.append("|]");
        return sb.toString();
    }
}

