/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.unix;

import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.context.Context;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.FalseExit;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="unix", module="Unix", source="otherlibs/unix/select.c")
public final class Select {
    private Select() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Primitive(compatibility=PrimitiveCompatibility.PARTIAL, comment={"Does wait for given time if all descriptor lists are empty (as used by threads to emulate delay)."}, parameterTypes={"Unix.file_descr list", "Unix.file_descr list", "Unix.file_descr list", "float"}, returnType="Unix.file_descr list * Unix.file_descr list * Unix.file_descr list")
    public static Value unix_select(Value value, Value value2, Value value3, Value value4) throws FalseExit, Fail.Exception {
        Context context = CurrentContext.CONTEXT;
        if (value != Value.EMPTY_LIST) return Value.createBlock(0, value, value2, value3);
        if (value2 != Value.EMPTY_LIST) return Value.createBlock(0, value, value2, value3);
        if (value3 != Value.EMPTY_LIST) return Value.createBlock(0, value, value2, value3);
        double d = value4.asDouble();
        if (!(d > 0.0)) return Value.createBlock(0, value, value2, value3);
        try {
            Thread.sleep((long)(d * 1000.0));
            return Value.createBlock(0, value, value2, value3);
        }
        catch (InterruptedException interruptedException) {
            FalseExit falseExit = FalseExit.createFromContext(context);
            falseExit.fillInStackTrace();
            throw falseExit;
        }
    }
}

