/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.values;

import java.util.Arrays;
import org.ocamljava.runtime.kernel.Fatal;
import org.ocamljava.runtime.values.AbstractBasicBlockValue;
import org.ocamljava.runtime.values.BasicBlockValue0;
import org.ocamljava.runtime.values.BasicBlockValue1;
import org.ocamljava.runtime.values.BasicBlockValue2;
import org.ocamljava.runtime.values.BasicBlockValue3;
import org.ocamljava.runtime.values.BasicBlockValue4;
import org.ocamljava.runtime.values.BasicBlockValue5;
import org.ocamljava.runtime.values.BasicBlockValue6;
import org.ocamljava.runtime.values.BasicBlockValue7;
import org.ocamljava.runtime.values.BasicBlockValue8;
import org.ocamljava.runtime.values.BlockValue;
import org.ocamljava.runtime.values.CustomOperations;
import org.ocamljava.runtime.values.Value;

public final class BasicBlockValue
extends AbstractBasicBlockValue {
    private int sizeTagged;
    private int sizeMinusOneTagged;
    private Value sizeWrapped;
    private Value[] values;

    BasicBlockValue(int n, int n2) {
        super(n, n2);
        this.values = new Value[n2];
        this.sizeTagged = n2 << 1 | 1;
        this.sizeMinusOneTagged = n2 - 1 << 1 | 1;
        this.sizeWrapped = Value.createLong(n2);
        for (int i = 0; i < n2; ++i) {
            this.values[i] = Value.ZERO;
        }
    }

    BasicBlockValue(int n, Value[] valueArray) {
        super(n, valueArray.length);
        int n2 = valueArray.length;
        this.values = valueArray;
        this.sizeTagged = n2 << 1 | 1;
        this.sizeMinusOneTagged = n2 - 1 << 1 | 1;
        this.sizeWrapped = Value.createLong(n2);
    }

    @Override
    public Value get(long l) throws ArrayIndexOutOfBoundsException {
        return this.values[(int)l];
    }

    @Override
    public Value get(int n) throws ArrayIndexOutOfBoundsException {
        return this.values[n];
    }

    @Override
    public Value get0() {
        return this.values[0];
    }

    @Override
    public Value get1() {
        return this.values[1];
    }

    @Override
    public Value get2() {
        return this.values[2];
    }

    @Override
    public Value get3() {
        return this.values[3];
    }

    @Override
    public Value get4() {
        return this.values[4];
    }

    @Override
    public Value get5() {
        return this.values[5];
    }

    @Override
    public Value get6() {
        return this.values[6];
    }

    @Override
    public Value get7() {
        return this.values[7];
    }

    @Override
    public void set(long l, Value value) throws ArrayIndexOutOfBoundsException {
        if ($assertionsDisabled || value != null) {
            this.values[(int)l] = value;
            return;
        }
        throw new AssertionError((Object)"null x");
    }

    @Override
    public void set(int n, Value value) throws ArrayIndexOutOfBoundsException {
        if ($assertionsDisabled || value != null) {
            this.values[n] = value;
            return;
        }
        throw new AssertionError((Object)"null x");
    }

    @Override
    public void set0(Value value) {
        if ($assertionsDisabled || value != null) {
            this.values[0] = value;
            return;
        }
        throw new AssertionError((Object)"null x");
    }

    @Override
    public void set1(Value value) {
        if ($assertionsDisabled || value != null) {
            this.values[1] = value;
            return;
        }
        throw new AssertionError((Object)"null x");
    }

    @Override
    public void set2(Value value) {
        if ($assertionsDisabled || value != null) {
            this.values[2] = value;
            return;
        }
        throw new AssertionError((Object)"null x");
    }

    @Override
    public void set3(Value value) {
        if ($assertionsDisabled || value != null) {
            this.values[3] = value;
            return;
        }
        throw new AssertionError((Object)"null x");
    }

    @Override
    public void set4(Value value) {
        if ($assertionsDisabled || value != null) {
            this.values[4] = value;
            return;
        }
        throw new AssertionError((Object)"null x");
    }

    @Override
    public void set5(Value value) {
        if ($assertionsDisabled || value != null) {
            this.values[5] = value;
            return;
        }
        throw new AssertionError((Object)"null x");
    }

    @Override
    public void set6(Value value) {
        if ($assertionsDisabled || value != null) {
            this.values[6] = value;
            return;
        }
        throw new AssertionError((Object)"null x");
    }

    @Override
    public void set7(Value value) {
        if ($assertionsDisabled || value != null) {
            this.values[7] = value;
            return;
        }
        throw new AssertionError((Object)"null x");
    }

    @Override
    public long sizeValues() {
        return this.values.length;
    }

    @Override
    public long arrayLength() {
        return this.values.length;
    }

    @Override
    public long arrayLengthTagged() {
        return this.sizeTagged;
    }

    @Override
    public long arrayLengthMinusOneTagged() {
        return this.sizeMinusOneTagged;
    }

    @Override
    public Value arrayLengthWrapped() {
        return this.sizeWrapped;
    }

    @Override
    protected void truncateInstance(long l) {
        int n = (int)l;
        this.values = Arrays.copyOf(this.values, n);
        this.sizeTagged = n << 1 | 1;
        this.sizeMinusOneTagged = n - 1 << 1 | 1;
        this.sizeWrapped = Value.createLong(n);
    }

    @Override
    public void copy(BlockValue blockValue) {
        int n = (int)Math.min((long)this.values.length, blockValue.sizeValues());
        for (int i = 0; i < n; ++i) {
            this.values[i] = blockValue.get(i);
        }
    }

    @Override
    public BasicBlockValue duplicate() {
        int n = this.values.length;
        BasicBlockValue basicBlockValue = new BasicBlockValue(this.getTag(), n);
        System.arraycopy(this.values, 0, basicBlockValue.values, 0, n);
        return basicBlockValue;
    }

    @Override
    public void copyValuesIntoArray(Value[] valueArray) {
        System.arraycopy(this.values, 0, valueArray, 0, this.values.length);
    }

    @Override
    public void copyValuesIntoArray(Value[] valueArray, int n) {
        System.arraycopy(this.values, 0, valueArray, n, this.values.length);
    }

    @Override
    public void copyDoublesIntoArray(double[] dArray, int n) {
        int n2 = this.values.length;
        for (int i = 0; i < n2; ++i) {
            dArray[n + i] = this.values[i].asDouble();
        }
    }

    @Override
    public void copyRawLongsIntoArray(long[] lArray, int n) {
        int n2 = this.values.length;
        for (int i = 0; i < n2; ++i) {
            lArray[n + i] = this.values[i].getRawValue();
        }
    }

    @Override
    public Value subArray(long l, long l2) {
        int n = (int)l2;
        int n2 = (int)l;
        int n3 = this.getTag();
        switch (n) {
            case 0: {
                return new BasicBlockValue0(n3);
            }
            case 1: {
                return new BasicBlockValue1(n3, this.values[n2 + 0]);
            }
            case 2: {
                return new BasicBlockValue2(n3, this.values[n2 + 0], this.values[n2 + 1]);
            }
            case 3: {
                return new BasicBlockValue3(n3, this.values[n2 + 0], this.values[n2 + 1], this.values[n2 + 2]);
            }
            case 4: {
                return new BasicBlockValue4(n3, this.values[n2 + 0], this.values[n2 + 1], this.values[n2 + 2], this.values[n2 + 3]);
            }
            case 5: {
                return new BasicBlockValue5(n3, this.values[n2 + 0], this.values[n2 + 1], this.values[n2 + 2], this.values[n2 + 3], this.values[n2 + 4]);
            }
            case 6: {
                return new BasicBlockValue6(n3, this.values[n2 + 0], this.values[n2 + 1], this.values[n2 + 2], this.values[n2 + 3], this.values[n2 + 4], this.values[n2 + 5]);
            }
            case 7: {
                return new BasicBlockValue7(n3, this.values[n2 + 0], this.values[n2 + 1], this.values[n2 + 2], this.values[n2 + 3], this.values[n2 + 4], this.values[n2 + 5], this.values[n2 + 6]);
            }
            case 8: {
                return new BasicBlockValue8(n3, this.values[n2 + 0], this.values[n2 + 1], this.values[n2 + 2], this.values[n2 + 3], this.values[n2 + 4], this.values[n2 + 5], this.values[n2 + 6], this.values[n2 + 7]);
            }
        }
        Value[] valueArray = new Value[n];
        System.arraycopy(this.values, n2, valueArray, 0, n);
        return new BasicBlockValue(n3, valueArray);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void blitArray(long l, Value value, long l2, long l3) {
        if (value instanceof BasicBlockValue) {
            BasicBlockValue basicBlockValue = (BasicBlockValue)value;
            System.arraycopy(this.values, (int)l, basicBlockValue.values, (int)l2, (int)l3);
            return;
        }
        if (l2 >= l) {
            long l4 = l3 - 1L;
            while (l4 >= 0L) {
                value.set(l2 + l4, this.get(l + l4));
                --l4;
            }
            return;
        }
        long l5 = 0L;
        while (l5 < l3) {
            value.set(l2 + l5, this.get(l + l5));
            ++l5;
        }
    }

    public int hashCode() {
        int n = 0;
        int n2 = Math.min(32, this.values.length);
        for (int i = 0; i < n2; ++i) {
            n += this.values[i].hashCode();
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object instanceof BasicBlockValue) {
            BasicBlockValue basicBlockValue = (BasicBlockValue)object;
            return Arrays.equals(this.values, basicBlockValue.values);
        }
        return false;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("BasicBlockValue(");
        int n = this.values.length;
        int n2 = 0;
        while (true) {
            block2: {
                block3: {
                    block1: {
                        if (n2 >= n) break block1;
                        if (n2 <= 0) break block2;
                        break block3;
                    }
                    stringBuilder.append(")");
                    return stringBuilder.toString();
                }
                stringBuilder.append(", ");
            }
            stringBuilder.append(this.values[n2]);
            ++n2;
        }
    }

    @Override
    public void setParent(BlockValue blockValue) {
        assert (false) : "setParent(BlockValue) called on an instance of " + this.getClass();
    }

    @Override
    public BlockValue getParent() {
        assert (false) : "getParent() called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public CustomOperations getCustomOperations() {
        assert (false) : "getCustomOperations() called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public Object asCustom() {
        assert (false) : "asCustom() called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public void setCustom(Object object) {
        assert (false) : "setCustom(Object) called on an instance of " + this.getClass();
    }

    @Override
    public int asInt32() {
        assert (false) : "asInt32() called on an instance of " + this.getClass();
        return 0;
    }

    @Override
    public void setInt32(int n) {
        assert (false) : "setInt32(int) called on an instance of " + this.getClass();
    }

    @Override
    public long asInt64() {
        assert (false) : "asInt64() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public void setInt64(long l) {
        assert (false) : "setInt64(int) called on an instance of " + this.getClass();
    }

    @Override
    public long asNativeInt() {
        assert (false) : "asNativeInt() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public void setNativeInt(long l) {
        assert (false) : "setNativeInt(long) called on an instance of " + this.getClass();
    }

    @Override
    public int asCastedInt() {
        return -1;
    }

    @Override
    public int asBoundedInt() throws Fatal.Exception {
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public long getCode() {
        assert (this.getTag() == 247 || this.getTag() == 249) : "getCode() called on an instance of " + this.getClass();
        {
            return this.get0().asCodeOffset();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setCode(long l) {
        if ($assertionsDisabled || this.getTag() == 247 || this.getTag() == 249) {
            this.set0(Value.createCodeOffset(l));
            return;
        }
        throw new AssertionError((Object)("setCode(long) called on an instance of " + this.getClass()));
    }

    @Override
    public double asDouble() {
        assert (false) : "asDouble() called on an instance of " + this.getClass();
        return 0.0;
    }

    @Override
    public void setDouble(double d) {
        assert (false) : "setDouble(double) called on an instance of " + this.getClass();
    }

    @Override
    public Value getWeak(long l) throws ArrayIndexOutOfBoundsException {
        assert (false) : "getWeak(long) called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public void setWeak(long l, Value value) throws ArrayIndexOutOfBoundsException {
        assert (false) : "setWeak(long, Value) called on an instance of " + this.getClass();
    }

    @Override
    public long sizeWeakValues() {
        assert (false) : "sizeWeakValues() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public long sizeBytes() {
        assert (false) : "sizeBytes() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public long sizeBytesTagged() {
        assert (false) : "sizeBytesTagged() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public long sizeBytesMinusOneTagged() {
        assert (false) : "sizeBytesMinusOneTagged() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public Value sizeBytesWrapped() {
        assert (false) : "sizeBytesWrapped() called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public String asString() {
        assert (false) : "asString() called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public byte[] getBytes() {
        assert (false) : "getBytes() called on an instance of " + this.getClass();
        return new byte[0];
    }

    @Override
    public byte[] getBytesForModification() {
        assert (false) : "getBytesForModification() called on an instance of " + this.getClass();
        return new byte[0];
    }

    @Override
    public int[] getUnsignedBytes() {
        assert (false) : "getUnsignedBytes() called on an instance of " + this.getClass();
        return new int[0];
    }

    @Override
    public byte getByte(long l) throws ArrayIndexOutOfBoundsException {
        assert (false) : "getByte(long) called on an instance of " + this.getClass();
        return 0;
    }

    @Override
    public void setByte(long l, byte by) throws ArrayIndexOutOfBoundsException {
        assert (false) : "setByte(long, byte) called on an instance of " + this.getClass();
    }

    @Override
    public int getUnsignedByte(long l) throws ArrayIndexOutOfBoundsException {
        assert (false) : "getUnsignedByte(long) called on an instance of " + this.getClass();
        return 0;
    }

    @Override
    public void setUnsignedByte(long l, int n) throws ArrayIndexOutOfBoundsException {
        assert (false) : "setUnsignedByte(long, int) called on an instance of " + this.getClass();
    }

    @Override
    public void set(Value value, long l) throws ArrayIndexOutOfBoundsException {
        if ($assertionsDisabled || value != null) {
            this.values[(int)l] = value;
            return;
        }
        throw new AssertionError((Object)"null x");
    }

    @Override
    public long sizeLongs() {
        return this.values.length;
    }

    @Override
    public long sizeDoubles() {
        return this.values.length;
    }

    @Override
    public void setGenericDouble(int n, double d) throws ArrayIndexOutOfBoundsException {
        this.values[n] = Value.createDouble(d);
    }

    @Override
    public void setGenericDouble(long l, double d) throws ArrayIndexOutOfBoundsException {
        this.values[(int)l] = Value.createDouble(d);
    }

    @Override
    public double getGenericDouble(int n) throws ArrayIndexOutOfBoundsException {
        return this.values[n].asDouble();
    }

    @Override
    public double getGenericDouble(long l) throws ArrayIndexOutOfBoundsException {
        return this.values[(int)l].asDouble();
    }

    @Override
    public double getDouble(int n) throws ArrayIndexOutOfBoundsException {
        return this.values[n].asDouble();
    }

    @Override
    public double getDouble(long l) throws ArrayIndexOutOfBoundsException {
        return this.values[(int)l].asDouble();
    }

    @Override
    public void setDouble(int n, double d) throws ArrayIndexOutOfBoundsException {
        this.values[n] = Value.createDouble(d);
    }

    @Override
    public void setDouble(long l, double d) throws ArrayIndexOutOfBoundsException {
        this.values[(int)l] = Value.createDouble(d);
    }

    @Override
    public long getRawLong(int n) throws ArrayIndexOutOfBoundsException {
        return this.values[n].getRawValue();
    }

    @Override
    public long getRawLong(long l) throws ArrayIndexOutOfBoundsException {
        return this.values[(int)l].getRawValue();
    }

    @Override
    public void setRawLong(int n, long l) throws ArrayIndexOutOfBoundsException {
        this.values[n] = Value.createFromRawLong(l);
    }

    @Override
    public void setRawLong(long l, long l2) throws ArrayIndexOutOfBoundsException {
        this.values[(int)l] = Value.createFromRawLong(l2);
    }

    @Override
    public void setGenericDouble0(double d) {
        this.values[0] = Value.createDouble(d);
    }

    @Override
    public double getGenericDouble0() {
        return this.values[0].asDouble();
    }

    @Override
    public void setDouble0(double d) {
        this.values[0] = Value.createDouble(d);
    }

    @Override
    public double getDouble0() {
        return this.values[0].asDouble();
    }

    @Override
    public void setRawLong0(long l) {
        this.values[0] = Value.createFromRawLong(l);
    }

    @Override
    public long getRawLong0() {
        return this.values[0].getRawValue();
    }

    @Override
    public void setGenericDouble1(double d) {
        this.values[1] = Value.createDouble(d);
    }

    @Override
    public double getGenericDouble1() {
        return this.values[1].asDouble();
    }

    @Override
    public void setDouble1(double d) {
        this.values[1] = Value.createDouble(d);
    }

    @Override
    public double getDouble1() {
        return this.values[1].asDouble();
    }

    @Override
    public void setRawLong1(long l) {
        this.values[1] = Value.createFromRawLong(l);
    }

    @Override
    public long getRawLong1() {
        return this.values[1].getRawValue();
    }

    @Override
    public void setGenericDouble2(double d) {
        this.values[2] = Value.createDouble(d);
    }

    @Override
    public double getGenericDouble2() {
        return this.values[2].asDouble();
    }

    @Override
    public void setDouble2(double d) {
        this.values[2] = Value.createDouble(d);
    }

    @Override
    public double getDouble2() {
        return this.values[2].asDouble();
    }

    @Override
    public void setRawLong2(long l) {
        this.values[2] = Value.createFromRawLong(l);
    }

    @Override
    public long getRawLong2() {
        return this.values[2].getRawValue();
    }

    @Override
    public void setGenericDouble3(double d) {
        this.values[3] = Value.createDouble(d);
    }

    @Override
    public double getGenericDouble3() {
        return this.values[3].asDouble();
    }

    @Override
    public void setDouble3(double d) {
        this.values[3] = Value.createDouble(d);
    }

    @Override
    public double getDouble3() {
        return this.values[3].asDouble();
    }

    @Override
    public void setRawLong3(long l) {
        this.values[3] = Value.createFromRawLong(l);
    }

    @Override
    public long getRawLong3() {
        return this.values[3].getRawValue();
    }

    @Override
    public void setGenericDouble4(double d) {
        this.values[4] = Value.createDouble(d);
    }

    @Override
    public double getGenericDouble4() {
        return this.values[4].asDouble();
    }

    @Override
    public void setDouble4(double d) {
        this.values[4] = Value.createDouble(d);
    }

    @Override
    public double getDouble4() {
        return this.values[4].asDouble();
    }

    @Override
    public void setRawLong4(long l) {
        this.values[4] = Value.createFromRawLong(l);
    }

    @Override
    public long getRawLong4() {
        return this.values[4].getRawValue();
    }

    @Override
    public void setGenericDouble5(double d) {
        this.values[5] = Value.createDouble(d);
    }

    @Override
    public double getGenericDouble5() {
        return this.values[5].asDouble();
    }

    @Override
    public void setDouble5(double d) {
        this.values[5] = Value.createDouble(d);
    }

    @Override
    public double getDouble5() {
        return this.values[5].asDouble();
    }

    @Override
    public void setRawLong5(long l) {
        this.values[5] = Value.createFromRawLong(l);
    }

    @Override
    public long getRawLong5() {
        return this.values[5].getRawValue();
    }

    @Override
    public void setGenericDouble6(double d) {
        this.values[6] = Value.createDouble(d);
    }

    @Override
    public double getGenericDouble6() {
        return this.values[6].asDouble();
    }

    @Override
    public void setDouble6(double d) {
        this.values[6] = Value.createDouble(d);
    }

    @Override
    public double getDouble6() {
        return this.values[6].asDouble();
    }

    @Override
    public void setRawLong6(long l) {
        this.values[6] = Value.createFromRawLong(l);
    }

    @Override
    public long getRawLong6() {
        return this.values[6].getRawValue();
    }

    @Override
    public void setGenericDouble7(double d) {
        this.values[7] = Value.createDouble(d);
    }

    @Override
    public double getGenericDouble7() {
        return this.values[7].asDouble();
    }

    @Override
    public void setDouble7(double d) {
        this.values[7] = Value.createDouble(d);
    }

    @Override
    public double getDouble7() {
        return this.values[7].asDouble();
    }

    @Override
    public void setRawLong7(long l) {
        this.values[7] = Value.createFromRawLong(l);
    }

    @Override
    public long getRawLong7() {
        return this.values[7].getRawValue();
    }
}

