/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.values;

import java.util.concurrent.atomic.AtomicLong;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.values.Value;

public abstract class BlockValue
extends Value {
    public static final int TAG_CONS = 0;
    public static final long MAX_WOSIZE = 0x3FFFFFFFFFFFFFL;
    public static final int NUM_TAGS = 256;
    public static final int NO_SCAN_TAG = 251;
    public static final int FORWARD_TAG = 250;
    public static final int INFIX_TAG = 249;
    public static final int OBJECT_TAG = 248;
    public static final int CLOSURE_TAG = 247;
    public static final int LAZY_TAG = 246;
    public static final int ABSTRACT_TAG = 251;
    public static final int STRING_TAG = 252;
    public static final int DOUBLE_TAG = 253;
    public static final int DOUBLE_ARRAY_TAG = 254;
    public static final int CUSTOM_TAG = 255;
    public static final long DOUBLE_SIZE = 1L;
    static final long RAW = -1L;
    static final long LONG_OR_OFFSET = -1L;
    private static final AtomicLong NEXT_MAGIC_NUMBER = new AtomicLong();
    protected long header;
    private long magicNumber;

    BlockValue(int n, long l) {
        this.header = BlockValue.makeHeader(n, l);
        this.magicNumber = -1L;
    }

    @Override
    public final boolean isLong() {
        return false;
    }

    @Override
    public final boolean isCodeOffset() {
        return false;
    }

    @Override
    public boolean isMethodHandle() {
        return false;
    }

    @Override
    public final boolean isBlock() {
        return true;
    }

    @Override
    public boolean isDoubleArray() {
        return false;
    }

    @Override
    public boolean isLongBlock() {
        return false;
    }

    @Override
    public boolean isDouble() {
        return false;
    }

    @Override
    public final BlockValue asBlock() {
        return this;
    }

    @Override
    public final long asLong() {
        return -1L;
    }

    @Override
    public final long asCodeOffset() {
        return -1L;
    }

    @Override
    public final long getRawValue() {
        return -1L;
    }

    private static long makeHeader(int n, long l) {
        block3: {
            block5: {
                block4: {
                    block2: {
                        if ($assertionsDisabled) break block2;
                        if (l < 0L) break block3;
                        if (l > 0x3FFFFFFFFFFFFFL) break block3;
                    }
                    if ($assertionsDisabled) break block4;
                    if (n < 0) break block5;
                    if (n > 255) break block5;
                }
                return (l << 10) + (long)n;
            }
            throw new AssertionError((Object)"invalid tag");
        }
        throw new AssertionError((Object)"invalid wosize");
    }

    public static int tagFromHeader(long l) {
        return (int)(l & 0xFFL);
    }

    public static long wosizeFromHeader(long l) {
        return l >> 10;
    }

    @Override
    public final long getWoSize() {
        return BlockValue.wosizeFromHeader(this.header);
    }

    @Override
    public long sizeValues() {
        return BlockValue.wosizeFromHeader(this.header);
    }

    @Override
    public final long getHeader() {
        return this.header;
    }

    public void setHeader(long l) {
        this.header = l;
    }

    @Override
    public final int getTag() {
        return BlockValue.tagFromHeader(this.header);
    }

    @Override
    public final void setTag(int n) {
        this.setHeader(BlockValue.makeHeader(n, this.getWoSize()));
    }

    @Override
    public final synchronized long getMagicNumber() {
        if (this.magicNumber == -1L) {
            this.magicNumber = NEXT_MAGIC_NUMBER.getAndIncrement();
        }
        return this.magicNumber;
    }

    @Override
    public final Value offset(long l) {
        if (this.getTag() == 247 || this.getTag() == 248) {
            return this.get(l);
        }
        if (this.getTag() != 249) {
            assert (false) : "invalid block for offset";
            return null;
        }
        BlockValue blockValue = this.getParent();
        long l2 = blockValue.sizeValues();
        long l3 = 0L;
        while (true) {
            block9: {
                long l4;
                block8: {
                    if (l3 >= l2) break block8;
                    if (!blockValue.get(l3).isBlock()) break block9;
                    if (this != blockValue.get(l3)) break block9;
                }
                if ((l4 = l3 + l) == 0L) {
                    return blockValue;
                }
                return blockValue.get(l4);
            }
            ++l3;
        }
    }

    public final void truncate(long l) throws Fail.Exception {
        long l2;
        long l3 = this.getWoSize();
        int n = this.getTag();
        long l4 = l2 = n == 253 ? l * 1L : l;
        if (l2 <= 0L || l2 > l3) {
            Fail.invalidArgument("Obj.truncate");
        }
        if (l2 != l3) {
            this.setHeader(BlockValue.makeHeader(n, l2));
            this.truncateInstance(l2);
        }
    }

    @Override
    public final int switchTag() {
        return -this.getTag() - 1;
    }

    protected abstract void truncateInstance(long var1);

    public abstract void copy(BlockValue var1);
}

