/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.annotations.primitives;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.FalseExit;
import org.ocamljava.runtime.kernel.Fatal;
import org.ocamljava.runtime.kernel.OCamlJavaException;
import org.ocamljava.runtime.values.Value;

public final class Primitives {
    private static final String INVALID_PROVIDER = "'%s' is not a valid primive provider";
    private static final String PRIM_DEF_TWICE = "'%s' primive defined twice";
    private static final String NO_IMPLEMENTATION = "no implementation for '%s' primitive";
    private static final Class<PrimitiveProvider> PRIMITIVE_PROVIDER_ANNOT = PrimitiveProvider.class;
    private static final Class<Primitive> PRIMITIVE_ANNOT = Primitive.class;

    private Primitives() {
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    public static Method lookupPrimitive(String string, Class<?> ... classArray) throws OCamlJavaException {
        assert (string != null) : "null primName";
        assert (classArray != null) : "null classes";
        Class<?>[] classArray2 = classArray;
        int n = classArray2.length;
        int n2 = 0;
        block0: while (true) {
            if (n2 >= n) {
                throw new OCamlJavaException(String.format(NO_IMPLEMENTATION, string));
            }
            boolean bl = true;
            while (true) {
                int n3;
                Method[] methodArray;
                block11: {
                    block10: {
                        int n4;
                        block9: {
                            if (!bl || (bl = false)) break block9;
                            Class<?> clazz = classArray2[n2];
                            if (clazz.getAnnotation(PRIMITIVE_PROVIDER_ANNOT) == null) break block10;
                            methodArray = clazz.getDeclaredMethods();
                            n4 = methodArray.length;
                            n3 = 0;
                        }
                        if (n3 < n4) break block11;
                    }
                    ++n2;
                    continue block0;
                }
                Method method = methodArray[n3];
                if (method.getName().equals(string) && Primitives.checkMethod(method)) {
                    return method;
                }
                ++n3;
            }
            break;
        }
    }

    public static void loadAllPrimitives(Map<String, Method> map, Class<?> clazz) throws OCamlJavaException {
        block2: {
            block3: {
                String string;
                if (!$assertionsDisabled && map == null) break block2;
                if (!$assertionsDisabled && clazz == null) break block3;
                if (clazz.getAnnotation(PRIMITIVE_PROVIDER_ANNOT) == null) {
                    throw new OCamlJavaException(String.format(INVALID_PROVIDER, clazz.getName()));
                }
                Method[] methodArray = clazz.getDeclaredMethods();
                int n = methodArray.length;
                int n2 = 0;
                while (true) {
                    block5: {
                        Method method;
                        block6: {
                            block4: {
                                if (n2 >= n) break block4;
                                method = methodArray[n2];
                                string = method.getName();
                                if (!Primitives.checkMethod(method)) break block5;
                                break block6;
                            }
                            return;
                        }
                        if (map.put(string, method) != null) break;
                    }
                    ++n2;
                }
                throw new OCamlJavaException(String.format(PRIM_DEF_TWICE, string));
            }
            throw new AssertionError((Object)"null cl");
        }
        throw new AssertionError((Object)"null prims");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean checkMethod(Method method) {
        assert (method != null) : "null m";
        if (!Modifier.isStatic(method.getModifiers())) return false;
        if (method.getAnnotation(PRIMITIVE_ANNOT) == null) return false;
        if (!method.getReturnType().equals(Value.class)) return false;
        if (!Primitives.checkParameters(method.getParameterTypes())) return false;
        if (!Primitives.checkExceptions(method.getExceptionTypes())) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean checkParameters(Class<?>[] classArray) {
        assert (classArray != null) : "null types";
        int n = classArray.length;
        int n2 = 0;
        while (true) {
            if (n2 >= n || !Value.class.equals(classArray[n2])) {
                if (n2 != n) return false;
                if (n <= 0) return false;
                return true;
            }
            ++n2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    private static boolean checkExceptions(Class<?>[] classArray) {
        assert (classArray != null) : "null exceptions";
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> clazz = classArray[n2];
            if (!clazz.equals(Fail.Exception.class) && !clazz.equals(Fatal.Exception.class)) {
                if (!clazz.equals(FalseExit.class)) return false;
            }
            ++n2;
        }
        return true;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Class<?>[] getSPIClasses() {
        var0 = Thread.currentThread().getContextClassLoader();
        try {
            var1_1 = new LinkedList<Class<?>>();
            var2_3 = var0.getResources("META-INF/services/org.ocamljava.runtime.annotations.primitives.PrimitiveProvider");
            while (true) {
                if (!var2_3.hasMoreElements()) break;
                ** GOTO lbl12
                break;
            }
        }
        catch (IOException var1_2) {
            return new Class[0];
        }
        {
            var3_4 /* !! */  = new Class[var1_1.size()];
            return var1_1.toArray(var3_4 /* !! */ );
lbl12:
            // 1 sources

            var3_4 /* !! */  = var2_3.nextElement();
            var4_5 = Primitives.readClassNames((URL)var3_4 /* !! */ ).iterator();
            while (true) {
                if (!var4_5.hasNext()) ** continue;
                var5_6 = var4_5.next();
                try {
                    var1_1.add(Class.forName(var5_6));
                }
                catch (Throwable var6_7) {
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<String> readClassNames(URL uRL) {
        String string;
        BufferedReader bufferedReader;
        InputStreamReader inputStreamReader;
        assert (uRL != null) : "null url";
        LinkedList<String> linkedList = new LinkedList<String>();
        try {
            inputStreamReader = new InputStreamReader(uRL.openStream());
            bufferedReader = new BufferedReader(inputStreamReader);
            string = bufferedReader.readLine();
        }
        catch (IOException iOException) {
            return linkedList;
        }
        while (true) {
            if (string == null) {
                bufferedReader.close();
                inputStreamReader.close();
                return linkedList;
            }
            int n = string.indexOf(35);
            if (n != -1) {
                string = string.substring(0, n);
            }
            if ((string = string.trim()).length() != 0) {
                linkedList.add(string);
            }
            string = bufferedReader.readLine();
        }
    }
}

