/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.stdlib;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.kernel.Channel;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.FalseExit;
import org.ocamljava.runtime.primitives.stdlib.Sys;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="stdlib", module="Digest", source="byterun/md5.c")
public final class Md5 {
    private static final String ALGO = "MD5";
    private static final int BUFFER_SIZE = 65536;

    private Md5() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, comment={"Raises [Invalid_argument] if MD5 algorithm is not available."}, parameterTypes={"string", "int", "int"}, returnType="Digest.t")
    public static Value caml_md5_string(Value value, Value value2, Value value3) throws Fail.Exception {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(ALGO);
            messageDigest.update(value.getBytes(), value2.asCastedInt(), value3.asCastedInt());
            return Value.createString(messageDigest.digest());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Fail.invalidArgument("Digest.substring");
            return Value.UNIT;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Primitive(compatibility=PrimitiveCompatibility.FULL, comment={"Raises [Invalid_argument] if MD5 algorithm is not available."}, parameterTypes={"Pervasives.in_channel", "int"}, returnType="Digest.t")
    public static Value caml_md5_chan(Value value, Value value2) throws Fail.Exception, FalseExit {
        int n;
        MessageDigest messageDigest;
        Object object;
        byte[] byArray;
        block12: {
            try {
                int n2;
                byArray = new byte[65536];
                object = (Channel)value.asCustom();
                messageDigest = MessageDigest.getInstance(ALGO);
                int n3 = value2.asCastedInt();
                if (n3 < 0) {
                    n = ((Channel)object).read(byArray, 0, 65536);
                    break block12;
                }
                for (int i = n3; i > 0; i -= n2) {
                    n2 = ((Channel)object).read(byArray, 0, Math.min(65536, i));
                    if (n2 == -1) {
                        Fail.raiseEndOfFile();
                    }
                    messageDigest.update(byArray, 0, n2);
                }
                return Value.createString(messageDigest.digest());
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                Fail.invalidArgument("Digest.substring");
                return Value.UNIT;
            }
            catch (InterruptedIOException interruptedIOException) {
                object = FalseExit.createFromContext(CurrentContext.CONTEXT);
                ((Throwable)object).fillInStackTrace();
                throw object;
            }
            catch (IOException iOException) {
                Sys.sysError(null, iOException.toString());
                return Value.UNIT;
            }
        }
        while (n != -1) {
            messageDigest.update(byArray, 0, n);
            n = ((Channel)object).read(byArray, 0, 65536);
        }
        return Value.createString(messageDigest.digest());
    }
}

