/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.javalibs.concurrent;

import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.primitives.javalibs.concurrent.STMSlot;
import org.ocamljava.runtime.primitives.javalibs.concurrent.STMVariable;
import org.ocamljava.runtime.values.Value;

final class STMTransaction
implements Comparable<STMTransaction> {
    private static final AtomicInteger NEXT_ID = new AtomicInteger(0);
    private final int identifier = NEXT_ID.getAndIncrement();
    private final int readVersion;
    private final SortedMap<STMVariable, Value> writeSet;
    private final SortedSet<STMVariable> readSet;
    private boolean invalidated;

    STMTransaction(int n) {
        this.readVersion = n;
        this.writeSet = new TreeMap<STMVariable, Value>();
        this.readSet = new TreeSet<STMVariable>();
        this.invalidated = false;
    }

    long getReadVersion() {
        return this.readVersion;
    }

    Value readVariable(STMVariable sTMVariable) throws Fail.Exception {
        this.checkNotInvalidated();
        Value value = (Value)this.writeSet.get(sTMVariable);
        if (value != null) {
            return value;
        }
        Value value2 = sTMVariable.get();
        if (sTMVariable.getWriteLock().availablePermits() <= 0 || sTMVariable.getVersionNumber() > this.readVersion) {
            this.invalidate();
            STMTransaction.raiseRetry();
            return null;
        }
        this.readSet.add(sTMVariable);
        return value2;
    }

    void writeVariable(STMVariable sTMVariable, Value value) throws Fail.Exception {
        this.checkNotInvalidated();
        this.writeSet.put(sTMVariable, value);
    }

    void commit() throws Fail.Exception {
        for (STMVariable iterator2 : this.writeSet.keySet()) {
            iterator2.getWriteLock().acquireUninterruptibly(1);
        }
        int n = STMSlot.get().getGlobalVersionClock().incrementAndGet();
        Iterator iterator = this.readSet.iterator();
        while (true) {
            block10: {
                STMVariable sTMVariable;
                block8: {
                    block9: {
                        block7: {
                            if (!iterator.hasNext()) break block7;
                            sTMVariable = (STMVariable)iterator.next();
                            if (this.writeSet.keySet().contains(sTMVariable)) break block8;
                            break block9;
                        }
                        for (Map.Entry<STMVariable, Value> entry : this.writeSet.entrySet()) {
                            STMVariable sTMVariable2 = entry.getKey();
                            Value value = entry.getValue();
                            sTMVariable2.set(value, n);
                        }
                        for (STMVariable sTMVariable3 : this.writeSet.keySet()) {
                            sTMVariable3.getWriteLock().release();
                        }
                        this.invalidate();
                        return;
                    }
                    if (sTMVariable.getWriteLock().availablePermits() == 0) break block10;
                }
                if (sTMVariable.getVersionNumber() <= this.readVersion) continue;
            }
            for (STMVariable sTMVariable : this.writeSet.keySet()) {
                sTMVariable.getWriteLock().release();
            }
            this.invalidate();
            STMTransaction.raiseRetry();
        }
    }

    void invalidate() {
        this.invalidated = true;
        this.writeSet.clear();
        this.readSet.clear();
    }

    void checkNotInvalidated() throws Fail.Exception {
        if (this.invalidated) {
            Fail.failWith("Invalidated transaction");
        }
    }

    public int hashCode() {
        return this.identifier;
    }

    public boolean equals(Object object) {
        boolean bl;
        block3: {
            block1: {
                block2: {
                    block0: {
                        if (!(object instanceof STMTransaction)) break block0;
                        STMTransaction sTMTransaction = (STMTransaction)object;
                        if (sTMTransaction.identifier != this.identifier) break block1;
                        break block2;
                    }
                    return false;
                }
                bl = true;
                break block3;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    public int compareTo(STMTransaction sTMTransaction) {
        return Integer.compare(this.identifier, sTMTransaction.identifier);
    }

    static void raiseRetry() throws Fail.Exception {
        Value value = CurrentContext.CODE_STATE.getCallback("Concurrent.STM.Retry");
        if (value != null) {
            Fail.raiseWithConstant(value);
        } else {
            Fail.invalidArgument("Exception Concurrent.STM.Retry not initialized");
        }
    }
}

