/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.util;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;

public final class MemoryChannel
extends AbstractInterruptibleChannel
implements ReadableByteChannel,
SeekableByteChannel {
    private static final int TRANSFER_SIZE = 8192;
    private byte[] data;
    private int position;
    private byte[] buffer;
    private boolean open;
    private final Object readLock;

    public MemoryChannel(byte[] byArray) {
        if ($assertionsDisabled || byArray != null) {
            this.data = byArray;
            this.position = 0;
            this.buffer = new byte[0];
            this.open = true;
            this.readLock = new Object();
            return;
        }
        throw new AssertionError((Object)"null b");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int read(ByteBuffer byteBuffer) throws IOException {
        int n = byteBuffer.remaining();
        int n2 = 0;
        int n3 = 0;
        if (this.position >= this.data.length) {
            return -1;
        }
        Object object = this.readLock;
        synchronized (object) {
            while (true) {
                block16: {
                    block14: {
                        boolean bl;
                        block15: {
                            block13: {
                                if (n2 >= n) break block14;
                                int n4 = Math.min(n - n2, 8192);
                                if (this.buffer.length < n4) {
                                    this.buffer = new byte[n4];
                                }
                                if (n2 > 0 && this.position >= this.data.length) break block14;
                                try {
                                    this.begin();
                                    int n5 = Math.min(this.data.length - this.position, n4);
                                    System.arraycopy(this.data, this.position, this.buffer, 0, n5);
                                    this.position += n5;
                                    n3 = n5;
                                    if (n3 <= 0) break block13;
                                }
                                catch (Throwable throwable) {
                                    this.end(n3 > 0);
                                    throw throwable;
                                }
                                bl = true;
                                break block15;
                            }
                            bl = false;
                        }
                        this.end(bl);
                        if (n3 >= 0) break block16;
                    }
                    if (n3 < 0 && n2 == 0) {
                        return -1;
                    }
                    return n2;
                }
                n2 += n3;
                byteBuffer.put(this.buffer, 0, n3);
            }
        }
    }

    @Override
    public int write(ByteBuffer byteBuffer) throws IOException {
        throw new IOException("org.ocamljava.runtime.util.MemoryChannel does not support the write operation");
    }

    @Override
    public long position() throws IOException {
        return this.position;
    }

    @Override
    public SeekableByteChannel position(long l) throws IOException {
        this.position = (int)l;
        return this;
    }

    @Override
    public long size() throws IOException {
        return this.data.length;
    }

    @Override
    public SeekableByteChannel truncate(long l) throws IOException {
        if (l < (long)this.data.length) {
            int n = (int)l;
            byte[] byArray = new byte[n];
            System.arraycopy(this.data, 0, byArray, 0, n);
            this.data = byArray;
        }
        return this;
    }

    @Override
    protected void implCloseChannel() throws IOException {
        this.open = false;
    }
}

