/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.support.wrappers;

import java.awt.Canvas;
import java.awt.Frame;
import java.awt.image.BufferedImage;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.ocamljava.runtime.kernel.Interpreter;
import org.ocamljava.runtime.primitives.otherlibs.graph.CustomImage;
import org.ocamljava.runtime.primitives.otherlibs.graph.GraphSlot;
import org.ocamljava.runtime.values.Value;

public final class Helpers {
    private Helpers() {
    }

    public static Value createInt(long l) {
        block3: {
            block2: {
                if ($assertionsDisabled) break block2;
                if (l < -4611686018427387904L) break block3;
                if (l > 0x3FFFFFFFFFFFFFFFL) break block3;
            }
            return Value.createLong(l);
        }
        throw new AssertionError((Object)"invalid x");
    }

    public static long readInt(Value value) {
        assert (value != null) : "null x";
        {
            return value.asLong();
        }
    }

    public static Value createInt32(int n) {
        return Value.createInt32(n);
    }

    public static int readInt32(Value value) {
        assert (value != null) : "null x";
        {
            return value.asInt32();
        }
    }

    public static Value createNativeInt(long l) {
        return Value.createNativeInt(l);
    }

    public static long readNativeInt(Value value) {
        assert (value != null) : "null x";
        {
            return value.asNativeInt();
        }
    }

    public static Value createInt64(long l) {
        return Value.createInt64(l);
    }

    public static long readInt64(Value value) {
        assert (value != null) : "null x";
        {
            return value.asInt64();
        }
    }

    public static Value createFloat(double d) {
        return Value.createDouble(d);
    }

    public static double readFloat(Value value) {
        assert (value != null) : "null x";
        {
            return value.asDouble();
        }
    }

    public static Value createString(String string) {
        assert (string != null) : "null x";
        {
            return Value.createString(string);
        }
    }

    public static String readString(Value value) {
        assert (value != null) : "null x";
        {
            return value.asString();
        }
    }

    public static Value createFloatArray(double ... dArray) {
        assert (dArray != null) : "null x";
        {
            return Value.createDoubleArray(dArray);
        }
    }

    public static double[] readFloatArray(Value value) {
        if ($assertionsDisabled || value != null) {
            int n = (int)value.sizeDoubles();
            double[] dArray = new double[n];
            for (int i = 0; i < n; ++i) {
                dArray[i] = value.getDouble(i);
            }
            return dArray;
        }
        throw new AssertionError((Object)"null x");
    }

    public static Value createFloatRecord(double ... dArray) {
        assert (dArray != null) : "null x";
        {
            return Helpers.createFloatArray(dArray);
        }
    }

    public static double[] readFloatRecord(Value value) {
        assert (value != null) : "null x";
        {
            return Helpers.readFloatArray(value);
        }
    }

    public static double getFloat(Value value, int n) {
        assert (value != null) : "null x";
        {
            return value.getDouble(n);
        }
    }

    public static void setFloat(Value value, int n, double d) {
        if ($assertionsDisabled || value != null) {
            value.setDouble(n, d);
            return;
        }
        throw new AssertionError((Object)"null x");
    }

    public static Value createArray(Value ... valueArray) {
        if ($assertionsDisabled || valueArray != null) {
            int n = valueArray.length;
            Value value = Value.createBlock(0, n);
            for (int i = 0; i < n; ++i) {
                value.set(i, valueArray[i]);
            }
            return value;
        }
        throw new AssertionError((Object)"null x");
    }

    public static Value[] readArray(Value value) {
        if ($assertionsDisabled || value != null) {
            int n = (int)value.sizeValues();
            Value[] valueArray = new Value[n];
            for (int i = 0; i < n; ++i) {
                valueArray[i] = value.get(i);
            }
            return valueArray;
        }
        throw new AssertionError((Object)"null x");
    }

    public static Value createTuple(Value ... valueArray) {
        assert (valueArray != null) : "null x";
        {
            return Helpers.createArray(valueArray);
        }
    }

    public static Value[] readTuple(Value value) {
        assert (value != null) : "null x";
        {
            return Helpers.readArray(value);
        }
    }

    public static Value get(Value value, int n) {
        assert (value != null) : "null x";
        {
            return value.get(n);
        }
    }

    public static void set(Value value, int n, Value value2) {
        if ($assertionsDisabled || value != null) {
            if ($assertionsDisabled || value2 != null) {
                value.set(n, value2);
                return;
            }
            throw new AssertionError((Object)"null v");
        }
        throw new AssertionError((Object)"null x");
    }

    public static Value createList(Value ... valueArray) {
        if ($assertionsDisabled || valueArray != null) {
            Value value = Value.EMPTY_LIST;
            int n = valueArray.length;
            for (int i = n - 1; i >= 0; --i) {
                value = Value.createBlock(0, valueArray[i], value);
            }
            return value;
        }
        throw new AssertionError((Object)"null x");
    }

    public static Value createList(List<Value> list) {
        if ($assertionsDisabled || list != null) {
            ListIterator<Value> listIterator = list.listIterator(list.size());
            Value value = Value.EMPTY_LIST;
            while (listIterator.hasPrevious()) {
                value = Value.createBlock(0, listIterator.previous(), value);
            }
            return value;
        }
        throw new AssertionError((Object)"null x");
    }

    public static List<Value> readList(Value value) {
        if ($assertionsDisabled || value != null) {
            LinkedList<Value> linkedList = new LinkedList<Value>();
            for (Value value2 = value; value2 != Value.EMPTY_LIST; value2 = value2.get1()) {
                linkedList.add(value2.get0());
            }
            return linkedList;
        }
        throw new AssertionError((Object)"null x");
    }

    public static Value createImage(BufferedImage bufferedImage) {
        assert (bufferedImage != null) : "null bi";
        {
            return Value.createCustom(CustomImage.OPS, 16L, bufferedImage);
        }
    }

    public static BufferedImage readImage(Value value) {
        assert (value != null) : "null x";
        {
            return (BufferedImage)value.asCustom();
        }
    }

    public static Frame getFrame(Interpreter interpreter) {
        if ($assertionsDisabled || interpreter != null) {
            GraphSlot graphSlot = (GraphSlot)interpreter.getContext().getCodeState().getSlot(GraphSlot.SLOT);
            return graphSlot != null ? graphSlot.getFrame() : null;
        }
        throw new AssertionError((Object)"null interp");
    }

    public static Canvas getCanvas(Interpreter interpreter) {
        if ($assertionsDisabled || interpreter != null) {
            GraphSlot graphSlot = (GraphSlot)interpreter.getContext().getCodeState().getSlot(GraphSlot.SLOT);
            return graphSlot != null ? graphSlot.getCanvas() : null;
        }
        throw new AssertionError((Object)"null interp");
    }

    public static BufferedImage getBuffer(Interpreter interpreter) {
        if ($assertionsDisabled || interpreter != null) {
            GraphSlot graphSlot = (GraphSlot)interpreter.getContext().getCodeState().getSlot(GraphSlot.SLOT);
            return graphSlot != null ? graphSlot.getBuffer() : null;
        }
        throw new AssertionError((Object)"null interp");
    }
}

