/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.stdlib;

import java.util.Arrays;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.util.IntegerUtils;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="stdlib", module="String", source="byterun/str.c")
public final class Str {
    private Str() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string"}, returnType="int")
    public static Value caml_ml_string_length(Value value) {
        return value.sizeBytesWrapped();
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"int"}, returnType="string")
    public static Value caml_create_string(Value value) throws Fail.Exception {
        long l = value.asLong();
        if (l > 0x1FFFFFFFFFFFFF7L) {
            Fail.invalidArgument("String.create");
        }
        return Value.createString(l);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string", "int"}, returnType="char")
    public static Value caml_string_get(Value value, Value value2) throws Fail.Exception {
        long l = value2.asLong();
        if (l < 0L || l >= value.sizeBytes()) {
            Fail.arrayBoundError();
        }
        return Value.createLong(value.getUnsignedByte(l));
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string", "int", "char"}, returnType="unit")
    public static Value caml_string_set(Value value, Value value2, Value value3) throws Fail.Exception {
        long l = value2.asLong();
        if (l < 0L || l >= value.sizeBytes()) {
            Fail.arrayBoundError();
        }
        value.setUnsignedByte(l, value3.asCastedInt());
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string", "string"}, returnType="bool")
    public static Value caml_string_equal(Value value, Value value2) {
        byte[] byArray;
        long l = value.sizeBytes();
        long l2 = value2.sizeBytes();
        if (l > Integer.MAX_VALUE || l2 > Integer.MAX_VALUE) {
            if (l != l2) {
                return Value.FALSE;
            }
            long l3 = 0L;
            while (true) {
                if (l3 >= l || value.getByte(l3) != value2.getByte(l3)) {
                    return l3 == l ? Value.TRUE : Value.FALSE;
                }
                ++l3;
            }
        }
        byte[] byArray2 = value.getBytes();
        if (byArray2 == (byArray = value2.getBytes())) {
            return Value.TRUE;
        }
        int n = byArray2.length;
        if (n != byArray.length) {
            return Value.FALSE;
        }
        return Arrays.equals(byArray2, byArray) ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string", "string"}, returnType="bool")
    public static Value caml_string_notequal(Value value, Value value2) {
        return Str.caml_string_equal(value, value2) == Value.TRUE ? Value.FALSE : Value.TRUE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string", "string"}, returnType="int")
    public static Value caml_string_compare(Value value, Value value2) {
        return Value.createLong(Str.compare(value, value2));
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string", "string"}, returnType="bool")
    public static Value caml_string_lessthan(Value value, Value value2) {
        return Str.compare(value, value2) < 0 ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string", "string"}, returnType="bool")
    public static Value caml_string_lessequal(Value value, Value value2) {
        return Str.compare(value, value2) <= 0 ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string", "string"}, returnType="bool")
    public static Value caml_string_greaterthan(Value value, Value value2) {
        return Str.compare(value, value2) > 0 ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string", "string"}, returnType="bool")
    public static Value caml_string_greaterequal(Value value, Value value2) {
        return Str.compare(value, value2) >= 0 ? Value.TRUE : Value.FALSE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string", "int", "string", "int", "int"}, returnType="bool")
    public static Value caml_blit_string(Value value, Value value2, Value value3, Value value4, Value value5) {
        long l = value.sizeBytes();
        long l2 = value3.sizeBytes();
        if (l > Integer.MAX_VALUE || l2 > Integer.MAX_VALUE) {
            long l3 = value2.asLong();
            long l4 = value4.asLong();
            long l5 = value5.asLong();
            int n = 0;
            while ((long)n < l5) {
                value3.setByte((long)n + l4, value.getByte((long)n + l3));
                ++n;
            }
            return Value.UNIT;
        }
        System.arraycopy(value.getBytes(), value2.asCastedInt(), value3.getBytesForModification(), value4.asCastedInt(), value5.asCastedInt());
        return Value.UNIT;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string", "int", "int", "char"}, returnType="unit")
    public static Value caml_fill_string(Value value, Value value2, Value value3, Value value4) {
        long l = value.sizeBytes();
        if (l > Integer.MAX_VALUE) {
            long l2 = value2.asLong();
            long l3 = l2 + value3.asLong();
            byte by = (byte)IntegerUtils.unsignedToSignedByte(value4.asCastedInt() & 0xFF);
            for (long i = l2; i < l3; ++i) {
                value.setByte(i, by);
            }
            return Value.UNIT;
        } else {
            int n = value2.asCastedInt();
            int n2 = n + value3.asCastedInt();
            byte by = (byte)IntegerUtils.unsignedToSignedByte(value4.asCastedInt() & 0xFF);
            byte[] byArray = value.getBytesForModification();
            for (int i = n; i < n2; ++i) {
                byArray[i] = by;
            }
        }
        return Value.UNIT;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Primitive(compatibility=PrimitiveCompatibility.FULL, comment={"No locale is used."}, parameterTypes={"char"}, returnType="bool")
    public static Value caml_is_printable(Value value) {
        Value value2;
        int n = value.asCastedInt() & 0xFF;
        if (n < 32 || n > 126) {
            value2 = Value.FALSE;
            return value2;
        }
        value2 = Value.TRUE;
        return value2;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string", "int"}, returnType="bool")
    public static Value caml_bitvect_test(Value value, Value value2) {
        long l = value2.asLong();
        return (value.getUnsignedByte(l >> 3) & 1 << (int)(l & 7L)) != 0 ? Value.TRUE : Value.FALSE;
    }

    static int compare(Value value, Value value2) {
        block9: {
            long l = value.sizeBytes();
            long l2 = value2.sizeBytes();
            if (l <= Integer.MAX_VALUE && l2 <= Integer.MAX_VALUE) break block9;
            long l3 = Math.min(l, l2);
            long l4 = 0L;
            while (true) {
                block10: {
                    int n;
                    block12: {
                        block13: {
                            block11: {
                                if (l4 < l3 && value.getByte(l4) == value2.getByte(l4)) break block10;
                                if (l4 >= l3) break block11;
                                n = IntegerUtils.signedToUnsignedByte(value.getByte(l4)) - IntegerUtils.signedToUnsignedByte(value2.getByte(l4));
                                if (n >= 0) break block12;
                                break block13;
                            }
                            if (l < l2) {
                                return -1;
                            }
                            if (l > l2) {
                                return 1;
                            }
                            return 0;
                        }
                        return -1;
                    }
                    if (n > 0) {
                        return 1;
                    }
                    return 0;
                }
                ++l4;
            }
        }
        byte[] byArray = value.getBytes();
        byte[] byArray2 = value2.getBytes();
        if (byArray == byArray2) {
            return 0;
        }
        int n = byArray.length;
        int n2 = byArray2.length;
        int n3 = Math.min(n, n2);
        int n4 = 0;
        while (true) {
            block14: {
                int n5;
                block16: {
                    block17: {
                        block15: {
                            if (n4 < n3 && byArray[n4] == byArray2[n4]) break block14;
                            if (n4 >= n3) break block15;
                            n5 = IntegerUtils.signedToUnsignedByte(byArray[n4]) - IntegerUtils.signedToUnsignedByte(byArray2[n4]);
                            if (n5 >= 0) break block16;
                            break block17;
                        }
                        if (n < n2) {
                            return -1;
                        }
                        if (n > n2) {
                            return 1;
                        }
                        return 0;
                    }
                    return -1;
                }
                if (n5 > 0) {
                    return 1;
                }
                return 0;
            }
            ++n4;
        }
    }
}

