/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.annotations.parameters;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.ocamljava.runtime.annotations.parameters.BooleanParameter;
import org.ocamljava.runtime.annotations.parameters.InputStreamParameter;
import org.ocamljava.runtime.annotations.parameters.IntegerParameter;
import org.ocamljava.runtime.annotations.parameters.OutputStreamParameter;
import org.ocamljava.runtime.annotations.parameters.ParameterComponents;
import org.ocamljava.runtime.annotations.parameters.SimpleParameter;
import org.ocamljava.runtime.annotations.parameters.StringParameter;
import org.ocamljava.runtime.kernel.OCamlJavaException;
import org.ocamljava.runtime.kernel.ParameterException;
import org.ocamljava.runtime.parameters.ByteCodeParameters;
import org.ocamljava.runtime.parameters.CommonParameters;
import org.ocamljava.runtime.parameters.NativeParameters;
import org.ocamljava.runtime.util.ShellUtils;

public final class Parameters {
    private static final String SHORT_ARG_PREFIX = "-";
    private static final String LONG_ARG_PREFIX = "--";
    private static final String ARG_SEPARATOR = "=";
    private static final String DIALOG_TITLE = "Interpreter parameters";
    private static final int DIALOG_BORDER = 16;

    private Parameters() {
    }

    public static ByteCodeParameters defaultByteCodeParameters() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Object object = Parameters.newProxyInstance(ByteCodeParameters.class, hashMap, null);
        return (ByteCodeParameters)object;
    }

    public static NativeParameters defaultNativeParameters() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Object object = Parameters.newProxyInstance(NativeParameters.class, hashMap, null);
        return (NativeParameters)object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ByteCodeParameters fromArray(String[] stringArray, File file) throws ParameterException {
        String string;
        boolean bl;
        assert (stringArray != null) : "null args";
        Method[] methodArray = ByteCodeParameters.class.getMethods();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        int n = stringArray.length;
        int n2 = 0;
        block2: do {
            boolean bl2;
            String[] stringArray2;
            block12: {
                String[] stringArray3;
                block11: {
                    block9: {
                        block10: {
                            block8: {
                                if (n2 >= n || !stringArray[n2].startsWith(SHORT_ARG_PREFIX)) break block8;
                                if (!stringArray[n2].startsWith(LONG_ARG_PREFIX)) break block9;
                                break block10;
                            }
                            hashMap.put("FILE", n2 < n ? stringArray[n2] : null);
                            int n3 = n - n2;
                            stringArray2 = new String[n3];
                            System.arraycopy(stringArray, n2, stringArray2, 0, n3);
                            if (file != null) {
                                try {
                                    stringArray2 = ShellUtils.expandCommandLine(file, stringArray2);
                                }
                                catch (IOException iOException) {}
                            }
                            hashMap.put("ARGUMENTS", stringArray2);
                            Object object = Parameters.newProxyInstance(ByteCodeParameters.class, hashMap, null);
                            return (ByteCodeParameters)object;
                        }
                        if ((stringArray3 = stringArray[n2++].split(ARG_SEPARATOR)).length > 2) {
                            throw new ParameterException("invalid switch format");
                        }
                        break block11;
                    }
                    string = stringArray[n2++].substring(SHORT_ARG_PREFIX.length());
                    stringArray2 = n2 < n ? stringArray[n2] : null;
                    bl2 = true;
                    break block12;
                }
                string = stringArray3[0].substring(LONG_ARG_PREFIX.length());
                stringArray2 = stringArray3.length > 1 ? stringArray3[1] : null;
                bl2 = false;
            }
            if ("".equals(string)) {
                throw new ParameterException("invalid switch name");
            }
            bl = false;
            for (Method method : methodArray) {
                if (!string.equals(Parameters.getCommandLineSwitch(method))) continue;
                bl = true;
                hashMap.put(Parameters.getKey(method), Parameters.convertValue((String)stringArray2, method));
                if (!bl2 || method.getAnnotation(SimpleParameter.class) != null) continue block2;
                ++n2;
                continue block2;
            }
        } while (bl);
        throw new ParameterException(String.format("unknown switch '%s'", string));
    }

    public static ByteCodeParameters fromProperties(Properties properties) throws ParameterException {
        Method[] methodArray = ByteCodeParameters.class.getMethods();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Object object = properties.entrySet().iterator();
        block0: while (true) {
            if (!object.hasNext()) {
                object = Parameters.newProxyInstance(ByteCodeParameters.class, hashMap, null);
                return (ByteCodeParameters)object;
            }
            Map.Entry<Object, Object> entry = object.next();
            Method[] methodArray2 = methodArray;
            int n = methodArray2.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) continue block0;
                Method method = methodArray2[n2];
                if (entry.getKey().equals(Parameters.getCommandLineSwitch(method))) {
                    hashMap.put(Parameters.getKey(method), Parameters.convertValue((String)entry.getValue(), method));
                }
                ++n2;
            }
            break;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static NativeParameters fromStream(InputStream var0, String[] var1_1, InputStream var2_2, PrintStream var3_3, PrintStream var4_4, boolean var5_5, String var6_6, Class<?> var7_7) throws OCamlJavaException {
        if (!Parameters.$assertionsDisabled && var0 == null) {
            throw new AssertionError((Object)"null is");
        }
        if (!Parameters.$assertionsDisabled && var1_1 == null) {
            throw new AssertionError((Object)"null args");
        }
        if (!Parameters.$assertionsDisabled && var2_2 == null) {
            throw new AssertionError((Object)"null in");
        }
        if (!Parameters.$assertionsDisabled && var3_3 == null) {
            throw new AssertionError((Object)"null out");
        }
        if (!Parameters.$assertionsDisabled && var4_4 == null) {
            throw new AssertionError((Object)"null err");
        }
        if (!Parameters.$assertionsDisabled && var6_6 == null) {
            throw new AssertionError((Object)"null file");
        }
        if (!Parameters.$assertionsDisabled && var7_7 == null) {
            throw new AssertionError((Object)"null base");
        }
        try {
            var8_8 = new Properties();
            var8_8.load(var0);
            var9_10 = NativeParameters.class.getMethods();
            var10_11 = new HashMap<String, Object>();
            var11_12 = var8_8.entrySet().iterator();
            while (true) {
                if (!var11_12.hasNext()) break;
                ** GOTO lbl50
                break;
            }
        }
        catch (IOException var8_9) {
            throw new OCamlJavaException("unable to load parameters", var8_9);
        }
        {
            var11_13 = var1_1.length;
            var12_14 = new String[var11_13 + 1];
            System.arraycopy(var1_1, 0, var12_14, 1, var11_13);
            try {
                var13_15 /* !! */  = var7_7.getProtectionDomain().getCodeSource().getLocation().toURI().getPath().toString();
lbl31:
                // 2 sources

                while (true) {
                    var12_14[0] = var13_15 /* !! */ ;
                    var10_11.put("ARGUMENTS", var12_14);
                    break;
                }
            }
            catch (Throwable var14_17) {
                var13_15 /* !! */  = var6_6;
                ** continue;
            }
            {
                var10_11.put("IN", var2_2);
                var10_11.put("OUT", var3_3);
                var10_11.put("ERR", var4_4);
            }
            var10_11.put("BARE_CANVAS", var5_5 != false ? Boolean.TRUE : Boolean.FALSE);
            var10_11.put("FILE", var6_6);
            var14_18 = Parameters.newProxyInstance(NativeParameters.class, var10_11, null);
            return (NativeParameters)var14_18;
lbl50:
            // 1 sources

            var12_14 = var11_12.next();
            var13_15 /* !! */  = var9_10;
            var14_16 = var13_15 /* !! */ .length;
            var15_19 = 0;
            while (true) {
                if (var15_19 >= var14_16) ** continue;
                var16_20 = var13_15 /* !! */ [var15_19];
                var17_21 = Parameters.getCommandLineSwitch(var16_20);
                if (var12_14.getKey().equals(var17_21)) {
                    var10_11.put(Parameters.getKey(var16_20), Parameters.convertValue((String)var12_14.getValue(), var16_20));
                }
                ++var15_19;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static ByteCodeParameters fromDialog(ByteCodeParameters byteCodeParameters) throws ParameterException {
        Object object;
        assert (byteCodeParameters != null) : "null bcp";
        Method[] methodArray = ByteCodeParameters.class.getMethods();
        int n = 0;
        Object object2 = methodArray;
        int n2 = ((Method[])object2).length;
        int n3 = 0;
        while (true) {
            if (n3 >= n2) break;
            Method method = object2[n3];
            object = Parameters.getGUILabel(method);
            if (object != null && !((String)object).equals("")) {
                ++n;
            }
            ++n3;
        }
        object2 = new JDialog((Frame)null, DIALOG_TITLE, true);
        ((JDialog)object2).setDefaultCloseOperation(3);
        JPanel jPanel = new JPanel(new GridLayout(n, 2, 4, 4));
        JComponent[] jComponentArray = new JComponent[n];
        int n4 = 0;
        object = methodArray;
        int n5 = ((Method[])object).length;
        int n6 = 0;
        while (true) {
            block8: {
                Object object3;
                Object object4;
                block9: {
                    block7: {
                        if (n6 >= n5) break block7;
                        object4 = object[n6];
                        object3 = Parameters.getGUILabel((Method)object4);
                        if (object3 == null || ((String)object3).equals("")) break block8;
                        break block9;
                    }
                    object = new JPanel(new BorderLayout());
                    JButton jButton = new JButton("OK");
                    jButton.addActionListener(new ActionListener((JDialog)object2){
                        final /* synthetic */ JDialog val$dlg;
                        {
                            this.val$dlg = jDialog;
                        }

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            this.val$dlg.setVisible(false);
                        }
                    });
                    ((Container)object).add(Box.createHorizontalGlue(), "Center");
                    ((Container)object).add((Component)jButton, "East");
                    JPanel jPanel2 = new JPanel(new BorderLayout());
                    jPanel2.add((Component)jPanel, "Center");
                    jPanel2.add((Component)object, "South");
                    object4 = ((JDialog)object2).getContentPane();
                    ((Container)object4).add(Box.createVerticalStrut(16), "North");
                    ((Container)object4).add(Box.createVerticalStrut(16), "South");
                    ((Container)object4).add(Box.createHorizontalStrut(16), "East");
                    ((Container)object4).add(Box.createHorizontalStrut(16), "West");
                    ((Container)object4).add((Component)jPanel2, "Center");
                    ((Window)object2).pack();
                    ((Dialog)object2).setResizable(false);
                    ((Dialog)object2).setVisible(true);
                    object3 = new HashMap();
                    int n7 = 0;
                    Method[] methodArray2 = methodArray;
                    int n8 = methodArray2.length;
                    int n9 = 0;
                    while (true) {
                        if (n9 >= n8) {
                            Object object5 = Parameters.newProxyInstance(ByteCodeParameters.class, (Map<String, Object>)object3, byteCodeParameters);
                            return (ByteCodeParameters)object5;
                        }
                        Method method = methodArray2[n9];
                        String string = Parameters.getGUILabel(method);
                        if (string != null && !string.equals("")) {
                            JComponent jComponent = jComponentArray[n7++];
                            object3.put(Parameters.getKey(method), ParameterComponents.readComponentValue(method, jComponent));
                        }
                        ++n9;
                    }
                }
                JComponent jComponent = ParameterComponents.createComponent((Method)object4, byteCodeParameters);
                jPanel.add(new JLabel((String)object3, 4));
                jPanel.add(jComponent);
                jComponentArray[n4++] = jComponent;
            }
            ++n6;
        }
    }

    public static ByteCodeParameters setFile(ByteCodeParameters byteCodeParameters, String string) {
        assert (byteCodeParameters != null) : "null bcp";
        {
            return Parameters.setByteCodeParameter(byteCodeParameters, "FILE", string);
        }
    }

    public static NativeParameters setFile(NativeParameters nativeParameters, String string) {
        assert (nativeParameters != null) : "null np";
        {
            return Parameters.setNativeParameter(nativeParameters, "FILE", string);
        }
    }

    public static ByteCodeParameters setUnparsedElements(ByteCodeParameters byteCodeParameters, String[] stringArray) {
        if ($assertionsDisabled || byteCodeParameters != null) {
            assert (stringArray != null) : "null value";
            {
                return Parameters.setByteCodeParameter(byteCodeParameters, "ARGUMENTS", stringArray);
            }
        }
        throw new AssertionError((Object)"null bcp");
    }

    public static NativeParameters setUnparsedElements(NativeParameters nativeParameters, String[] stringArray) {
        if ($assertionsDisabled || nativeParameters != null) {
            assert (stringArray != null) : "null value";
            {
                return Parameters.setNativeParameter(nativeParameters, "ARGUMENTS", stringArray);
            }
        }
        throw new AssertionError((Object)"null np");
    }

    public static ByteCodeParameters setBooleanParameter(ByteCodeParameters byteCodeParameters, CommonParameters.BooleanParameterID booleanParameterID, boolean bl) {
        if ($assertionsDisabled || byteCodeParameters != null) {
            assert (booleanParameterID != null) : "null id";
            {
                return Parameters.setByteCodeParameter(byteCodeParameters, booleanParameterID.name(), bl);
            }
        }
        throw new AssertionError((Object)"null bcp");
    }

    public static NativeParameters setBooleanParameter(NativeParameters nativeParameters, CommonParameters.BooleanParameterID booleanParameterID, boolean bl) {
        if ($assertionsDisabled || nativeParameters != null) {
            assert (booleanParameterID != null) : "null id";
            {
                return Parameters.setNativeParameter(nativeParameters, booleanParameterID.name(), bl);
            }
        }
        throw new AssertionError((Object)"null np");
    }

    public static ByteCodeParameters setBooleanParameter(ByteCodeParameters byteCodeParameters, ByteCodeParameters.BooleanParameterID booleanParameterID, boolean bl) {
        if ($assertionsDisabled || byteCodeParameters != null) {
            assert (booleanParameterID != null) : "null id";
            {
                return Parameters.setByteCodeParameter(byteCodeParameters, booleanParameterID.name(), bl);
            }
        }
        throw new AssertionError((Object)"null bcp");
    }

    public static NativeParameters setBooleanParameter(NativeParameters nativeParameters, NativeParameters.BooleanParameterID booleanParameterID, boolean bl) {
        if ($assertionsDisabled || nativeParameters != null) {
            assert (booleanParameterID != null) : "null id";
            {
                return Parameters.setNativeParameter(nativeParameters, booleanParameterID.name(), bl);
            }
        }
        throw new AssertionError((Object)"null np");
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    public static ByteCodeParameters setIntegerParameter(ByteCodeParameters byteCodeParameters, ByteCodeParameters.IntegerParameterID integerParameterID, int n) throws ParameterException {
        Method[] methodArray;
        assert (byteCodeParameters != null) : "null bcp";
        assert (integerParameterID != null) : "null id";
        Method[] methodArray2 = methodArray = ByteCodeParameters.class.getMethods();
        int n2 = methodArray2.length;
        int n3 = 0;
        while (n3 < n2) {
            IntegerParameter integerParameter;
            Method method = methodArray2[n3];
            if (integerParameterID.name().equals(Parameters.getKey(method)) && n < (integerParameter = method.getAnnotation(IntegerParameter.class)).minValue()) {
                if (n > integerParameter.maxValue()) throw new ParameterException("integer value out of range");
            }
            ++n3;
        }
        return Parameters.setByteCodeParameter(byteCodeParameters, integerParameterID.name(), n);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static ByteCodeParameters setStringParameter(ByteCodeParameters byteCodeParameters, CommonParameters.StringParameterID stringParameterID, String string) throws ParameterException {
        Method[] methodArray;
        assert (byteCodeParameters != null) : "null bcp";
        assert (stringParameterID != null) : "null id";
        assert (string != null) : "null value";
        Method[] methodArray2 = methodArray = ByteCodeParameters.class.getMethods();
        int n = methodArray2.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray2[n2];
            if (stringParameterID.name().equals(Parameters.getKey(method))) {
                int n3;
                StringParameter stringParameter = method.getAnnotation(StringParameter.class);
                String[] stringArray = stringParameter.possibleValues();
                int n4 = stringArray.length;
                for (n3 = 0; n3 < n4 && !stringArray[n3].equals(string); ++n3) {
                }
                if (n4 > 0 && n3 == n4) {
                    throw new ParameterException("invalid string value");
                }
            }
            ++n2;
        }
        return Parameters.setByteCodeParameter(byteCodeParameters, stringParameterID.name(), string);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static NativeParameters setStringParameter(NativeParameters nativeParameters, CommonParameters.StringParameterID stringParameterID, String string) throws ParameterException {
        Method[] methodArray;
        assert (nativeParameters != null) : "null np";
        assert (stringParameterID != null) : "null id";
        assert (string != null) : "null value";
        Method[] methodArray2 = methodArray = ByteCodeParameters.class.getMethods();
        int n = methodArray2.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray2[n2];
            if (stringParameterID.name().equals(Parameters.getKey(method))) {
                int n3;
                StringParameter stringParameter = method.getAnnotation(StringParameter.class);
                String[] stringArray = stringParameter.possibleValues();
                int n4 = stringArray.length;
                for (n3 = 0; n3 < n4 && !stringArray[n3].equals(string); ++n3) {
                }
                if (n4 > 0 && n3 == n4) {
                    throw new ParameterException("invalid string value");
                }
            }
            ++n2;
        }
        return Parameters.setNativeParameter(nativeParameters, stringParameterID.name(), string);
    }

    public static ByteCodeParameters setInputStreamParameter(ByteCodeParameters byteCodeParameters, CommonParameters.InputStreamParameterID inputStreamParameterID, InputStream inputStream) {
        if ($assertionsDisabled || byteCodeParameters != null) {
            if ($assertionsDisabled || inputStreamParameterID != null) {
                assert (inputStream != null) : "null value";
                {
                    return Parameters.setByteCodeParameter(byteCodeParameters, inputStreamParameterID.name(), inputStream);
                }
            }
            throw new AssertionError((Object)"null id");
        }
        throw new AssertionError((Object)"null bcp");
    }

    public static NativeParameters setInputStreamParameter(NativeParameters nativeParameters, CommonParameters.InputStreamParameterID inputStreamParameterID, InputStream inputStream) {
        if ($assertionsDisabled || nativeParameters != null) {
            if ($assertionsDisabled || inputStreamParameterID != null) {
                assert (inputStream != null) : "null value";
                {
                    return Parameters.setNativeParameter(nativeParameters, inputStreamParameterID.name(), inputStream);
                }
            }
            throw new AssertionError((Object)"null id");
        }
        throw new AssertionError((Object)"null np");
    }

    public static ByteCodeParameters setPrintStreamParameter(ByteCodeParameters byteCodeParameters, CommonParameters.PrintStreamParameterID printStreamParameterID, PrintStream printStream) {
        if ($assertionsDisabled || byteCodeParameters != null) {
            if ($assertionsDisabled || printStreamParameterID != null) {
                assert (printStream != null) : "null value";
                {
                    return Parameters.setByteCodeParameter(byteCodeParameters, printStreamParameterID.name(), printStream);
                }
            }
            throw new AssertionError((Object)"null id");
        }
        throw new AssertionError((Object)"null bcp");
    }

    public static NativeParameters setPrintStreamParameter(NativeParameters nativeParameters, CommonParameters.PrintStreamParameterID printStreamParameterID, PrintStream printStream) {
        if ($assertionsDisabled || nativeParameters != null) {
            if ($assertionsDisabled || printStreamParameterID != null) {
                assert (printStream != null) : "null value";
                {
                    return Parameters.setNativeParameter(nativeParameters, printStreamParameterID.name(), printStream);
                }
            }
            throw new AssertionError((Object)"null id");
        }
        throw new AssertionError((Object)"null np");
    }

    private static ByteCodeParameters setByteCodeParameter(ByteCodeParameters byteCodeParameters, String string, Object object) {
        if ($assertionsDisabled || byteCodeParameters != null) {
            assert (string != null) : "null name";
            {
                return (ByteCodeParameters)Parameters.setParameter(byteCodeParameters, ByteCodeParameters.class, string, object);
            }
        }
        throw new AssertionError((Object)"null bcp");
    }

    private static NativeParameters setNativeParameter(NativeParameters nativeParameters, String string, Object object) {
        if ($assertionsDisabled || nativeParameters != null) {
            assert (string != null) : "null name";
            {
                return (NativeParameters)Parameters.setParameter(nativeParameters, NativeParameters.class, string, object);
            }
        }
        throw new AssertionError((Object)"null np");
    }

    private static Object setParameter(Object object, Class<?> clazz, String string, Object object2) {
        if ($assertionsDisabled || object != null) {
            if ($assertionsDisabled || clazz != null) {
                if ($assertionsDisabled || string != null) {
                    try {
                        MapProxy mapProxy = (MapProxy)Proxy.getInvocationHandler(object);
                        HashMap<String, Object> hashMap = new HashMap<String, Object>(mapProxy.values);
                        hashMap.put(string, object2);
                        Object object3 = Parameters.newProxyInstance(clazz, hashMap, mapProxy.fallbackInstance);
                        return object3;
                    }
                    catch (Throwable throwable) {
                        HashMap<String, Object> hashMap = new HashMap<String, Object>();
                        hashMap.put(string, object2);
                        Object object4 = Parameters.newProxyInstance(clazz, hashMap, object);
                        return object4;
                    }
                }
                throw new AssertionError((Object)"null name");
            }
            throw new AssertionError((Object)"null cls");
        }
        throw new AssertionError((Object)"null params");
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void printUsage(boolean bl, PrintStream printStream) {
        String string;
        String string2;
        String string3;
        assert (printStream != null) : "null out";
        if (bl) {
            printStream.println("\\begin{enumerate}");
        } else {
            printStream.printf("OCaml-Java version %s (c) %s, %s\n", "2.0-early-access5", "Xavier Clerc", "2007-2013");
            printStream.printf("homepage: %s -- contact: %s\n", "http://www.ocamljava.org", "xclerc@ocamljava.org");
            printStream.println("usage: <interpreter arguments> <filename> <application arguments>");
            printStream.println("possible interpreter arguments:");
        }
        if (bl) {
            string3 = "  \\item[] \\texttt{";
            string2 = "} or \\texttt{";
            string = "} \\\\";
        } else {
            string3 = "  ";
            string2 = "\n  ";
            string = "";
        }
        Method[] methodArray = ByteCodeParameters.class.getMethods();
        Arrays.sort(methodArray, new Comparator<Method>(){

            @Override
            public int compare(Method method, Method method2) {
                String string = Parameters.getCommandLineSwitch(method);
                String string2 = string != null ? string : "";
                String string3 = Parameters.getCommandLineSwitch(method2);
                String string4 = string3 != null ? string3 : "";
                return string2.compareTo(string4);
            }
        });
        Method[] methodArray2 = methodArray;
        int n = methodArray2.length;
        int n2 = 0;
        while (true) {
            StringParameter stringParameter;
            IntegerParameter integerParameter;
            BooleanParameter booleanParameter;
            if (n2 >= n) {
                if (!bl) return;
                printStream.println("\\end{enumerate}");
                return;
            }
            Method method = methodArray2[n2];
            SimpleParameter simpleParameter = method.getAnnotation(SimpleParameter.class);
            if (simpleParameter != null && !simpleParameter.commandLineSwitch().equals("")) {
                printStream.printf("%s-%s%s--%s%s\n", string3, simpleParameter.commandLineSwitch(), string2, simpleParameter.commandLineSwitch(), string);
                printStream.printf("        %s\n", simpleParameter.description());
            }
            if ((booleanParameter = method.getAnnotation(BooleanParameter.class)) != null && !booleanParameter.commandLineSwitch().equals("")) {
                printStream.printf("%s-%s <on|off>%s--%s=<on|off>  default:%s%s\n", string3, booleanParameter.commandLineSwitch(), string2, booleanParameter.commandLineSwitch(), booleanParameter.defaultValue() ? "on" : "off", string);
                printStream.printf("        %s\n", booleanParameter.description());
            }
            if ((integerParameter = method.getAnnotation(IntegerParameter.class)) != null && !integerParameter.commandLineSwitch().equals("")) {
                printStream.printf("%s-%s <integer>%s--%s=<integer>  default:%d%s\n", string3, integerParameter.commandLineSwitch(), string2, integerParameter.commandLineSwitch(), integerParameter.defaultValue(), string);
                printStream.printf("        %s\n", integerParameter.description());
            }
            if ((stringParameter = method.getAnnotation(StringParameter.class)) != null && !stringParameter.commandLineSwitch().equals("")) {
                String string4 = stringParameter.defaultValue();
                printStream.printf("%s-%s <%s>%s--%s=<%s>%s%s\n", string3, stringParameter.commandLineSwitch(), stringParameter.argumentDescription(), string2, stringParameter.commandLineSwitch(), stringParameter.argumentDescription(), string4.equals("") ? "" : "  default:" + string4, string);
                printStream.printf("        %s\n", stringParameter.description());
            }
            ++n2;
        }
    }

    private static Object getDefaultValue(Method method) {
        PrintStream printStream;
        block5: {
            block3: {
                block4: {
                    block2: {
                        SimpleParameter simpleParameter = method.getAnnotation(SimpleParameter.class);
                        if (simpleParameter != null) {
                            return Boolean.FALSE;
                        }
                        InputStreamParameter inputStreamParameter = method.getAnnotation(InputStreamParameter.class);
                        if (inputStreamParameter != null) {
                            return System.in;
                        }
                        OutputStreamParameter outputStreamParameter = method.getAnnotation(OutputStreamParameter.class);
                        if (outputStreamParameter == null) break block2;
                        if (!outputStreamParameter.isErrorOutput()) break block3;
                        break block4;
                    }
                    Object object = Parameters.getAnnotationValue(method.getDeclaredAnnotations(), "defaultValue");
                    return object;
                }
                printStream = System.err;
                break block5;
            }
            printStream = System.out;
        }
        return printStream;
    }

    private static String getKey(Method method) {
        assert (method != null) : "null m";
        {
            return (String)Parameters.getAnnotationValue(method.getDeclaredAnnotations(), "key");
        }
    }

    private static String getGUILabel(Method method) {
        assert (method != null) : "null m";
        {
            return (String)Parameters.getAnnotationValue(method.getDeclaredAnnotations(), "guiLabel");
        }
    }

    private static String getCommandLineSwitch(Method method) {
        assert (method != null) : "null m";
        {
            return (String)Parameters.getAnnotationValue(method.getDeclaredAnnotations(), "commandLineSwitch");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Object getAnnotationValue(Annotation[] annotationArray, String string) {
        assert (annotationArray != null) : "null annots";
        assert (string != null) : "null methodName";
        Object object = null;
        Annotation[] annotationArray2 = annotationArray;
        int n = annotationArray2.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray2[n2];
            try {
                object = annotation.getClass().getMethod(string, new Class[0]).invoke((Object)annotation, new Object[0]);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {}
            ++n2;
        }
        return object;
    }

    private static Object convertValue(String string, Method method) throws ParameterException {
        block9: {
            block13: {
                int n;
                block11: {
                    IntegerParameter integerParameter;
                    block12: {
                        block10: {
                            if (!$assertionsDisabled && method == null) break block9;
                            if (method.getAnnotation(BooleanParameter.class) != null) {
                                return Parameters.convertBoolean(string);
                            }
                            if (method.getAnnotation(IntegerParameter.class) == null) break block10;
                            integerParameter = method.getAnnotation(IntegerParameter.class);
                            n = Parameters.convertInteger(string);
                            if (n >= integerParameter.minValue()) break block11;
                            break block12;
                        }
                        if (method.getAnnotation(SimpleParameter.class) != null) {
                            return Boolean.TRUE;
                        }
                        if (method.getAnnotation(StringParameter.class) == null) {
                            throw new ParameterException("unsuppoted parameter");
                        }
                        String[] stringArray = method.getAnnotation(StringParameter.class).possibleValues();
                        int n2 = 0;
                        int n3 = stringArray.length;
                        while (true) {
                            if (n2 >= n3 || stringArray[n2].equals(string)) {
                                if (n3 == 0 || n2 < n3) {
                                    return string;
                                }
                                throw new ParameterException("invalid string value");
                            }
                            ++n2;
                        }
                    }
                    if (n > integerParameter.maxValue()) break block13;
                }
                return n;
            }
            throw new ParameterException("integer value out of range");
        }
        throw new AssertionError((Object)"null meth");
    }

    private static Boolean convertBoolean(String string) throws ParameterException {
        if ("on".equals(string)) {
            return Boolean.TRUE;
        }
        if ("off".equals(string)) {
            return Boolean.FALSE;
        }
        throw new ParameterException("switch value should be either 'on' or 'off'");
    }

    private static Integer convertInteger(String string) throws ParameterException {
        try {
            return Integer.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParameterException("switch value should be an integer");
        }
    }

    private static Object newProxyInstance(Class<?> clazz, Map<String, Object> map, Object object) {
        if ($assertionsDisabled || clazz != null) {
            assert (map != null) : "null map";
            {
                return Proxy.newProxyInstance(Parameters.class.getClassLoader(), new Class[]{clazz}, (InvocationHandler)new MapProxy(map, object));
            }
        }
        throw new AssertionError((Object)"null cls");
    }

    private static final class MapProxy
    implements InvocationHandler {
        private final Map<String, Object> values;
        private final Object fallbackInstance;

        private MapProxy(Map<String, Object> map, Object object) {
            if ($assertionsDisabled || map != null) {
                this.values = map;
                this.fallbackInstance = object;
                return;
            }
            throw new AssertionError((Object)"null v");
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            if (objectArray != null && objectArray.length != 0) throw new IllegalArgumentException("Parameter methods take no parameter");
            Object object3 = this.values.get(Parameters.getKey(method));
            if (object3 != null) return object3;
            try {
                return method.invoke(this.fallbackInstance, new Object[0]);
            }
            catch (Throwable throwable) {
                return Parameters.getDefaultValue(method);
            }
        }
    }
}

